/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.Bounds;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoBBox;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoBBoxFactory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoBaseBBox;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.Membership;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.Plane;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.SerializableObject;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.SidedPlane;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.Vector;

class GeoLongitudeSlice
extends GeoBaseBBox {
    protected final double leftLon;
    protected final double rightLon;
    protected final SidedPlane leftPlane;
    protected final SidedPlane rightPlane;
    protected final SidedPlane backingPlane;
    protected final GeoPoint[] planePoints;
    protected final GeoPoint centerPoint;
    protected final GeoPoint[] edgePoints;

    public GeoLongitudeSlice(PlanetModel planetModel, double leftLon, double rightLon) {
        super(planetModel);
        if (leftLon < -Math.PI || leftLon > Math.PI) {
            throw new IllegalArgumentException("Left longitude out of range");
        }
        if (rightLon < -Math.PI || rightLon > Math.PI) {
            throw new IllegalArgumentException("Right longitude out of range");
        }
        double extent = rightLon - leftLon;
        if (extent < 0.0) {
            extent += Math.PI * 2;
        }
        if (extent > Math.PI) {
            throw new IllegalArgumentException("Width of rectangle too great");
        }
        this.leftLon = leftLon;
        this.rightLon = rightLon;
        double sinLeftLon = Math.sin(leftLon);
        double cosLeftLon = Math.cos(leftLon);
        double sinRightLon = Math.sin(rightLon);
        double cosRightLon = Math.cos(rightLon);
        while (leftLon > rightLon) {
            rightLon += Math.PI * 2;
        }
        double middleLon = (leftLon + rightLon) * 0.5;
        double sinMiddleLon = Math.sin(middleLon);
        double cosMiddleLon = Math.cos(middleLon);
        this.centerPoint = new GeoPoint(planetModel, 0.0, sinMiddleLon, 1.0, cosMiddleLon);
        this.leftPlane = new SidedPlane((Vector)this.centerPoint, cosLeftLon, sinLeftLon);
        this.rightPlane = new SidedPlane((Vector)this.centerPoint, cosRightLon, sinRightLon);
        this.backingPlane = new SidedPlane((Vector)this.centerPoint, cosMiddleLon, sinMiddleLon, 0.0, 0.0);
        this.planePoints = new GeoPoint[]{planetModel.NORTH_POLE, planetModel.SOUTH_POLE};
        this.edgePoints = new GeoPoint[]{planetModel.NORTH_POLE};
    }

    public GeoLongitudeSlice(PlanetModel planetModel, InputStream inputStream) throws IOException {
        this(planetModel, SerializableObject.readDouble(inputStream), SerializableObject.readDouble(inputStream));
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SerializableObject.writeDouble(outputStream, this.leftLon);
        SerializableObject.writeDouble(outputStream, this.rightLon);
    }

    @Override
    public GeoBBox expand(double angle) {
        double currentLonSpan = this.rightLon - this.leftLon;
        if (currentLonSpan < 0.0) {
            currentLonSpan += Math.PI * 2;
        }
        double newLeftLon = this.leftLon - angle;
        double newRightLon = this.rightLon + angle;
        if (currentLonSpan + 2.0 * angle >= Math.PI * 2) {
            newLeftLon = -Math.PI;
            newRightLon = Math.PI;
        }
        return GeoBBoxFactory.makeGeoBBox(this.planetModel, 1.5707963267948966, -1.5707963267948966, newLeftLon, newRightLon);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.backingPlane.isWithin(x, y, z) && this.leftPlane.isWithin(x, y, z) && this.rightPlane.isWithin(x, y, z);
    }

    @Override
    public double getRadius() {
        double extent = this.rightLon - this.leftLon;
        if (extent < 0.0) {
            extent += Math.PI * 2;
        }
        return Math.max(1.5707963267948966, extent * 0.5);
    }

    @Override
    public GeoPoint getCenter() {
        return this.centerPoint;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.planetModel, this.leftPlane, notablePoints, this.planePoints, bounds, this.rightPlane) || p.intersects(this.planetModel, this.rightPlane, notablePoints, this.planePoints, bounds, this.leftPlane);
    }

    @Override
    public boolean intersects(GeoShape geoShape) {
        return geoShape.intersects(this.leftPlane, this.planePoints, this.rightPlane) || geoShape.intersects(this.rightPlane, this.planePoints, this.leftPlane);
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        bounds.addVerticalPlane(this.planetModel, this.leftLon, this.leftPlane, this.rightPlane).addVerticalPlane(this.planetModel, this.rightLon, this.rightPlane, this.leftPlane).addPoint(this.planetModel.NORTH_POLE).addPoint(this.planetModel.SOUTH_POLE);
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double leftDistance = distanceStyle.computeDistance(this.planetModel, (Plane)this.leftPlane, x, y, z, this.rightPlane);
        double rightDistance = distanceStyle.computeDistance(this.planetModel, (Plane)this.rightPlane, x, y, z, this.leftPlane);
        double northDistance = distanceStyle.computeDistance(this.planetModel.NORTH_POLE, x, y, z);
        double southDistance = distanceStyle.computeDistance(this.planetModel.SOUTH_POLE, x, y, z);
        return Math.min(Math.min(northDistance, southDistance), Math.min(leftDistance, rightDistance));
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoLongitudeSlice)) {
            return false;
        }
        GeoLongitudeSlice other = (GeoLongitudeSlice)o;
        return super.equals(other) && other.leftLon == this.leftLon && other.rightLon == this.rightLon;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.leftLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.rightLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "GeoLongitudeSlice: {planetmodel=" + this.planetModel + ", leftlon=" + this.leftLon + "(" + this.leftLon * 180.0 / Math.PI + "), rightlon=" + this.rightLon + "(" + this.rightLon * 180.0 / Math.PI + ")}";
    }
}

