/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.Bounds;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoBBox;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoBBoxFactory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoBaseBBox;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.Membership;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.Plane;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.SerializableObject;

class GeoDegenerateLatitudeZone
extends GeoBaseBBox {
    protected final double latitude;
    protected final double sinLatitude;
    protected final Plane plane;
    protected final GeoPoint interiorPoint;
    protected final GeoPoint[] edgePoints;
    protected static final GeoPoint[] planePoints = new GeoPoint[0];

    public GeoDegenerateLatitudeZone(PlanetModel planetModel, double latitude) {
        super(planetModel);
        this.latitude = latitude;
        this.sinLatitude = Math.sin(latitude);
        double cosLatitude = Math.cos(latitude);
        this.plane = new Plane(planetModel, this.sinLatitude);
        this.interiorPoint = new GeoPoint(planetModel, this.sinLatitude, 0.0, cosLatitude, 1.0);
        this.edgePoints = new GeoPoint[]{this.interiorPoint};
    }

    public GeoDegenerateLatitudeZone(PlanetModel planetModel, InputStream inputStream) throws IOException {
        this(planetModel, SerializableObject.readDouble(inputStream));
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SerializableObject.writeDouble(outputStream, this.latitude);
    }

    @Override
    public GeoBBox expand(double angle) {
        double newTopLat = this.latitude + angle;
        double newBottomLat = this.latitude - angle;
        return GeoBBoxFactory.makeGeoBBox(this.planetModel, newTopLat, newBottomLat, -Math.PI, Math.PI);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return Math.abs(z - this.sinLatitude) < 1.0E-10;
    }

    @Override
    public double getRadius() {
        return Math.PI;
    }

    @Override
    public GeoPoint getCenter() {
        return this.interiorPoint;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        return p.intersects(this.planetModel, this.plane, notablePoints, planePoints, bounds, new Membership[0]);
    }

    @Override
    public boolean intersects(GeoShape geoShape) {
        return geoShape.intersects(this.plane, planePoints, new Membership[0]);
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        bounds.noLongitudeBound().addHorizontalPlane(this.planetModel, this.latitude, this.plane, new Membership[0]);
    }

    @Override
    public int getRelationship(GeoShape path) {
        if (this.intersects(path)) {
            return 2;
        }
        if (path.isWithin(this.interiorPoint)) {
            return 0;
        }
        return 3;
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        return distanceStyle.computeDistance(this.planetModel, this.plane, x, y, z, new Membership[0]);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoDegenerateLatitudeZone)) {
            return false;
        }
        GeoDegenerateLatitudeZone other = (GeoDegenerateLatitudeZone)o;
        return super.equals(other) && other.latitude == this.latitude;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "GeoDegenerateLatitudeZone: {planetmodel=" + this.planetModel + ", lat=" + this.latitude + "(" + this.latitude * 180.0 / Math.PI + ")}";
    }
}

