/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.BasePlanetObject;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.Bounds;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.Membership;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.Plane;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.SerializableObject;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.Vector;

public abstract class GeoBaseCompositeShape<T extends GeoShape>
extends BasePlanetObject
implements GeoShape {
    protected final List<T> shapes = new ArrayList<T>();

    public GeoBaseCompositeShape(PlanetModel planetModel) {
        super(planetModel);
    }

    public void addShape(T shape) {
        if (!shape.getPlanetModel().equals(this.planetModel)) {
            throw new IllegalArgumentException("Cannot add a shape into a composite with different planet models.");
        }
        this.shapes.add(shape);
    }

    public int size() {
        return this.shapes.size();
    }

    public T getShape(int index) {
        return (T)((GeoShape)this.shapes.get(index));
    }

    public GeoBaseCompositeShape(PlanetModel planetModel, InputStream inputStream, Class<T> clazz) throws IOException {
        this(planetModel);
        GeoShape[] array;
        for (GeoShape member : array = (GeoShape[])SerializableObject.readHeterogeneousArray((PlanetModel)planetModel, (InputStream)inputStream, clazz)) {
            this.addShape((GeoShape)clazz.cast(member));
        }
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SerializableObject.writeHeterogeneousArray(outputStream, this.shapes);
    }

    @Override
    public boolean isWithin(Vector point) {
        return this.isWithin(point.x, point.y, point.z);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        for (GeoShape shape : this.shapes) {
            if (!shape.isWithin(x, y, z)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        ArrayList<GeoPoint> edgePoints = new ArrayList<GeoPoint>();
        for (GeoShape shape : this.shapes) {
            edgePoints.addAll(Arrays.asList(shape.getEdgePoints()));
        }
        return edgePoints.toArray(new GeoPoint[edgePoints.size()]);
    }

    @Override
    public boolean intersects(Plane p, GeoPoint[] notablePoints, Membership ... bounds) {
        for (GeoShape shape : this.shapes) {
            if (!shape.intersects(p, notablePoints, bounds)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getBounds(Bounds bounds) {
        for (GeoShape shape : this.shapes) {
            shape.getBounds(bounds);
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.shapes.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoBaseCompositeShape)) {
            return false;
        }
        GeoBaseCompositeShape other = (GeoBaseCompositeShape)o;
        return super.equals(other) && this.shapes.equals(other.shapes);
    }
}

