/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoBaseCompositeShape;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoMembershipShape;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.spatial3d.geom.PlanetModel;

abstract class GeoBaseCompositeMembershipShape<T extends GeoMembershipShape>
extends GeoBaseCompositeShape<T>
implements GeoMembershipShape {
    GeoBaseCompositeMembershipShape(PlanetModel planetModel) {
        super(planetModel);
    }

    GeoBaseCompositeMembershipShape(PlanetModel planetModel, InputStream inputStream, Class<T> clazz) throws IOException {
        super(planetModel, inputStream, clazz);
    }

    @Override
    public double computeOutsideDistance(DistanceStyle distanceStyle, GeoPoint point) {
        return this.computeOutsideDistance(distanceStyle, point.x, point.y, point.z);
    }

    @Override
    public double computeOutsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        if (this.isWithin(x, y, z)) {
            return 0.0;
        }
        double distance = Double.POSITIVE_INFINITY;
        for (GeoMembershipShape shape : this.shapes) {
            double normalDistance = shape.computeOutsideDistance(distanceStyle, x, y, z);
            if (!(normalDistance < distance)) continue;
            distance = normalDistance;
        }
        return distance;
    }
}

