/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.spell;

import java.util.Comparator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.spell.SuggestWord;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.spell.SuggestWordScoreComparator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.PriorityQueue;

public final class SuggestWordQueue
extends PriorityQueue<SuggestWord> {
    public static final Comparator<SuggestWord> DEFAULT_COMPARATOR = new SuggestWordScoreComparator();
    private Comparator<SuggestWord> comparator;

    public SuggestWordQueue(int size) {
        super(size);
        this.comparator = DEFAULT_COMPARATOR;
    }

    public SuggestWordQueue(int size, Comparator<SuggestWord> comparator) {
        super(size);
        this.comparator = comparator;
    }

    @Override
    protected final boolean lessThan(SuggestWord wa, SuggestWord wb) {
        int val = this.comparator.compare(wa, wb);
        return val < 0;
    }
}

