/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.grouping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.FieldComparator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Sort;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.SortField;

public class SearchGroup<T> {
    public T groupValue;
    public Object[] sortValues;

    public String toString() {
        return "SearchGroup(groupValue=" + this.groupValue + " sortValues=" + Arrays.toString(this.sortValues) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchGroup that = (SearchGroup)o;
        return !(this.groupValue == null ? that.groupValue != null : !this.groupValue.equals(that.groupValue));
    }

    public int hashCode() {
        return this.groupValue != null ? this.groupValue.hashCode() : 0;
    }

    public static <T> Collection<SearchGroup<T>> merge(List<Collection<SearchGroup<T>>> topGroups, int offset, int topN, Sort groupSort) {
        if (topGroups.isEmpty()) {
            return null;
        }
        return new GroupMerger<T>(groupSort).merge(topGroups, offset, topN);
    }

    private static class GroupMerger<T> {
        private final GroupComparator<T> groupComp;
        private final NavigableSet<MergedGroup<T>> queue;
        private final Map<T, MergedGroup<T>> groupsSeen;

        public GroupMerger(Sort groupSort) {
            this.groupComp = new GroupComparator(groupSort);
            this.queue = new TreeSet<T>(this.groupComp);
            this.groupsSeen = new HashMap<T, MergedGroup<T>>();
        }

        private void updateNextGroup(int topN, ShardIter<T> shard) {
            Object group;
            while (shard.iter.hasNext()) {
                boolean isNew;
                group = shard.next();
                MergedGroup<T> mergedGroup = this.groupsSeen.get(((SearchGroup)group).groupValue);
                boolean bl = isNew = mergedGroup == null;
                if (isNew) {
                    mergedGroup = new MergedGroup(((SearchGroup)group).groupValue);
                    mergedGroup.minShardIndex = shard.shardIndex;
                    assert (((SearchGroup)group).sortValues != null);
                    mergedGroup.topValues = ((SearchGroup)group).sortValues;
                    this.groupsSeen.put(((SearchGroup)group).groupValue, mergedGroup);
                    mergedGroup.inQueue = true;
                    this.queue.add(mergedGroup);
                } else {
                    if (mergedGroup.processed) continue;
                    boolean competes = false;
                    for (int compIDX = 0; compIDX < this.groupComp.comparators.length; ++compIDX) {
                        int cmp = this.groupComp.reversed[compIDX] * this.groupComp.comparators[compIDX].compareValues(((SearchGroup)group).sortValues[compIDX], mergedGroup.topValues[compIDX]);
                        if (cmp < 0) {
                            competes = true;
                            break;
                        }
                        if (cmp > 0) break;
                        if (compIDX != this.groupComp.comparators.length - 1 || shard.shardIndex >= mergedGroup.minShardIndex) continue;
                        competes = true;
                    }
                    if (competes) {
                        if (mergedGroup.inQueue) {
                            this.queue.remove(mergedGroup);
                        }
                        mergedGroup.topValues = ((SearchGroup)group).sortValues;
                        mergedGroup.minShardIndex = shard.shardIndex;
                        this.queue.add(mergedGroup);
                        mergedGroup.inQueue = true;
                    }
                }
                mergedGroup.shards.add(shard);
                break;
            }
            while (this.queue.size() > topN) {
                group = this.queue.pollLast();
                ((MergedGroup)group).inQueue = false;
            }
        }

        public Collection<SearchGroup<T>> merge(List<Collection<SearchGroup<T>>> shards, int offset, int topN) {
            int maxQueueSize = offset + topN;
            for (int shardIDX = 0; shardIDX < shards.size(); ++shardIDX) {
                Collection<SearchGroup<T>> shard = shards.get(shardIDX);
                if (shard.isEmpty()) continue;
                this.updateNextGroup(maxQueueSize, new ShardIter<T>(shard, shardIDX));
            }
            ArrayList<SearchGroup<T>> newTopGroups = new ArrayList<SearchGroup<T>>(topN);
            int count = 0;
            while (!this.queue.isEmpty()) {
                MergedGroup<T> group = this.queue.pollFirst();
                group.processed = true;
                if (count++ >= offset) {
                    SearchGroup newGroup = new SearchGroup();
                    newGroup.groupValue = group.groupValue;
                    newGroup.sortValues = group.topValues;
                    newTopGroups.add(newGroup);
                    if (newTopGroups.size() == topN) break;
                }
                for (ShardIter shardIter : group.shards) {
                    this.updateNextGroup(maxQueueSize, shardIter);
                }
            }
            if (newTopGroups.isEmpty()) {
                return null;
            }
            return newTopGroups;
        }
    }

    private static class GroupComparator<T>
    implements Comparator<MergedGroup<T>> {
        public final FieldComparator[] comparators;
        public final int[] reversed;

        public GroupComparator(Sort groupSort) {
            SortField[] sortFields = groupSort.getSort();
            this.comparators = new FieldComparator[sortFields.length];
            this.reversed = new int[sortFields.length];
            for (int compIDX = 0; compIDX < sortFields.length; ++compIDX) {
                SortField sortField = sortFields[compIDX];
                this.comparators[compIDX] = sortField.getComparator(1, compIDX);
                this.reversed[compIDX] = sortField.getReverse() ? -1 : 1;
            }
        }

        @Override
        public int compare(MergedGroup<T> group, MergedGroup<T> other) {
            if (group == other) {
                return 0;
            }
            Object[] groupValues = group.topValues;
            Object[] otherValues = other.topValues;
            for (int compIDX = 0; compIDX < this.comparators.length; ++compIDX) {
                int c = this.reversed[compIDX] * this.comparators[compIDX].compareValues(groupValues[compIDX], otherValues[compIDX]);
                if (c == 0) continue;
                return c;
            }
            assert (group.minShardIndex != other.minShardIndex);
            return group.minShardIndex - other.minShardIndex;
        }
    }

    private static class MergedGroup<T> {
        public final T groupValue;
        public Object[] topValues;
        public final List<ShardIter<T>> shards = new ArrayList<ShardIter<T>>();
        public int minShardIndex;
        public boolean processed;
        public boolean inQueue;

        public MergedGroup(T groupValue) {
            this.groupValue = groupValue;
        }

        private boolean neverEquals(Object _other) {
            if (_other instanceof MergedGroup) {
                MergedGroup other = (MergedGroup)_other;
                if (this.groupValue == null ? !$assertionsDisabled && other.groupValue == null : !$assertionsDisabled && this.groupValue.equals(other.groupValue)) {
                    throw new AssertionError();
                }
            }
            return true;
        }

        public boolean equals(Object _other) {
            assert (this.neverEquals(_other));
            if (_other instanceof MergedGroup) {
                MergedGroup other = (MergedGroup)_other;
                if (this.groupValue == null) {
                    return other == null;
                }
                return this.groupValue.equals(other);
            }
            return false;
        }

        public int hashCode() {
            if (this.groupValue == null) {
                return 0;
            }
            return this.groupValue.hashCode();
        }
    }

    private static class ShardIter<T> {
        public final Iterator<SearchGroup<T>> iter;
        public final int shardIndex;

        public ShardIter(Collection<SearchGroup<T>> shard, int shardIndex) {
            this.shardIndex = shardIndex;
            this.iter = shard.iterator();
            assert (this.iter.hasNext());
        }

        public SearchGroup<T> next() {
            assert (this.iter.hasNext());
            SearchGroup<T> group = this.iter.next();
            if (group.sortValues == null) {
                throw new IllegalArgumentException("group.sortValues is null; you must pass fillFields=true to the first pass collector");
            }
            return group;
        }

        public String toString() {
            return "ShardIter(shard=" + this.shardIndex + ")";
        }
    }
}

