/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.grouping;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.grouping.DoubleRange;

public class DoubleRangeFactory {
    private final double min;
    private final double width;
    private final double max;

    public DoubleRangeFactory(double min, double width, double max) {
        this.min = min;
        this.width = width;
        this.max = max;
    }

    public DoubleRange getRange(double value, DoubleRange reuse) {
        if (reuse == null) {
            reuse = new DoubleRange(Double.MIN_VALUE, Double.MAX_VALUE);
        }
        if (value < this.min) {
            reuse.max = this.min;
            reuse.min = Double.MIN_VALUE;
            return reuse;
        }
        if (value >= this.max) {
            reuse.min = this.max;
            reuse.max = Double.MAX_VALUE;
            return reuse;
        }
        double bucket = Math.floor((value - this.min) / this.width);
        reuse.min = this.min + bucket * this.width;
        reuse.max = reuse.min + this.width;
        return reuse;
    }
}

