/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Scorer;

public class BlockMaxDISI
extends DocIdSetIterator {
    protected final Scorer scorer;
    private final DocIdSetIterator in;
    private float minScore;
    private float maxScore;
    private int upTo = -1;

    public BlockMaxDISI(DocIdSetIterator iterator, Scorer scorer) {
        this.in = iterator;
        this.scorer = scorer;
    }

    @Override
    public int docID() {
        return this.in.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        return this.advance(this.docID() + 1);
    }

    @Override
    public int advance(int target) throws IOException {
        int doc = this.advanceImpacts(target);
        return this.in.advance(doc);
    }

    @Override
    public long cost() {
        return this.in.cost();
    }

    public void setMinCompetitiveScore(float minScore) {
        this.minScore = minScore;
    }

    private void moveToNextBlock(int target) throws IOException {
        this.upTo = this.scorer.advanceShallow(target);
        this.maxScore = this.scorer.getMaxScore(this.upTo);
    }

    private int advanceImpacts(int target) throws IOException {
        if (this.minScore == -1.0f || target == Integer.MAX_VALUE) {
            return target;
        }
        if (target > this.upTo) {
            this.moveToNextBlock(target);
        }
        while (!(this.maxScore >= this.minScore)) {
            if (this.upTo == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            target = this.upTo + 1;
            this.moveToNextBlock(target);
        }
        return target;
    }
}

