/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.DocValuesProducer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.FieldsProducer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.NormsProducer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.PointsReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.TermVectorsReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.CodecReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FieldInfos;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexWriter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.MultiSorter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SegmentInfo;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Sort;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.InfoStream;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.packed.PackedLongValues;

public class MergeState {
    public final DocMap[] docMaps;
    final DocMap[] leafDocMaps;
    public final SegmentInfo segmentInfo;
    public FieldInfos mergeFieldInfos;
    public final StoredFieldsReader[] storedFieldsReaders;
    public final TermVectorsReader[] termVectorsReaders;
    public final NormsProducer[] normsProducers;
    public final DocValuesProducer[] docValuesProducers;
    public final FieldInfos[] fieldInfos;
    public final Bits[] liveDocs;
    public final FieldsProducer[] fieldsProducers;
    public final PointsReader[] pointsReaders;
    public final int[] maxDocs;
    public final InfoStream infoStream;
    public boolean needsIndexSort;

    MergeState(List<CodecReader> originalReaders, SegmentInfo segmentInfo, InfoStream infoStream) throws IOException {
        this.infoStream = infoStream;
        Sort indexSort = segmentInfo.getIndexSort();
        int numReaders = originalReaders.size();
        this.leafDocMaps = new DocMap[numReaders];
        List<CodecReader> readers = this.maybeSortReaders(originalReaders, segmentInfo);
        this.maxDocs = new int[numReaders];
        this.fieldsProducers = new FieldsProducer[numReaders];
        this.normsProducers = new NormsProducer[numReaders];
        this.storedFieldsReaders = new StoredFieldsReader[numReaders];
        this.termVectorsReaders = new TermVectorsReader[numReaders];
        this.docValuesProducers = new DocValuesProducer[numReaders];
        this.pointsReaders = new PointsReader[numReaders];
        this.fieldInfos = new FieldInfos[numReaders];
        this.liveDocs = new Bits[numReaders];
        int numDocs = 0;
        for (int i = 0; i < numReaders; ++i) {
            CodecReader reader = readers.get(i);
            this.maxDocs[i] = reader.maxDoc();
            this.liveDocs[i] = reader.getLiveDocs();
            this.fieldInfos[i] = reader.getFieldInfos();
            this.normsProducers[i] = reader.getNormsReader();
            if (this.normsProducers[i] != null) {
                this.normsProducers[i] = this.normsProducers[i].getMergeInstance();
            }
            this.docValuesProducers[i] = reader.getDocValuesReader();
            if (this.docValuesProducers[i] != null) {
                this.docValuesProducers[i] = this.docValuesProducers[i].getMergeInstance();
            }
            this.storedFieldsReaders[i] = reader.getFieldsReader();
            if (this.storedFieldsReaders[i] != null) {
                this.storedFieldsReaders[i] = this.storedFieldsReaders[i].getMergeInstance();
            }
            this.termVectorsReaders[i] = reader.getTermVectorsReader();
            if (this.termVectorsReaders[i] != null) {
                this.termVectorsReaders[i] = this.termVectorsReaders[i].getMergeInstance();
            }
            this.fieldsProducers[i] = reader.getPostingsReader().getMergeInstance();
            this.pointsReaders[i] = reader.getPointsReader();
            if (this.pointsReaders[i] != null) {
                this.pointsReaders[i] = this.pointsReaders[i].getMergeInstance();
            }
            numDocs += reader.numDocs();
        }
        segmentInfo.setMaxDoc(numDocs);
        this.segmentInfo = segmentInfo;
        this.docMaps = this.buildDocMaps(readers, indexSort);
    }

    private DocMap[] buildDeletionDocMaps(List<CodecReader> readers) {
        int totalDocs = 0;
        int numReaders = readers.size();
        DocMap[] docMaps = new DocMap[numReaders];
        for (int i = 0; i < numReaders; ++i) {
            LeafReader reader = readers.get(i);
            final Bits liveDocs = reader.getLiveDocs();
            final PackedLongValues delDocMap = liveDocs != null ? MergeState.removeDeletes(reader.maxDoc(), liveDocs) : null;
            final int docBase = totalDocs;
            docMaps[i] = new DocMap(){

                @Override
                public int get(int docID) {
                    if (liveDocs == null) {
                        return docBase + docID;
                    }
                    if (liveDocs.get(docID)) {
                        return docBase + (int)delDocMap.get(docID);
                    }
                    return -1;
                }
            };
            totalDocs += reader.numDocs();
        }
        return docMaps;
    }

    private DocMap[] buildDocMaps(List<CodecReader> readers, Sort indexSort) throws IOException {
        if (indexSort == null) {
            return this.buildDeletionDocMaps(readers);
        }
        long t0 = System.nanoTime();
        DocMap[] result = MultiSorter.sort(indexSort, readers);
        if (result == null) {
            return this.buildDeletionDocMaps(readers);
        }
        this.needsIndexSort = true;
        long t1 = System.nanoTime();
        if (this.infoStream.isEnabled("SM")) {
            this.infoStream.message("SM", String.format(Locale.ROOT, "%.2f msec to build merge sorted DocMaps", (double)(t1 - t0) / 1000000.0));
        }
        return result;
    }

    private List<CodecReader> maybeSortReaders(List<CodecReader> originalReaders, SegmentInfo segmentInfo) throws IOException {
        for (int i = 0; i < originalReaders.size(); ++i) {
            this.leafDocMaps[i] = new DocMap(){

                @Override
                public int get(int docID) {
                    return docID;
                }
            };
        }
        Sort indexSort = segmentInfo.getIndexSort();
        if (indexSort == null) {
            return originalReaders;
        }
        ArrayList<CodecReader> readers = new ArrayList<CodecReader>(originalReaders.size());
        for (CodecReader leaf : originalReaders) {
            Sort segmentSort = leaf.getMetaData().getSort();
            if (segmentSort == null || !IndexWriter.isCongruentSort(indexSort, segmentSort)) {
                throw new IllegalArgumentException("index sort mismatch: merged segment has sort=" + indexSort + " but to-be-merged segment has sort=" + (segmentSort == null ? "null" : segmentSort));
            }
            readers.add(leaf);
        }
        return readers;
    }

    static PackedLongValues removeDeletes(int maxDoc, Bits liveDocs) {
        PackedLongValues.Builder docMapBuilder = PackedLongValues.monotonicBuilder(0.0f);
        int del = 0;
        for (int i = 0; i < maxDoc; ++i) {
            docMapBuilder.add(i - del);
            if (liveDocs.get(i)) continue;
            ++del;
        }
        return docMapBuilder.build();
    }

    public static abstract class DocMap {
        public abstract int get(int var1);
    }
}

