/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.FieldsConsumer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.NormsProducer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FieldInfos;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FieldInvertState;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Fields;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FilterLeafReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FreqProxFields;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FreqProxTermsWriterPerField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.PostingsEnum;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SegmentWriteState;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Sorter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.TermsHash;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.TermsHashPerField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.DataOutput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.ByteBlockPool;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.CollectionUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Counter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.FixedBitSet;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.IOUtils;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.IntBlockPool;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.TimSorter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.automaton.CompiledAutomaton;

final class FreqProxTermsWriter
extends TermsHash {
    FreqProxTermsWriter(IntBlockPool.Allocator intBlockAllocator, ByteBlockPool.Allocator byteBlockAllocator, Counter bytesUsed, TermsHash termVectors) {
        super(intBlockAllocator, byteBlockAllocator, bytesUsed, termVectors);
    }

    private void applyDeletes(SegmentWriteState state, Fields fields) throws IOException {
        if (state.segUpdates != null && state.segUpdates.deleteTerms.size() > 0) {
            Map<Term, Integer> segDeletes = state.segUpdates.deleteTerms;
            ArrayList<Term> deleteTerms = new ArrayList<Term>(segDeletes.keySet());
            Collections.sort(deleteTerms);
            FrozenBufferedUpdates.TermDocsIterator iterator = new FrozenBufferedUpdates.TermDocsIterator(fields, true);
            for (Term deleteTerm : deleteTerms) {
                int doc;
                DocIdSetIterator postings = iterator.nextTerm(deleteTerm.field(), deleteTerm.bytes());
                if (postings == null) continue;
                int delDocLimit = segDeletes.get(deleteTerm);
                assert (delDocLimit < Integer.MAX_VALUE);
                while ((doc = postings.nextDoc()) < delDocLimit) {
                    if (state.liveDocs == null) {
                        state.liveDocs = new FixedBitSet(state.segmentInfo.maxDoc());
                        state.liveDocs.set(0, state.segmentInfo.maxDoc());
                    }
                    if (!state.liveDocs.get(doc)) continue;
                    ++state.delCountOnFlush;
                    state.liveDocs.clear(doc);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(Map<String, TermsHashPerField> fieldsToFlush, SegmentWriteState state, Sorter.DocMap sortMap, NormsProducer norms) throws IOException {
        block8: {
            FieldsConsumer consumer;
            block7: {
                super.flush(fieldsToFlush, state, sortMap, norms);
                ArrayList<FreqProxTermsWriterPerField> allFields = new ArrayList<FreqProxTermsWriterPerField>();
                for (TermsHashPerField f : fieldsToFlush.values()) {
                    FreqProxTermsWriterPerField perField = (FreqProxTermsWriterPerField)f;
                    if (perField.getNumTerms() <= 0) continue;
                    perField.sortTerms();
                    assert (perField.indexOptions != IndexOptions.NONE);
                    allFields.add(perField);
                }
                CollectionUtil.introSort(allFields);
                Fields fields = new FreqProxFields(allFields);
                this.applyDeletes(state, fields);
                if (sortMap != null) {
                    final Sorter.DocMap docMap = sortMap;
                    final FieldInfos infos = state.fieldInfos;
                    fields = new FilterLeafReader.FilterFields(fields){

                        @Override
                        public Terms terms(String field) throws IOException {
                            Terms terms = this.in.terms(field);
                            if (terms == null) {
                                return null;
                            }
                            return new SortingTerms(terms, infos.fieldInfo(field).getIndexOptions(), docMap);
                        }
                    };
                }
                consumer = state.segmentInfo.getCodec().postingsFormat().fieldsConsumer(state);
                boolean success = false;
                try {
                    consumer.write(fields, norms);
                    success = true;
                    if (!success) break block7;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(consumer);
                    } else {
                        IOUtils.closeWhileHandlingException(consumer);
                    }
                    throw throwable;
                }
                IOUtils.close(consumer);
                break block8;
            }
            IOUtils.closeWhileHandlingException(consumer);
        }
    }

    @Override
    public TermsHashPerField addField(FieldInvertState invertState, FieldInfo fieldInfo) {
        return new FreqProxTermsWriterPerField(invertState, this, fieldInfo, this.nextTermsHash.addField(invertState, fieldInfo));
    }

    static class SortingPostingsEnum
    extends FilterLeafReader.FilterPostingsEnum {
        private final int maxDoc;
        private final DocOffsetSorter sorter;
        private int[] docs;
        private long[] offsets;
        private final int upto;
        private final ByteBuffersDataInput postingInput;
        private final boolean storeOffsets;
        private int docIt = -1;
        private int pos;
        private int startOffset = -1;
        private int endOffset = -1;
        private final BytesRef payload;
        private int currFreq;
        private final ByteBuffersDataOutput buffer;

        SortingPostingsEnum(int maxDoc, SortingPostingsEnum reuse, PostingsEnum in, Sorter.DocMap docMap, boolean storeOffsets) throws IOException {
            super(in);
            int doc;
            this.maxDoc = maxDoc;
            this.storeOffsets = storeOffsets;
            if (reuse != null) {
                this.docs = reuse.docs;
                this.offsets = reuse.offsets;
                this.payload = reuse.payload;
                this.buffer = reuse.buffer;
                this.buffer.reset();
                this.sorter = reuse.maxDoc == maxDoc ? reuse.sorter : new DocOffsetSorter(maxDoc);
            } else {
                this.docs = new int[32];
                this.offsets = new long[32];
                this.payload = new BytesRef(32);
                this.buffer = ByteBuffersDataOutput.newResettableInstance();
                this.sorter = new DocOffsetSorter(maxDoc);
            }
            int i = 0;
            while ((doc = in.nextDoc()) != Integer.MAX_VALUE) {
                if (i == this.docs.length) {
                    int newLength = ArrayUtil.oversize(i + 1, 4);
                    this.docs = ArrayUtil.growExact(this.docs, newLength);
                    this.offsets = ArrayUtil.growExact(this.offsets, newLength);
                }
                this.docs[i] = docMap.oldToNew(doc);
                this.offsets[i] = this.buffer.size();
                this.addPositions(in, this.buffer);
                ++i;
            }
            this.upto = i;
            this.sorter.reset(this.docs, this.offsets);
            this.sorter.sort(0, this.upto);
            this.postingInput = this.buffer.toDataInput();
        }

        boolean reused(PostingsEnum other) {
            if (other == null || !(other instanceof SortingPostingsEnum)) {
                return false;
            }
            return this.docs == ((SortingPostingsEnum)other).docs;
        }

        private void addPositions(PostingsEnum in, DataOutput out) throws IOException {
            int freq = in.freq();
            out.writeVInt(freq);
            int previousPosition = 0;
            int previousEndOffset = 0;
            for (int i = 0; i < freq; ++i) {
                int pos = in.nextPosition();
                BytesRef payload = in.getPayload();
                int token = pos - previousPosition << 1 | (payload == null ? 0 : 1);
                out.writeVInt(token);
                previousPosition = pos;
                if (this.storeOffsets) {
                    int startOffset = in.startOffset();
                    int endOffset = in.endOffset();
                    out.writeVInt(startOffset - previousEndOffset);
                    out.writeVInt(endOffset - startOffset);
                    previousEndOffset = endOffset;
                }
                if (payload == null) continue;
                out.writeVInt(payload.length);
                out.writeBytes(payload.bytes, payload.offset, payload.length);
            }
        }

        @Override
        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        @Override
        public int docID() {
            return this.docIt < 0 ? -1 : (this.docIt >= this.upto ? Integer.MAX_VALUE : this.docs[this.docIt]);
        }

        @Override
        public int endOffset() throws IOException {
            return this.endOffset;
        }

        @Override
        public int freq() throws IOException {
            return this.currFreq;
        }

        @Override
        public BytesRef getPayload() throws IOException {
            return this.payload.length == 0 ? null : this.payload;
        }

        @Override
        public int nextDoc() throws IOException {
            if (++this.docIt >= this.upto) {
                return Integer.MAX_VALUE;
            }
            this.postingInput.seek(this.offsets[this.docIt]);
            this.currFreq = this.postingInput.readVInt();
            this.pos = 0;
            this.endOffset = 0;
            return this.docs[this.docIt];
        }

        @Override
        public int nextPosition() throws IOException {
            int token = this.postingInput.readVInt();
            this.pos += token >>> 1;
            if (this.storeOffsets) {
                this.startOffset = this.endOffset + this.postingInput.readVInt();
                this.endOffset = this.startOffset + this.postingInput.readVInt();
            }
            if ((token & 1) != 0) {
                this.payload.offset = 0;
                this.payload.length = this.postingInput.readVInt();
                if (this.payload.length > this.payload.bytes.length) {
                    this.payload.bytes = new byte[ArrayUtil.oversize(this.payload.length, 1)];
                }
                this.postingInput.readBytes(this.payload.bytes, 0, this.payload.length);
            } else {
                this.payload.length = 0;
            }
            return this.pos;
        }

        @Override
        public int startOffset() throws IOException {
            return this.startOffset;
        }

        PostingsEnum getWrapped() {
            return this.in;
        }

        private static final class DocOffsetSorter
        extends TimSorter {
            private int[] docs;
            private long[] offsets;
            private final int[] tmpDocs;
            private final long[] tmpOffsets;

            public DocOffsetSorter(int maxDoc) {
                super(maxDoc / 64);
                this.tmpDocs = new int[maxDoc / 64];
                this.tmpOffsets = new long[maxDoc / 64];
            }

            public void reset(int[] docs, long[] offsets) {
                this.docs = docs;
                this.offsets = offsets;
            }

            @Override
            protected int compare(int i, int j) {
                return this.docs[i] - this.docs[j];
            }

            @Override
            protected void swap(int i, int j) {
                int tmpDoc = this.docs[i];
                this.docs[i] = this.docs[j];
                this.docs[j] = tmpDoc;
                long tmpOffset = this.offsets[i];
                this.offsets[i] = this.offsets[j];
                this.offsets[j] = tmpOffset;
            }

            @Override
            protected void copy(int src, int dest) {
                this.docs[dest] = this.docs[src];
                this.offsets[dest] = this.offsets[src];
            }

            @Override
            protected void save(int i, int len) {
                System.arraycopy(this.docs, i, this.tmpDocs, 0, len);
                System.arraycopy(this.offsets, i, this.tmpOffsets, 0, len);
            }

            @Override
            protected void restore(int i, int j) {
                this.docs[j] = this.tmpDocs[i];
                this.offsets[j] = this.tmpOffsets[i];
            }

            @Override
            protected int compareSaved(int i, int j) {
                return this.tmpDocs[i] - this.docs[j];
            }
        }
    }

    static class SortingDocsEnum
    extends FilterLeafReader.FilterPostingsEnum {
        private final int maxDoc;
        private final DocFreqSorter sorter;
        private int[] docs;
        private int[] freqs;
        private int docIt = -1;
        private final int upto;
        private final boolean withFreqs;

        SortingDocsEnum(int maxDoc, SortingDocsEnum reuse, PostingsEnum in, boolean withFreqs, Sorter.DocMap docMap) throws IOException {
            super(in);
            this.maxDoc = maxDoc;
            this.withFreqs = withFreqs;
            if (reuse != null) {
                this.sorter = reuse.maxDoc == maxDoc ? reuse.sorter : new DocFreqSorter(maxDoc);
                this.docs = reuse.docs;
                this.freqs = reuse.freqs;
            } else {
                this.docs = new int[64];
                this.sorter = new DocFreqSorter(maxDoc);
            }
            this.docIt = -1;
            int i = 0;
            if (withFreqs) {
                int doc;
                if (this.freqs == null || this.freqs.length < this.docs.length) {
                    this.freqs = new int[this.docs.length];
                }
                while ((doc = in.nextDoc()) != Integer.MAX_VALUE) {
                    if (i >= this.docs.length) {
                        this.docs = ArrayUtil.grow(this.docs, this.docs.length + 1);
                        this.freqs = ArrayUtil.grow(this.freqs, this.freqs.length + 1);
                    }
                    this.docs[i] = docMap.oldToNew(doc);
                    this.freqs[i] = in.freq();
                    ++i;
                }
            } else {
                int doc;
                this.freqs = null;
                while ((doc = in.nextDoc()) != Integer.MAX_VALUE) {
                    if (i >= this.docs.length) {
                        this.docs = ArrayUtil.grow(this.docs, this.docs.length + 1);
                    }
                    this.docs[i++] = docMap.oldToNew(doc);
                }
            }
            this.sorter.reset(this.docs, this.freqs);
            this.sorter.sort(0, i);
            this.upto = i;
        }

        boolean reused(PostingsEnum other) {
            if (other == null || !(other instanceof SortingDocsEnum)) {
                return false;
            }
            return this.docs == ((SortingDocsEnum)other).docs;
        }

        @Override
        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        @Override
        public int docID() {
            return this.docIt < 0 ? -1 : (this.docIt >= this.upto ? Integer.MAX_VALUE : this.docs[this.docIt]);
        }

        @Override
        public int freq() throws IOException {
            return this.withFreqs && this.docIt < this.upto ? this.freqs[this.docIt] : 1;
        }

        @Override
        public int nextDoc() throws IOException {
            if (++this.docIt >= this.upto) {
                return Integer.MAX_VALUE;
            }
            return this.docs[this.docIt];
        }

        PostingsEnum getWrapped() {
            return this.in;
        }

        @Override
        public int nextPosition() throws IOException {
            return -1;
        }

        @Override
        public int startOffset() throws IOException {
            return -1;
        }

        @Override
        public int endOffset() throws IOException {
            return -1;
        }

        @Override
        public BytesRef getPayload() throws IOException {
            return null;
        }

        private static final class DocFreqSorter
        extends TimSorter {
            private int[] docs;
            private int[] freqs;
            private final int[] tmpDocs;
            private int[] tmpFreqs;

            DocFreqSorter(int maxDoc) {
                super(maxDoc / 64);
                this.tmpDocs = new int[maxDoc / 64];
            }

            public void reset(int[] docs, int[] freqs) {
                this.docs = docs;
                this.freqs = freqs;
                if (freqs != null && this.tmpFreqs == null) {
                    this.tmpFreqs = new int[this.tmpDocs.length];
                }
            }

            @Override
            protected int compare(int i, int j) {
                return this.docs[i] - this.docs[j];
            }

            @Override
            protected void swap(int i, int j) {
                int tmpDoc = this.docs[i];
                this.docs[i] = this.docs[j];
                this.docs[j] = tmpDoc;
                if (this.freqs != null) {
                    int tmpFreq = this.freqs[i];
                    this.freqs[i] = this.freqs[j];
                    this.freqs[j] = tmpFreq;
                }
            }

            @Override
            protected void copy(int src, int dest) {
                this.docs[dest] = this.docs[src];
                if (this.freqs != null) {
                    this.freqs[dest] = this.freqs[src];
                }
            }

            @Override
            protected void save(int i, int len) {
                System.arraycopy(this.docs, i, this.tmpDocs, 0, len);
                if (this.freqs != null) {
                    System.arraycopy(this.freqs, i, this.tmpFreqs, 0, len);
                }
            }

            @Override
            protected void restore(int i, int j) {
                this.docs[j] = this.tmpDocs[i];
                if (this.freqs != null) {
                    this.freqs[j] = this.tmpFreqs[i];
                }
            }

            @Override
            protected int compareSaved(int i, int j) {
                return this.tmpDocs[i] - this.docs[j];
            }
        }
    }

    private static class SortingTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        final Sorter.DocMap docMap;
        private final IndexOptions indexOptions;
        private final boolean hasPositions;

        SortingTermsEnum(TermsEnum in, Sorter.DocMap docMap, IndexOptions indexOptions, boolean hasPositions) {
            super(in);
            this.docMap = docMap;
            this.indexOptions = indexOptions;
            this.hasPositions = hasPositions;
        }

        @Override
        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            PostingsEnum inReuse;
            SortingDocsEnum wrapReuse;
            if (this.hasPositions && PostingsEnum.featureRequested(flags, (short)24)) {
                PostingsEnum inReuse2;
                SortingPostingsEnum wrapReuse2;
                if (reuse != null && reuse instanceof SortingPostingsEnum) {
                    wrapReuse2 = (SortingPostingsEnum)reuse;
                    inReuse2 = wrapReuse2.getWrapped();
                } else {
                    wrapReuse2 = null;
                    inReuse2 = reuse;
                }
                PostingsEnum inDocsAndPositions = this.in.postings(inReuse2, flags);
                boolean storeOffsets = this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
                return new SortingPostingsEnum(this.docMap.size(), wrapReuse2, inDocsAndPositions, this.docMap, storeOffsets);
            }
            if (reuse != null && reuse instanceof SortingDocsEnum) {
                wrapReuse = (SortingDocsEnum)reuse;
                inReuse = wrapReuse.getWrapped();
            } else {
                wrapReuse = null;
                inReuse = reuse;
            }
            PostingsEnum inDocs = this.in.postings(inReuse, flags);
            boolean withFreqs = this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS) >= 0 && PostingsEnum.featureRequested(flags, (short)8);
            return new SortingDocsEnum(this.docMap.size(), wrapReuse, inDocs, withFreqs, this.docMap);
        }
    }

    static class SortingTerms
    extends FilterLeafReader.FilterTerms {
        private final Sorter.DocMap docMap;
        private final IndexOptions indexOptions;

        SortingTerms(Terms in, IndexOptions indexOptions, Sorter.DocMap docMap) {
            super(in);
            this.docMap = docMap;
            this.indexOptions = indexOptions;
        }

        @Override
        public TermsEnum iterator() throws IOException {
            return new SortingTermsEnum(this.in.iterator(), this.docMap, this.indexOptions, this.hasPositions());
        }

        @Override
        public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
            return new SortingTermsEnum(this.in.intersect(compiled, startTerm), this.docMap, this.indexOptions, this.hasPositions());
        }
    }
}

