/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.BinaryDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DirectoryReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FilterBinaryDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FilterDirectoryReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FilterLeafReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FilterNumericDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FilterSortedDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FilterSortedNumericDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FilterSortedSetDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.NumericDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.PointValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.QueryTimeout;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SortedDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SortedSetDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.automaton.CompiledAutomaton;

public class ExitableDirectoryReader
extends FilterDirectoryReader {
    private QueryTimeout queryTimeout;

    public ExitableDirectoryReader(DirectoryReader in, QueryTimeout queryTimeout) throws IOException {
        super(in, new ExitableSubReaderWrapper(queryTimeout));
        this.queryTimeout = queryTimeout;
    }

    @Override
    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
        return new ExitableDirectoryReader(in, this.queryTimeout);
    }

    public static DirectoryReader wrap(DirectoryReader in, QueryTimeout queryTimeout) throws IOException {
        return new ExitableDirectoryReader(in, queryTimeout);
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    @Override
    public String toString() {
        return "ExitableDirectoryReader(" + this.in.toString() + ")";
    }

    public static class ExitableTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        private QueryTimeout queryTimeout;

        public ExitableTermsEnum(TermsEnum termsEnum, QueryTimeout queryTimeout) {
            super(termsEnum);
            this.queryTimeout = queryTimeout;
            this.checkAndThrow();
        }

        private void checkAndThrow() {
            if (this.queryTimeout.shouldExit()) {
                throw new ExitingReaderException("The request took too long to iterate over terms. Timeout: " + this.queryTimeout.toString() + ", TermsEnum=" + this.in);
            }
            if (Thread.interrupted()) {
                throw new ExitingReaderException("Interrupted while iterating over terms. TermsEnum=" + this.in);
            }
        }

        @Override
        public BytesRef next() throws IOException {
            this.checkAndThrow();
            return this.in.next();
        }
    }

    public static class ExitableTerms
    extends FilterLeafReader.FilterTerms {
        private QueryTimeout queryTimeout;

        public ExitableTerms(Terms terms, QueryTimeout queryTimeout) {
            super(terms);
            this.queryTimeout = queryTimeout;
        }

        @Override
        public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
            return new ExitableTermsEnum(this.in.intersect(compiled, startTerm), this.queryTimeout);
        }

        @Override
        public TermsEnum iterator() throws IOException {
            return new ExitableTermsEnum(this.in.iterator(), this.queryTimeout);
        }
    }

    private static class ExitableIntersectVisitor
    implements PointValues.IntersectVisitor {
        private static final int MAX_CALLS_BEFORE_QUERY_TIMEOUT_CHECK = 10;
        private final PointValues.IntersectVisitor in;
        private final QueryTimeout queryTimeout;
        private int calls;

        private ExitableIntersectVisitor(PointValues.IntersectVisitor in, QueryTimeout queryTimeout) {
            this.in = in;
            this.queryTimeout = queryTimeout;
        }

        private void checkAndThrowWithSampling() {
            if (this.calls++ % 10 == 0) {
                this.checkAndThrow();
            }
        }

        private void checkAndThrow() {
            if (this.queryTimeout.shouldExit()) {
                throw new ExitingReaderException("The request took too long to intersect point values. Timeout: " + this.queryTimeout.toString() + ", PointValues=" + this.in);
            }
            if (Thread.interrupted()) {
                throw new ExitingReaderException("Interrupted while intersecting point values. PointValues=" + this.in);
            }
        }

        @Override
        public void visit(int docID) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(docID);
        }

        @Override
        public void visit(int docID, byte[] packedValue) throws IOException {
            this.checkAndThrowWithSampling();
            this.in.visit(docID, packedValue);
        }

        @Override
        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            this.checkAndThrow();
            return this.in.compare(minPackedValue, maxPackedValue);
        }

        @Override
        public void grow(int count) {
            this.checkAndThrow();
            this.in.grow(count);
        }
    }

    private static class ExitablePointValues
    extends PointValues {
        private final PointValues in;
        private final QueryTimeout queryTimeout;

        private ExitablePointValues(PointValues in, QueryTimeout queryTimeout) {
            this.in = in;
            this.queryTimeout = queryTimeout;
            this.checkAndThrow();
        }

        private void checkAndThrow() {
            if (this.queryTimeout.shouldExit()) {
                throw new ExitingReaderException("The request took too long to iterate over point values. Timeout: " + this.queryTimeout.toString() + ", PointValues=" + this.in);
            }
            if (Thread.interrupted()) {
                throw new ExitingReaderException("Interrupted while iterating over point values. PointValues=" + this.in);
            }
        }

        @Override
        public void intersect(PointValues.IntersectVisitor visitor) throws IOException {
            this.checkAndThrow();
            this.in.intersect(new ExitableIntersectVisitor(visitor, this.queryTimeout));
        }

        @Override
        public long estimatePointCount(PointValues.IntersectVisitor visitor) {
            this.checkAndThrow();
            return this.in.estimatePointCount(visitor);
        }

        @Override
        public byte[] getMinPackedValue() throws IOException {
            this.checkAndThrow();
            return this.in.getMinPackedValue();
        }

        @Override
        public byte[] getMaxPackedValue() throws IOException {
            this.checkAndThrow();
            return this.in.getMaxPackedValue();
        }

        @Override
        public int getNumDimensions() throws IOException {
            this.checkAndThrow();
            return this.in.getNumDimensions();
        }

        @Override
        public int getNumIndexDimensions() throws IOException {
            this.checkAndThrow();
            return this.in.getNumIndexDimensions();
        }

        @Override
        public int getBytesPerDimension() throws IOException {
            this.checkAndThrow();
            return this.in.getBytesPerDimension();
        }

        @Override
        public long size() {
            this.checkAndThrow();
            return this.in.size();
        }

        @Override
        public int getDocCount() {
            this.checkAndThrow();
            return this.in.getDocCount();
        }
    }

    public static class ExitableFilterAtomicReader
    extends FilterLeafReader {
        private final QueryTimeout queryTimeout;
        static final int DOCS_BETWEEN_TIMEOUT_CHECK = 1000;

        public ExitableFilterAtomicReader(LeafReader in, QueryTimeout queryTimeout) {
            super(in);
            this.queryTimeout = queryTimeout;
        }

        @Override
        public PointValues getPointValues(String field) throws IOException {
            PointValues pointValues = this.in.getPointValues(field);
            if (pointValues == null) {
                return null;
            }
            return this.queryTimeout.isTimeoutEnabled() ? new ExitablePointValues(pointValues, this.queryTimeout) : pointValues;
        }

        @Override
        public Terms terms(String field) throws IOException {
            Terms terms = this.in.terms(field);
            if (terms == null) {
                return null;
            }
            return this.queryTimeout.isTimeoutEnabled() ? new ExitableTerms(terms, this.queryTimeout) : terms;
        }

        @Override
        public IndexReader.CacheHelper getReaderCacheHelper() {
            return this.in.getReaderCacheHelper();
        }

        @Override
        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.in.getCoreCacheHelper();
        }

        @Override
        public NumericDocValues getNumericDocValues(String field) throws IOException {
            NumericDocValues numericDocValues = super.getNumericDocValues(field);
            if (numericDocValues == null) {
                return null;
            }
            return this.queryTimeout.isTimeoutEnabled() ? new FilterNumericDocValues(numericDocValues){
                private int docToCheck;
                {
                    super(in);
                    this.docToCheck = 0;
                }

                @Override
                public int advance(int target) throws IOException {
                    int advance = super.advance(target);
                    if (advance >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = advance + 1000;
                    }
                    return advance;
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    boolean advanceExact = super.advanceExact(target);
                    if (target >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = target + 1000;
                    }
                    return advanceExact;
                }

                @Override
                public int nextDoc() throws IOException {
                    int nextDoc = super.nextDoc();
                    if (nextDoc >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = nextDoc + 1000;
                    }
                    return nextDoc;
                }
            } : numericDocValues;
        }

        @Override
        public BinaryDocValues getBinaryDocValues(String field) throws IOException {
            BinaryDocValues binaryDocValues = super.getBinaryDocValues(field);
            if (binaryDocValues == null) {
                return null;
            }
            return this.queryTimeout.isTimeoutEnabled() ? new FilterBinaryDocValues(binaryDocValues){
                private int docToCheck;
                {
                    super(in);
                    this.docToCheck = 0;
                }

                @Override
                public int advance(int target) throws IOException {
                    int advance = super.advance(target);
                    if (target >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = target + 1000;
                    }
                    return advance;
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    boolean advanceExact = super.advanceExact(target);
                    if (target >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = target + 1000;
                    }
                    return advanceExact;
                }

                @Override
                public int nextDoc() throws IOException {
                    int nextDoc = super.nextDoc();
                    if (nextDoc >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = nextDoc + 1000;
                    }
                    return nextDoc;
                }
            } : binaryDocValues;
        }

        @Override
        public SortedDocValues getSortedDocValues(String field) throws IOException {
            SortedDocValues sortedDocValues = super.getSortedDocValues(field);
            if (sortedDocValues == null) {
                return null;
            }
            return this.queryTimeout.isTimeoutEnabled() ? new FilterSortedDocValues(sortedDocValues){
                private int docToCheck;
                {
                    super(in);
                    this.docToCheck = 0;
                }

                @Override
                public int advance(int target) throws IOException {
                    int advance = super.advance(target);
                    if (advance >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = advance + 1000;
                    }
                    return advance;
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    boolean advanceExact = super.advanceExact(target);
                    if (target >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = target + 1000;
                    }
                    return advanceExact;
                }

                @Override
                public int nextDoc() throws IOException {
                    int nextDoc = super.nextDoc();
                    if (nextDoc >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = nextDoc + 1000;
                    }
                    return nextDoc;
                }
            } : sortedDocValues;
        }

        @Override
        public SortedNumericDocValues getSortedNumericDocValues(String field) throws IOException {
            SortedNumericDocValues sortedNumericDocValues = super.getSortedNumericDocValues(field);
            if (sortedNumericDocValues == null) {
                return null;
            }
            return this.queryTimeout.isTimeoutEnabled() ? new FilterSortedNumericDocValues(sortedNumericDocValues){
                private int docToCheck;
                {
                    super(in);
                    this.docToCheck = 0;
                }

                @Override
                public int advance(int target) throws IOException {
                    int advance = super.advance(target);
                    if (advance >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = advance + 1000;
                    }
                    return advance;
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    boolean advanceExact = super.advanceExact(target);
                    if (target >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = target + 1000;
                    }
                    return advanceExact;
                }

                @Override
                public int nextDoc() throws IOException {
                    int nextDoc = super.nextDoc();
                    if (nextDoc >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = nextDoc + 1000;
                    }
                    return nextDoc;
                }
            } : sortedNumericDocValues;
        }

        @Override
        public SortedSetDocValues getSortedSetDocValues(String field) throws IOException {
            SortedSetDocValues sortedSetDocValues = super.getSortedSetDocValues(field);
            if (sortedSetDocValues == null) {
                return null;
            }
            return this.queryTimeout.isTimeoutEnabled() ? new FilterSortedSetDocValues(sortedSetDocValues){
                private int docToCheck;
                {
                    super(in);
                    this.docToCheck = 0;
                }

                @Override
                public int advance(int target) throws IOException {
                    int advance = super.advance(target);
                    if (advance >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = advance + 1000;
                    }
                    return advance;
                }

                @Override
                public boolean advanceExact(int target) throws IOException {
                    boolean advanceExact = super.advanceExact(target);
                    if (target >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = target + 1000;
                    }
                    return advanceExact;
                }

                @Override
                public int nextDoc() throws IOException {
                    int nextDoc = super.nextDoc();
                    if (nextDoc >= this.docToCheck) {
                        this.checkAndThrow(this.in);
                        this.docToCheck = nextDoc + 1000;
                    }
                    return nextDoc;
                }
            } : sortedSetDocValues;
        }

        private void checkAndThrow(DocIdSetIterator in) {
            if (this.queryTimeout.shouldExit()) {
                throw new ExitingReaderException("The request took too long to iterate over doc values. Timeout: " + this.queryTimeout.toString() + ", DocValues=" + in);
            }
            if (Thread.interrupted()) {
                throw new ExitingReaderException("Interrupted while iterating over point values. PointValues=" + in);
            }
        }
    }

    public static class ExitableSubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        private QueryTimeout queryTimeout;

        public ExitableSubReaderWrapper(QueryTimeout queryTimeout) {
            this.queryTimeout = queryTimeout;
        }

        @Override
        public LeafReader wrap(LeafReader reader) {
            return new ExitableFilterAtomicReader(reader, this.queryTimeout);
        }
    }

    public static class ExitingReaderException
    extends RuntimeException {
        public ExitingReaderException(String msg) {
            super(msg);
        }
    }
}

