/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.FeatureField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.PostingsEnum;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.DoubleValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.DoubleValuesSource;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;

class FeatureDoubleValuesSource
extends DoubleValuesSource {
    private final BytesRef featureName;
    private final String field;

    public FeatureDoubleValuesSource(String field, String featureName) {
        this.field = Objects.requireNonNull(field);
        this.featureName = new BytesRef(Objects.requireNonNull(featureName));
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        return true;
    }

    @Override
    public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
        Terms terms = ctx.reader().terms(this.field);
        if (terms == null) {
            return DoubleValues.EMPTY;
        }
        TermsEnum termsEnum = terms.iterator();
        if (!termsEnum.seekExact(this.featureName)) {
            return DoubleValues.EMPTY;
        }
        PostingsEnum currentReaderPostingsValues = termsEnum.postings(null, 8);
        return new FeatureDoubleValues(currentReaderPostingsValues);
    }

    @Override
    public boolean needsScores() {
        return false;
    }

    @Override
    public DoubleValuesSource rewrite(IndexSearcher reader) throws IOException {
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.featureName);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        FeatureDoubleValuesSource other = (FeatureDoubleValuesSource)obj;
        return Objects.equals(this.field, other.field) && Objects.equals(this.featureName, other.featureName);
    }

    @Override
    public String toString() {
        return "FeatureDoubleValuesSource(" + this.field + ", " + this.featureName.utf8ToString() + ")";
    }

    static class FeatureDoubleValues
    extends DoubleValues {
        private final PostingsEnum currentReaderPostingsValues;

        public FeatureDoubleValues(PostingsEnum currentReaderPostingsValues) throws IOException {
            this.currentReaderPostingsValues = currentReaderPostingsValues;
        }

        @Override
        public double doubleValue() throws IOException {
            return FeatureField.decodeFeatureValue(this.currentReaderPostingsValues.freq());
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            return doc >= this.currentReaderPostingsValues.docID() && (this.currentReaderPostingsValues.docID() == doc || this.currentReaderPostingsValues.advance(doc) == doc);
        }
    }
}

