/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.BlockTermState;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.NormsProducer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.NumericDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.PostingsEnum;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.FixedBitSet;

public abstract class PushPostingsWriterBase
extends PostingsWriterBase {
    private PostingsEnum postingsEnum;
    private int enumFlags;
    protected FieldInfo fieldInfo;
    protected IndexOptions indexOptions;
    protected boolean writeFreqs;
    protected boolean writePositions;
    protected boolean writePayloads;
    protected boolean writeOffsets;

    protected PushPostingsWriterBase() {
    }

    public abstract BlockTermState newTermState() throws IOException;

    public abstract void startTerm(NumericDocValues var1) throws IOException;

    public abstract void finishTerm(BlockTermState var1) throws IOException;

    @Override
    public void setField(FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
        this.indexOptions = fieldInfo.getIndexOptions();
        this.writeFreqs = this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
        this.writePositions = this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        this.writeOffsets = this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        this.writePayloads = fieldInfo.hasPayloads();
        this.enumFlags = !this.writeFreqs ? 0 : (!this.writePositions ? 8 : (!this.writeOffsets ? (this.writePayloads ? 88 : 24) : (this.writePayloads ? 120 : 56)));
    }

    @Override
    public final BlockTermState writeTerm(BytesRef term, TermsEnum termsEnum, FixedBitSet docsSeen, NormsProducer norms) throws IOException {
        int docID;
        NumericDocValues normValues = !this.fieldInfo.hasNorms() ? null : norms.getNorms(this.fieldInfo);
        this.startTerm(normValues);
        this.postingsEnum = termsEnum.postings(this.postingsEnum, this.enumFlags);
        assert (this.postingsEnum != null);
        int docFreq = 0;
        long totalTermFreq = 0L;
        while ((docID = this.postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
            int freq;
            ++docFreq;
            docsSeen.set(docID);
            if (this.writeFreqs) {
                freq = this.postingsEnum.freq();
                totalTermFreq += (long)freq;
            } else {
                freq = -1;
            }
            this.startDoc(docID, freq);
            if (this.writePositions) {
                for (int i = 0; i < freq; ++i) {
                    int endOffset;
                    int startOffset;
                    BytesRef payload;
                    int pos = this.postingsEnum.nextPosition();
                    BytesRef bytesRef = payload = this.writePayloads ? this.postingsEnum.getPayload() : null;
                    if (this.writeOffsets) {
                        startOffset = this.postingsEnum.startOffset();
                        endOffset = this.postingsEnum.endOffset();
                    } else {
                        startOffset = -1;
                        endOffset = -1;
                    }
                    this.addPosition(pos, payload, startOffset, endOffset);
                }
            }
            this.finishDoc();
        }
        if (docFreq == 0) {
            return null;
        }
        BlockTermState state = this.newTermState();
        state.docFreq = docFreq;
        state.totalTermFreq = this.writeFreqs ? totalTermFreq : -1L;
        this.finishTerm(state);
        return state;
    }

    public abstract void startDoc(int var1, int var2) throws IOException;

    public abstract void addPosition(int var1, BytesRef var2, int var3, int var4) throws IOException;

    public abstract void finishDoc() throws IOException;
}

