/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.http.impl.nio.codecs;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.http.Header;
import org.apache.flink.elasticsearch7.shaded.org.apache.http.HeaderIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.http.HttpException;
import org.apache.flink.elasticsearch7.shaded.org.apache.http.HttpMessage;
import org.apache.flink.elasticsearch7.shaded.org.apache.http.message.BasicLineFormatter;
import org.apache.flink.elasticsearch7.shaded.org.apache.http.message.LineFormatter;
import org.apache.flink.elasticsearch7.shaded.org.apache.http.nio.NHttpMessageWriter;
import org.apache.flink.elasticsearch7.shaded.org.apache.http.nio.reactor.SessionOutputBuffer;
import org.apache.flink.elasticsearch7.shaded.org.apache.http.params.HttpParams;
import org.apache.flink.elasticsearch7.shaded.org.apache.http.util.Args;
import org.apache.flink.elasticsearch7.shaded.org.apache.http.util.CharArrayBuffer;

public abstract class AbstractMessageWriter<T extends HttpMessage>
implements NHttpMessageWriter<T> {
    protected final SessionOutputBuffer sessionBuffer;
    protected final CharArrayBuffer lineBuf;
    protected final LineFormatter lineFormatter;

    @Deprecated
    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter, HttpParams params) {
        Args.notNull(buffer, "Session input buffer");
        this.sessionBuffer = buffer;
        this.lineBuf = new CharArrayBuffer(64);
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
    }

    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter) {
        this.sessionBuffer = Args.notNull(buffer, "Session input buffer");
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
        this.lineBuf = new CharArrayBuffer(64);
    }

    @Override
    public void reset() {
    }

    protected abstract void writeHeadLine(T var1) throws IOException;

    @Override
    public void write(T message) throws IOException, HttpException {
        Args.notNull(message, "HTTP message");
        this.writeHeadLine(message);
        HeaderIterator it = message.headerIterator();
        while (it.hasNext()) {
            Header header = (Header)it.next();
            this.sessionBuffer.writeLine(this.lineFormatter.formatHeader(this.lineBuf, header));
        }
        this.lineBuf.clear();
        this.sessionBuffer.writeLine(this.lineBuf);
    }
}

