/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc;

import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.BitMixer;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.HashOrderMixing;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.HashOrderMixingStrategy;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.ObjectShortAssociativeContainer;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.ObjectShortHashMap;

public class ObjectShortIdentityHashMap<KType>
extends ObjectShortHashMap<KType> {
    public ObjectShortIdentityHashMap() {
        this(4);
    }

    public ObjectShortIdentityHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectShortIdentityHashMap(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.randomized());
    }

    public ObjectShortIdentityHashMap(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public ObjectShortIdentityHashMap(ObjectShortAssociativeContainer<? extends KType> container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public int hashKey(KType key) {
        assert (key != null);
        return BitMixer.mix(System.identityHashCode(key), this.keyMixer);
    }

    @Override
    public boolean equals(Object v1, Object v2) {
        return v1 == v2;
    }

    public static <KType> ObjectShortIdentityHashMap<KType> from(KType[] keys, short[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectShortIdentityHashMap<KType> map = new ObjectShortIdentityHashMap<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

