/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.AbstractIterator;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.AbstractObjectCollection;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.AbstractShortCollection;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.BitMixer;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.BufferAllocationException;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.HashContainers;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.HashOrderMixing;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.HashOrderMixingStrategy;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.ObjectBufferVisualizer;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.ObjectContainer;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.ObjectLookupContainer;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.ObjectShortAssociativeContainer;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.ObjectShortMap;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.Preallocable;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.ShortCollection;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.cursors.ObjectCursor;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.cursors.ObjectShortCursor;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.cursors.ShortCursor;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.predicates.ObjectPredicate;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.predicates.ObjectShortPredicate;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.predicates.ShortPredicate;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.procedures.ObjectProcedure;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.procedures.ObjectShortProcedure;
import org.apache.flink.elasticsearch7.shaded.com.carrotsearch.hppc.procedures.ShortProcedure;

public class ObjectShortHashMap<KType>
implements ObjectShortMap<KType>,
Preallocable,
Cloneable {
    public Object[] keys;
    public short[] values;
    protected int keyMixer;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected HashOrderMixingStrategy orderMixer;

    public ObjectShortHashMap() {
        this(4);
    }

    public ObjectShortHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectShortHashMap(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.defaultStrategy());
    }

    public ObjectShortHashMap(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public ObjectShortHashMap(ObjectShortAssociativeContainer<? extends KType> container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public short put(KType key, short value) {
        Object existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key == null) {
            this.hasEmptyKey = true;
            short previousValue = this.values[mask + 1];
            this.values[mask + 1] = value;
            return previousValue;
        }
        Object[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != null) {
            if (this.equals(existing, key)) {
                short previousValue = this.values[slot];
                this.values[slot] = value;
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            this.values[slot] = value;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(ObjectShortAssociativeContainer<? extends KType> container) {
        int count = this.size();
        for (ObjectShortCursor<KType> objectShortCursor : container) {
            this.put(objectShortCursor.key, objectShortCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public int putAll(Iterable<? extends ObjectShortCursor<? extends KType>> iterable) {
        int count = this.size();
        for (ObjectShortCursor<KType> objectShortCursor : iterable) {
            this.put(objectShortCursor.key, objectShortCursor.value);
        }
        return this.size() - count;
    }

    public boolean putIfAbsent(KType key, short value) {
        int keyIndex = this.indexOf(key);
        if (!this.indexExists(keyIndex)) {
            this.indexInsert(keyIndex, key, value);
            return true;
        }
        return false;
    }

    @Override
    public short putOrAdd(KType key, short putValue, short incrementValue) {
        assert (this.assigned < this.mask + 1);
        int keyIndex = this.indexOf(key);
        if (this.indexExists(keyIndex)) {
            putValue = (short)(this.values[keyIndex] + incrementValue);
            this.indexReplace(keyIndex, putValue);
        } else {
            this.indexInsert(keyIndex, key, putValue);
        }
        return putValue;
    }

    @Override
    public short addTo(KType key, short incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    @Override
    public short remove(KType key) {
        Object existing;
        int mask = this.mask;
        if (key == null) {
            this.hasEmptyKey = false;
            short previousValue = this.values[mask + 1];
            this.values[mask + 1] = 0;
            return previousValue;
        }
        Object[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != null) {
            if (this.equals(existing, key)) {
                short previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int removeAll(ObjectContainer<? super KType> other) {
        int before = this.size();
        if (other.size() >= this.size() && other instanceof ObjectLookupContainer) {
            void var4_6;
            if (this.hasEmptyKey && other.contains(null)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0;
            }
            Object[] keys = this.keys;
            boolean bl = false;
            int max = this.mask;
            while (var4_6 <= max) {
                Object existing = keys[var4_6];
                if (existing != null && other.contains(existing)) {
                    this.shiftConflictingKeys((int)var4_6);
                    continue;
                }
                ++var4_6;
            }
        } else {
            for (ObjectCursor<Object> objectCursor : other) {
                this.remove(objectCursor.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ObjectShortPredicate<? super KType> predicate) {
        int before = this.size();
        int mask = this.mask;
        if (this.hasEmptyKey && predicate.apply(null, this.values[mask + 1])) {
            this.hasEmptyKey = false;
            this.values[mask + 1] = 0;
        }
        Object[] keys = this.keys;
        short[] values = this.values;
        int slot = 0;
        while (slot <= mask) {
            Object existing = keys[slot];
            if (existing != null && predicate.apply(existing, values[slot])) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply(null)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0;
        }
        Object[] keys = this.keys;
        int slot = 0;
        int max = this.mask;
        while (slot <= max) {
            Object existing = keys[slot];
            if (existing != null && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public short get(KType key) {
        Object existing;
        if (key == null) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : (short)0;
        }
        Object[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != null) {
            if (this.equals(existing, key)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    @Override
    public short getOrDefault(KType key, short defaultValue) {
        Object existing;
        if (key == null) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue;
        }
        Object[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != null) {
            if (this.equals(existing, key)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    @Override
    public boolean containsKey(KType key) {
        Object existing;
        if (key == null) {
            return this.hasEmptyKey;
        }
        Object[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != null) {
            if (this.equals(existing, key)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int indexOf(KType key) {
        Object existing;
        int mask = this.mask;
        if (key == null) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        Object[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != null) {
            if (this.equals(existing, key)) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    @Override
    public boolean indexExists(int index) {
        assert (index < 0 || index >= 0 && index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    @Override
    public short indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return this.values[index];
    }

    @Override
    public short indexReplace(int index, short newValue) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        short previousValue = this.values[index];
        this.values[index] = newValue;
        return previousValue;
    }

    @Override
    public void indexInsert(int index, KType key, short value) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (key == null) {
            assert (index == this.mask + 1);
            this.values[index] = value;
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index] == null);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key, value);
            } else {
                this.keys[index] = key;
                this.values[index] = value;
            }
            ++this.assigned;
        }
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, null);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (ObjectShortCursor<KType> c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((ObjectShortHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(ObjectShortHashMap<?> other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (ObjectShortCursor<?> c : other) {
            Object key = c.key;
            if (this.containsKey(key) && this.get(key) == c.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            Object[] prevKeys = this.keys;
            short[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    @Override
    public Iterator<ObjectShortCursor<KType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ObjectShortProcedure<? super KType>> T forEach(T procedure) {
        Object[] keys = this.keys;
        short[] values = this.values;
        if (this.hasEmptyKey) {
            procedure.apply(null, values[this.mask + 1]);
        }
        int max = this.mask;
        for (int slot = 0; slot <= max; ++slot) {
            if (keys[slot] == null) continue;
            procedure.apply((Object)keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends ObjectShortPredicate<? super KType>> T forEach(T predicate) {
        Object[] keys = this.keys;
        short[] values = this.values;
        if (this.hasEmptyKey && !predicate.apply(null, values[this.mask + 1])) {
            return predicate;
        }
        int max = this.mask;
        for (int slot = 0; slot <= max && (keys[slot] == null || predicate.apply((Object)keys[slot], values[slot])); ++slot) {
        }
        return predicate;
    }

    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public ShortCollection values() {
        return new ValuesContainer();
    }

    public ObjectShortHashMap<KType> clone() {
        try {
            ObjectShortHashMap cloned = (ObjectShortHashMap)super.clone();
            cloned.keys = (Object[])this.keys.clone();
            cloned.values = (short[])this.values.clone();
            cloned.hasEmptyKey = cloned.hasEmptyKey;
            cloned.orderMixer = this.orderMixer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ObjectShortCursor<KType> cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return ObjectBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters);
    }

    public static <KType> ObjectShortHashMap<KType> from(KType[] keys, short[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectShortHashMap<KType> map = new ObjectShortHashMap<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    protected int hashKey(KType key) {
        assert (key != null);
        return BitMixer.mix(key, this.keyMixer);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(KType[] fromKeys, short[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        Object[] keys = this.keys;
        short[] values = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            KType existing = fromKeys[from];
            if (existing == null) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != null) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int newKeyMixer = this.orderMixer.newKeyMixer(arraySize);
        Object[] prevKeys = this.keys;
        short[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new Object[arraySize + emptyElementSlot];
            this.values = new short[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.keyMixer = newKeyMixer;
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, KType pendingKey, short pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == null && pendingKey != null);
        Object[] prevKeys = this.keys;
        short[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        Object existing;
        Object[] keys = this.keys;
        short[] values = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != null) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = values[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = null;
        values[gapSlot] = 0;
        --this.assigned;
    }

    protected boolean equals(Object v1, Object v2) {
        return v1 == v2 || v1 != null && v1.equals(v2);
    }

    private final class ValuesIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = ObjectShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortCursor();
        }

        @Override
        protected ShortCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    if (ObjectShortHashMap.this.keys[this.slot] != null) {
                        this.cursor.index = this.slot;
                        this.cursor.value = ObjectShortHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && ObjectShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = ObjectShortHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractShortCollection {
        private final ObjectShortHashMap<KType> owner;

        private ValuesContainer() {
            this.owner = ObjectShortHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(short value) {
            for (ObjectShortCursor c : this.owner) {
                if (c.value != value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            for (ObjectShortCursor c : this.owner) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            for (ObjectShortCursor c : this.owner) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(final short e) {
            return this.owner.removeAll(new ObjectShortPredicate<KType>(){

                @Override
                public boolean apply(KType key, short value) {
                    return value == e;
                }
            });
        }

        @Override
        public int removeAll(final ShortPredicate predicate) {
            return this.owner.removeAll(new ObjectShortPredicate<KType>(){

                @Override
                public boolean apply(KType key, short value) {
                    return predicate.apply(value);
                }
            });
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = ObjectShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectCursor();
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    Object existing = ObjectShortHashMap.this.keys[this.slot];
                    if (existing != null) {
                        this.cursor.index = this.slot;
                        this.cursor.value = existing;
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && ObjectShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = null;
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final ObjectShortHashMap<KType> owner;

        public KeysContainer() {
            this.owner = ObjectShortHashMap.this;
        }

        @Override
        public boolean contains(KType e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(final T procedure) {
            this.owner.forEach(new ObjectShortProcedure<KType>(){

                @Override
                public void apply(KType key, short value) {
                    procedure.apply(key);
                }
            });
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(final T predicate) {
            this.owner.forEach(new ObjectShortPredicate<KType>(){

                @Override
                public boolean apply(KType key, short value) {
                    return predicate.apply(key);
                }
            });
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(KType e) {
            boolean hasKey = this.owner.containsKey(e);
            if (hasKey) {
                this.owner.remove(e);
                return 1;
            }
            return 0;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectShortCursor<KType>> {
        private final ObjectShortCursor<KType> cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ObjectShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectShortCursor();
        }

        @Override
        protected ObjectShortCursor<KType> fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    Object existing = ObjectShortHashMap.this.keys[this.slot];
                    if (existing != null) {
                        this.cursor.index = this.slot;
                        this.cursor.key = existing;
                        this.cursor.value = ObjectShortHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && ObjectShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = null;
                this.cursor.value = ObjectShortHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ObjectShortCursor)this.done();
        }
    }
}

