/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.elasticsearch.sink;

import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.connector.elasticsearch.sink.ElasticsearchEmitter;
import org.apache.flink.connector.elasticsearch.sink.RequestIndexer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.index.IndexRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.update.UpdateRequest;
import org.apache.flink.util.Preconditions;

public class MapElasticsearchEmitter
implements ElasticsearchEmitter<Map<String, Object>> {
    private static final long serialVersionUID = 1L;
    private final String index;
    @Nullable
    private final String documentType;
    @Nullable
    private final String idFieldName;
    private final boolean isDynamicIndex;
    private transient Function<Map<String, Object>, String> indexProvider;

    public MapElasticsearchEmitter(String index, @Nullable String documentType, @Nullable String idFieldName, boolean isDynamicIndex) {
        this.index = (String)Preconditions.checkNotNull((Object)index);
        this.documentType = documentType;
        this.idFieldName = idFieldName;
        this.isDynamicIndex = isDynamicIndex;
    }

    @Override
    public void open() throws Exception {
        this.indexProvider = this.isDynamicIndex ? doc -> doc.get(this.index).toString() : doc -> this.index;
    }

    @Override
    public void emit(Map<String, Object> doc, SinkWriter.Context context, RequestIndexer indexer) {
        if (this.idFieldName != null) {
            UpdateRequest updateRequest = new UpdateRequest(this.indexProvider.apply(doc), this.documentType, doc.get(this.idFieldName).toString()).doc(doc).upsert(doc);
            indexer.add(updateRequest);
        } else {
            IndexRequest indexRequest = new IndexRequest(this.indexProvider.apply(doc), this.documentType).source(doc);
            indexer.add(indexRequest);
        }
    }
}

