/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.util.Preconditions;

@Internal
public abstract class StateSerializerProvider<T> {
    @Nullable
    TypeSerializer<T> registeredSerializer;

    public static <T> StateSerializerProvider<T> fromRestoredState(TypeSerializerSnapshot<T> stateSerializerSnapshot) {
        return new RestoredStateSerializerProvider<T>(stateSerializerSnapshot);
    }

    public static <T> StateSerializerProvider<T> fromNewState(TypeSerializer<T> registeredStateSerializer) {
        return new NewStateSerializerProvider<T>(registeredStateSerializer);
    }

    private StateSerializerProvider(@Nullable TypeSerializer<T> stateSerializer) {
        this.registeredSerializer = stateSerializer;
    }

    @Nonnull
    public abstract TypeSerializer<T> currentSchemaSerializer();

    @Nonnull
    public abstract TypeSerializer<T> previousSchemaSerializer();

    @Nonnull
    public abstract TypeSerializerSchemaCompatibility<T> registerNewSerializerForRestoredState(TypeSerializer<T> var1);

    private static class NewStateSerializerProvider<T>
    extends StateSerializerProvider<T> {
        NewStateSerializerProvider(TypeSerializer<T> registeredStateSerializer) {
            super((TypeSerializer)Preconditions.checkNotNull(registeredStateSerializer));
        }

        @Override
        @Nonnull
        public TypeSerializer<T> currentSchemaSerializer() {
            return this.registeredSerializer;
        }

        @Override
        @Nonnull
        public TypeSerializerSchemaCompatibility<T> registerNewSerializerForRestoredState(TypeSerializer<T> newSerializer) {
            throw new UnsupportedOperationException("A serializer has already been registered for the state; re-registration is not allowed.");
        }

        @Override
        @Nonnull
        public TypeSerializer<T> previousSchemaSerializer() {
            throw new UnsupportedOperationException("This is a NewStateSerializerProvider; you cannot get a restore serializer because there was no restored state.");
        }
    }

    private static class RestoredStateSerializerProvider<T>
    extends StateSerializerProvider<T> {
        @Nonnull
        private final TypeSerializerSnapshot<T> previousSerializerSnapshot;
        private boolean isRegisteredWithIncompatibleSerializer = false;
        @Nullable
        private TypeSerializer<T> cachedRestoredSerializer;

        RestoredStateSerializerProvider(TypeSerializerSnapshot<T> previousSerializerSnapshot) {
            super(null);
            this.previousSerializerSnapshot = (TypeSerializerSnapshot)Preconditions.checkNotNull(previousSerializerSnapshot);
        }

        @Override
        @Nonnull
        public TypeSerializer<T> currentSchemaSerializer() {
            if (this.registeredSerializer != null) {
                Preconditions.checkState((!this.isRegisteredWithIncompatibleSerializer ? 1 : 0) != 0, (Object)"Unable to provide a serializer with the current schema, because the restored state was registered with a new serializer that has incompatible schema.");
                return this.registeredSerializer;
            }
            return this.previousSchemaSerializer();
        }

        @Override
        @Nonnull
        public TypeSerializerSchemaCompatibility<T> registerNewSerializerForRestoredState(TypeSerializer<T> newSerializer) {
            Preconditions.checkNotNull(newSerializer);
            if (this.registeredSerializer != null) {
                throw new UnsupportedOperationException("A serializer has already been registered for the state; re-registration is not allowed.");
            }
            TypeSerializerSchemaCompatibility result = this.previousSerializerSnapshot.resolveSchemaCompatibility(newSerializer);
            if (result.isIncompatible()) {
                this.isRegisteredWithIncompatibleSerializer = true;
            }
            this.registeredSerializer = newSerializer;
            return result;
        }

        @Override
        @Nonnull
        public final TypeSerializer<T> previousSchemaSerializer() {
            if (this.cachedRestoredSerializer != null) {
                return this.cachedRestoredSerializer;
            }
            this.cachedRestoredSerializer = this.previousSerializerSnapshot.restoreSerializer();
            return this.cachedRestoredSerializer;
        }
    }
}

