/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonValue;
import org.apache.flink.util.Preconditions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JobVertexBackPressureInfo
implements ResponseBody {
    public static final String FIELD_NAME_STATUS = "status";
    public static final String FIELD_NAME_BACKPRESSURE_LEVEL = "backpressure-level";
    public static final String FIELD_NAME_END_TIMESTAMP = "end-timestamp";
    public static final String FIELD_NAME_SUBTASKS = "subtasks";
    private static final JobVertexBackPressureInfo DEPRECATED_JOB_VERTEX_BACK_PRESSURE_INFO = new JobVertexBackPressureInfo(VertexBackPressureStatus.DEPRECATED, null, null, null);
    @JsonProperty(value="status")
    private final VertexBackPressureStatus status;
    @JsonProperty(value="backpressure-level")
    private final VertexBackPressureLevel backpressureLevel;
    @JsonProperty(value="end-timestamp")
    private final Long endTimestamp;
    @JsonProperty(value="subtasks")
    private final List<SubtaskBackPressureInfo> subtasks;

    @JsonCreator
    public JobVertexBackPressureInfo(@JsonProperty(value="status") VertexBackPressureStatus status, @JsonProperty(value="backpressure-level") VertexBackPressureLevel backpressureLevel, @JsonProperty(value="end-timestamp") Long endTimestamp, @JsonProperty(value="subtasks") List<SubtaskBackPressureInfo> subtasks) {
        this.status = status;
        this.backpressureLevel = backpressureLevel;
        this.endTimestamp = endTimestamp;
        this.subtasks = subtasks;
    }

    public static JobVertexBackPressureInfo deprecated() {
        return DEPRECATED_JOB_VERTEX_BACK_PRESSURE_INFO;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobVertexBackPressureInfo that = (JobVertexBackPressureInfo)o;
        return Objects.equals((Object)this.status, (Object)that.status) && Objects.equals((Object)this.backpressureLevel, (Object)that.backpressureLevel) && Objects.equals(this.endTimestamp, that.endTimestamp) && Objects.equals(this.subtasks, that.subtasks);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.backpressureLevel, this.endTimestamp, this.subtasks});
    }

    public VertexBackPressureStatus getStatus() {
        return this.status;
    }

    @Nullable
    public VertexBackPressureLevel getBackpressureLevel() {
        return this.backpressureLevel;
    }

    @Nullable
    public Long getEndTimestamp() {
        return this.endTimestamp;
    }

    @Nullable
    public List<SubtaskBackPressureInfo> getSubtasks() {
        return this.subtasks == null ? null : Collections.unmodifiableList(this.subtasks);
    }

    public static enum VertexBackPressureLevel {
        OK("ok"),
        LOW("low"),
        HIGH("high");

        private String level;

        private VertexBackPressureLevel(String level) {
            this.level = level;
        }

        @JsonValue
        public String toString() {
            return this.level;
        }
    }

    public static enum VertexBackPressureStatus {
        DEPRECATED("deprecated"),
        OK("ok");

        private String status;

        private VertexBackPressureStatus(String status) {
            this.status = status;
        }

        @JsonValue
        public String toString() {
            return this.status;
        }
    }

    public static final class SubtaskBackPressureInfo {
        public static final String FIELD_NAME_SUBTASK = "subtask";
        public static final String FIELD_NAME_BACKPRESSURE_LEVEL = "backpressure-level";
        public static final String FIELD_NAME_RATIO = "ratio";
        @JsonProperty(value="subtask")
        private final int subtask;
        @JsonProperty(value="backpressure-level")
        private final VertexBackPressureLevel backpressureLevel;
        @JsonProperty(value="ratio")
        private final double ratio;

        public SubtaskBackPressureInfo(@JsonProperty(value="subtask") int subtask, @JsonProperty(value="backpressure-level") VertexBackPressureLevel backpressureLevel, @JsonProperty(value="ratio") double ratio) {
            this.subtask = subtask;
            this.backpressureLevel = (VertexBackPressureLevel)((Object)Preconditions.checkNotNull((Object)((Object)backpressureLevel)));
            this.ratio = ratio;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubtaskBackPressureInfo that = (SubtaskBackPressureInfo)o;
            return this.subtask == that.subtask && this.ratio == that.ratio && Objects.equals((Object)this.backpressureLevel, (Object)that.backpressureLevel);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.subtask, this.backpressureLevel, this.ratio});
        }

        public int getSubtask() {
            return this.subtask;
        }

        public VertexBackPressureLevel getBackpressureLevel() {
            return this.backpressureLevel;
        }

        public double getRatio() {
            return this.ratio;
        }
    }
}

