/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.util.Arrays;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.flink.metrics.HistogramStatistics;

public class DescriptiveStatisticsHistogramStatistics
extends HistogramStatistics {
    private final DescriptiveStatistics descriptiveStatistics;

    public DescriptiveStatisticsHistogramStatistics(DescriptiveStatistics latencyHistogram) {
        this.descriptiveStatistics = latencyHistogram;
    }

    public double getQuantile(double quantile) {
        return this.descriptiveStatistics.getPercentile(quantile * 100.0);
    }

    public long[] getValues() {
        return Arrays.stream(this.descriptiveStatistics.getValues()).mapToLong(i -> (long)i).toArray();
    }

    public int size() {
        return (int)this.descriptiveStatistics.getN();
    }

    public double getMean() {
        return this.descriptiveStatistics.getMean();
    }

    public double getStdDev() {
        return this.descriptiveStatistics.getStandardDeviation();
    }

    public long getMax() {
        return (long)this.descriptiveStatistics.getMax();
    }

    public long getMin() {
        return (long)this.descriptiveStatistics.getMin();
    }
}

