/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import org.apache.flink.runtime.rest.messages.ConversionException;
import org.apache.flink.util.Preconditions;

public abstract class MessageParameter<X> {
    private boolean resolved = false;
    private final MessageParameterRequisiteness requisiteness;
    private final String key;
    private X value;

    protected MessageParameter(String key, MessageParameterRequisiteness requisiteness) {
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.requisiteness = (MessageParameterRequisiteness)((Object)Preconditions.checkNotNull((Object)((Object)requisiteness)));
    }

    public final boolean isResolved() {
        return this.resolved;
    }

    public final void resolve(X value) {
        Preconditions.checkState((!this.resolved ? 1 : 0) != 0, (Object)"This parameter was already resolved.");
        this.value = Preconditions.checkNotNull(value);
        this.resolved = true;
    }

    public final void resolveFromString(String value) throws ConversionException {
        this.resolve(this.convertFromString(value));
    }

    protected abstract X convertFromString(String var1) throws ConversionException;

    protected abstract String convertToString(X var1);

    public final String getKey() {
        return this.key;
    }

    public final X getValue() {
        return this.value;
    }

    final String getValueAsString() {
        return this.value == null ? null : this.convertToString(this.value);
    }

    public final boolean isMandatory() {
        return this.requisiteness == MessageParameterRequisiteness.MANDATORY;
    }

    protected static enum MessageParameterRequisiteness {
        MANDATORY,
        OPTIONAL;

    }
}

