/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job.rescaling;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.jobmaster.RescalingBehaviour;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.async.AbstractAsynchronousOperationHandlers;
import org.apache.flink.runtime.rest.handler.async.AsynchronousOperationInfo;
import org.apache.flink.runtime.rest.handler.job.AsynchronousJobOperationKey;
import org.apache.flink.runtime.rest.handler.job.rescaling.RescalingStatusHeaders;
import org.apache.flink.runtime.rest.handler.job.rescaling.RescalingStatusMessageParameters;
import org.apache.flink.runtime.rest.handler.job.rescaling.RescalingTriggerHeaders;
import org.apache.flink.runtime.rest.handler.job.rescaling.RescalingTriggerMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.JobIDPathParameter;
import org.apache.flink.runtime.rest.messages.RescalingParallelismQueryParameter;
import org.apache.flink.runtime.rest.messages.TriggerId;
import org.apache.flink.runtime.rest.messages.TriggerIdPathParameter;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.SerializedThrowable;

public class RescalingHandlers
extends AbstractAsynchronousOperationHandlers<AsynchronousJobOperationKey, Acknowledge> {

    public class RescalingStatusHandler
    extends AbstractAsynchronousOperationHandlers.StatusHandler<RestfulGateway, AsynchronousOperationInfo, RescalingStatusMessageParameters> {
        public RescalingStatusHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders) {
            super(localRestAddress, leaderRetriever, timeout, responseHeaders, RescalingStatusHeaders.getInstance());
        }

        @Override
        protected AsynchronousJobOperationKey getOperationKey(HandlerRequest<EmptyRequestBody, RescalingStatusMessageParameters> request) {
            JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
            TriggerId triggerId = (TriggerId)((Object)request.getPathParameter(TriggerIdPathParameter.class));
            return AsynchronousJobOperationKey.of(triggerId, jobId);
        }

        @Override
        protected AsynchronousOperationInfo exceptionalOperationResultResponse(Throwable throwable) {
            return AsynchronousOperationInfo.completeExceptional(new SerializedThrowable(throwable));
        }

        @Override
        protected AsynchronousOperationInfo operationResultResponse(Acknowledge operationResult) {
            return AsynchronousOperationInfo.complete();
        }
    }

    public class RescalingTriggerHandler
    extends AbstractAsynchronousOperationHandlers.TriggerHandler<RestfulGateway, EmptyRequestBody, RescalingTriggerMessageParameters> {
        public RescalingTriggerHandler(CompletableFuture<String> localRestAddress, GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders) {
            super(localRestAddress, leaderRetriever, timeout, responseHeaders, RescalingTriggerHeaders.getInstance());
        }

        @Override
        protected CompletableFuture<Acknowledge> triggerOperation(HandlerRequest<EmptyRequestBody, RescalingTriggerMessageParameters> request, RestfulGateway gateway) throws RestHandlerException {
            JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
            List queryParameter = request.getQueryParameter(RescalingParallelismQueryParameter.class);
            if (queryParameter.isEmpty()) {
                throw new RestHandlerException("No new parallelism was specified.", HttpResponseStatus.BAD_REQUEST);
            }
            int newParallelism = (Integer)queryParameter.get(0);
            CompletableFuture<Acknowledge> rescalingFuture = gateway.rescaleJob(jobId, newParallelism, RescalingBehaviour.STRICT, RpcUtils.INF_TIMEOUT);
            return rescalingFuture;
        }

        @Override
        protected AsynchronousJobOperationKey createOperationKey(HandlerRequest<EmptyRequestBody, RescalingTriggerMessageParameters> request) {
            JobID jobId = (JobID)request.getPathParameter(JobIDPathParameter.class);
            return AsynchronousJobOperationKey.of(new TriggerId(), jobId);
        }
    }
}

