/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.Serializable;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.util.Preconditions;

public class ResultPartitionDeploymentDescriptor
implements Serializable {
    private static final long serialVersionUID = 6343547936086963705L;
    private final IntermediateDataSetID resultId;
    private final IntermediateResultPartitionID partitionId;
    private final ResultPartitionType partitionType;
    private final int numberOfSubpartitions;
    private final int maxParallelism;
    private final boolean sendScheduleOrUpdateConsumersMessage;

    public ResultPartitionDeploymentDescriptor(IntermediateDataSetID resultId, IntermediateResultPartitionID partitionId, ResultPartitionType partitionType, int numberOfSubpartitions, int maxParallelism, boolean lazyScheduling) {
        this.resultId = (IntermediateDataSetID)((Object)Preconditions.checkNotNull((Object)((Object)resultId)));
        this.partitionId = (IntermediateResultPartitionID)((Object)Preconditions.checkNotNull((Object)((Object)partitionId)));
        this.partitionType = (ResultPartitionType)((Object)Preconditions.checkNotNull((Object)((Object)partitionType)));
        KeyGroupRangeAssignment.checkParallelismPreconditions(maxParallelism);
        Preconditions.checkArgument((numberOfSubpartitions >= 1 ? 1 : 0) != 0);
        this.numberOfSubpartitions = numberOfSubpartitions;
        this.maxParallelism = maxParallelism;
        this.sendScheduleOrUpdateConsumersMessage = lazyScheduling;
    }

    public IntermediateDataSetID getResultId() {
        return this.resultId;
    }

    public IntermediateResultPartitionID getPartitionId() {
        return this.partitionId;
    }

    public ResultPartitionType getPartitionType() {
        return this.partitionType;
    }

    public int getNumberOfSubpartitions() {
        return this.numberOfSubpartitions;
    }

    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    public boolean sendScheduleOrUpdateConsumersMessage() {
        return this.sendScheduleOrUpdateConsumersMessage;
    }

    public String toString() {
        return String.format("ResultPartitionDeploymentDescriptor [result id: %s, partition id: %s, partition type: %s]", new Object[]{this.resultId, this.partitionId, this.partitionType});
    }

    public static ResultPartitionDeploymentDescriptor from(IntermediateResultPartition partition, int maxParallelism, boolean lazyScheduling) {
        IntermediateDataSetID resultId = partition.getIntermediateResult().getId();
        IntermediateResultPartitionID partitionId = partition.getPartitionId();
        ResultPartitionType partitionType = partition.getIntermediateResult().getResultType();
        int numberOfSubpartitions = 1;
        if (!partition.getConsumers().isEmpty() && !partition.getConsumers().get(0).isEmpty()) {
            if (partition.getConsumers().size() > 1) {
                throw new IllegalStateException("Currently, only a single consumer group per partition is supported.");
            }
            numberOfSubpartitions = partition.getConsumers().get(0).size();
        }
        return new ResultPartitionDeploymentDescriptor(resultId, partitionId, partitionType, numberOfSubpartitions, maxParallelism, lazyScheduling);
    }
}

