/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateSerializer;
import org.apache.flink.runtime.checkpoint.channel.RecoveredChannelStateHandler;
import org.apache.flink.runtime.state.AbstractChannelStateHandle;

class ChannelStateChunkReader {
    private final ChannelStateSerializer serializer;

    ChannelStateChunkReader(ChannelStateSerializer serializer) {
        this.serializer = serializer;
    }

    <Info, Context, Handle extends AbstractChannelStateHandle<Info>> void readChunk(FSDataInputStream source, long sourceOffset, RecoveredChannelStateHandler<Info, Context> stateHandler, Info channelInfo) throws IOException, InterruptedException {
        if (source.getPos() != sourceOffset) {
            source.seek(sourceOffset);
        }
        int length = this.serializer.readLength((InputStream)source);
        while (length > 0) {
            RecoveredChannelStateHandler.BufferWithContext<Context> bufferWithContext = stateHandler.getBuffer(channelInfo);
            try {
                while (length > 0 && bufferWithContext.buffer.isWritable()) {
                    length -= this.serializer.readData((InputStream)source, bufferWithContext.buffer, length);
                }
            }
            catch (Exception e) {
                bufferWithContext.buffer.recycle();
                throw e;
            }
            stateHandler.recover(channelInfo, bufferWithContext.context);
        }
    }
}

