/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.runtime.checkpoint.RescaledChannelsMapping;
import org.apache.flink.util.Preconditions;

public class InflightDataRescalingDescriptor
implements Serializable {
    public static final Set<Integer> NO_SUBTASKS = Collections.emptySet();
    public static final Map<Integer, RescaledChannelsMapping> NO_MAPPINGS = Collections.emptyMap();
    public static final InflightDataRescalingDescriptor NO_RESCALE = new InflightDataRescalingDescriptor(NO_SUBTASKS, NO_MAPPINGS);
    private static final long serialVersionUID = -3396674344669796295L;
    private final Set<Integer> oldSubtaskIndexes;
    private final Map<Integer, RescaledChannelsMapping> rescaledChannelsMappings;

    public InflightDataRescalingDescriptor(Set<Integer> oldSubtaskIndexes, Map<Integer, RescaledChannelsMapping> rescaledChannelsMappings) {
        this.oldSubtaskIndexes = (Set)Preconditions.checkNotNull(oldSubtaskIndexes);
        this.rescaledChannelsMappings = (Map)Preconditions.checkNotNull(rescaledChannelsMappings);
    }

    public int[] getOldSubtaskIndexes(int defaultSubtask) {
        int[] nArray;
        if (this.oldSubtaskIndexes.equals(NO_SUBTASKS)) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = defaultSubtask;
        } else {
            nArray = this.oldSubtaskIndexes.stream().mapToInt(Integer::intValue).toArray();
        }
        return nArray;
    }

    public RescaledChannelsMapping getChannelMapping(int gateOrPartitionIndex) {
        return this.rescaledChannelsMappings.getOrDefault(gateOrPartitionIndex, RescaledChannelsMapping.NO_CHANNEL_MAPPING);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InflightDataRescalingDescriptor that = (InflightDataRescalingDescriptor)o;
        return this.oldSubtaskIndexes.equals(that.oldSubtaskIndexes) && this.rescaledChannelsMappings.equals(that.rescaledChannelsMappings);
    }

    public int hashCode() {
        return Objects.hash(this.oldSubtaskIndexes, this.rescaledChannelsMappings);
    }
}

