/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateSerializer;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.checkpoint.channel.ResultSubpartitionInfo;
import org.apache.flink.runtime.state.AbstractChannelStateHandle;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelStatePendingResult {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelStatePendingResult.class);
    private final int subtaskIndex;
    private final long checkpointId;
    private final ChannelStateSerializer serializer;
    private final ChannelStateWriter.ChannelStateWriteResult result;
    private final Map<InputChannelInfo, AbstractChannelStateHandle.StateContentMetaInfo> inputChannelOffsets = new HashMap<InputChannelInfo, AbstractChannelStateHandle.StateContentMetaInfo>();
    private final Map<ResultSubpartitionInfo, AbstractChannelStateHandle.StateContentMetaInfo> resultSubpartitionOffsets = new HashMap<ResultSubpartitionInfo, AbstractChannelStateHandle.StateContentMetaInfo>();
    private boolean allInputsReceived = false;
    private boolean allOutputsReceived = false;

    public ChannelStatePendingResult(int subtaskIndex, long checkpointId, ChannelStateWriter.ChannelStateWriteResult result, ChannelStateSerializer serializer) {
        this.subtaskIndex = subtaskIndex;
        this.checkpointId = checkpointId;
        this.result = result;
        this.serializer = serializer;
    }

    public boolean isAllInputsReceived() {
        return this.allInputsReceived;
    }

    public boolean isAllOutputsReceived() {
        return this.allOutputsReceived;
    }

    public Map<InputChannelInfo, AbstractChannelStateHandle.StateContentMetaInfo> getInputChannelOffsets() {
        return this.inputChannelOffsets;
    }

    public Map<ResultSubpartitionInfo, AbstractChannelStateHandle.StateContentMetaInfo> getResultSubpartitionOffsets() {
        return this.resultSubpartitionOffsets;
    }

    void completeInput() {
        LOG.debug("complete input, output completed: {}", (Object)this.allOutputsReceived);
        Preconditions.checkArgument((!this.allInputsReceived ? 1 : 0) != 0);
        this.allInputsReceived = true;
    }

    void completeOutput() {
        LOG.debug("complete output, input completed: {}", (Object)this.allInputsReceived);
        Preconditions.checkArgument((!this.allOutputsReceived ? 1 : 0) != 0);
        this.allOutputsReceived = true;
    }

    public void finishResult(@Nullable StreamStateHandle stateHandle) throws IOException {
        Preconditions.checkState((stateHandle != null || this.inputChannelOffsets.isEmpty() && this.resultSubpartitionOffsets.isEmpty() ? 1 : 0) != 0, (Object)"The stateHandle just can be null when no data is written.");
        this.complete(stateHandle, this.result.inputChannelStateHandles, this.inputChannelOffsets, HandleFactory.INPUT_CHANNEL);
        this.complete(stateHandle, this.result.resultSubpartitionStateHandles, this.resultSubpartitionOffsets, HandleFactory.RESULT_SUBPARTITION);
    }

    private <I, H extends AbstractChannelStateHandle<I>> void complete(StreamStateHandle underlying, CompletableFuture<Collection<H>> future, Map<I, AbstractChannelStateHandle.StateContentMetaInfo> offsets, HandleFactory<I, H> handleFactory) throws IOException {
        ArrayList<H> handles = new ArrayList<H>();
        for (Map.Entry<I, AbstractChannelStateHandle.StateContentMetaInfo> e : offsets.entrySet()) {
            handles.add(this.createHandle(handleFactory, underlying, e.getKey(), e.getValue()));
        }
        future.complete(handles);
        LOG.debug("channel state write completed, checkpointId: {}, handles: {}", (Object)this.checkpointId, handles);
    }

    private <I, H extends AbstractChannelStateHandle<I>> H createHandle(HandleFactory<I, H> handleFactory, StreamStateHandle underlying, I channelInfo, AbstractChannelStateHandle.StateContentMetaInfo contentMetaInfo) throws IOException {
        Optional<byte[]> bytes = underlying.asBytesIfInMemory();
        if (bytes.isPresent()) {
            ByteStreamStateHandle extracted = new ByteStreamStateHandle(UUID.randomUUID().toString(), this.serializer.extractAndMerge(bytes.get(), contentMetaInfo.getOffsets()));
            return handleFactory.create(this.subtaskIndex, channelInfo, extracted, Collections.singletonList(this.serializer.getHeaderLength()), extracted.getStateSize());
        }
        return handleFactory.create(this.subtaskIndex, channelInfo, underlying, contentMetaInfo.getOffsets(), contentMetaInfo.getSize());
    }

    public void fail(Throwable e) {
        this.result.fail(e);
    }

    public boolean isDone() {
        return this.result.isDone();
    }

    private static interface HandleFactory<I, H extends AbstractChannelStateHandle<I>> {
        public static final HandleFactory<InputChannelInfo, InputChannelStateHandle> INPUT_CHANNEL = InputChannelStateHandle::new;
        public static final HandleFactory<ResultSubpartitionInfo, ResultSubpartitionStateHandle> RESULT_SUBPARTITION = ResultSubpartitionStateHandle::new;

        public H create(int var1, I var2, StreamStateHandle var3, List<Long> var4, long var5);
    }
}

