/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.GenericTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.LegacySerializerSnapshotTransformer;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSerializationUtil;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshotSerializationUtil;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.api.java.typeutils.runtime.FieldSerializer;
import org.apache.flink.api.java.typeutils.runtime.PojoFieldUtils;
import org.apache.flink.api.java.typeutils.runtime.PojoSerializerSnapshot;
import org.apache.flink.core.memory.ByteArrayInputStreamWithPos;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.util.Preconditions;

@Internal
public final class PojoSerializer<T>
extends TypeSerializer<T> {
    private static byte IS_NULL = 1;
    private static byte NO_SUBCLASS = (byte)2;
    private static byte IS_SUBCLASS = (byte)4;
    private static byte IS_TAGGED_SUBCLASS = (byte)8;
    private static final long serialVersionUID = 1L;
    private final Class<T> clazz;
    private transient Field[] fields;
    private final TypeSerializer<Object>[] fieldSerializers;
    private final int numFields;
    private final LinkedHashMap<Class<?>, Integer> registeredClasses;
    private final TypeSerializer<?>[] registeredSerializers;
    private transient Map<Class<?>, TypeSerializer<?>> subclassSerializerCache;
    private final ExecutionConfig executionConfig;
    private transient ClassLoader cl;

    public PojoSerializer(Class<T> clazz, TypeSerializer<?>[] fieldSerializers, Field[] fields, ExecutionConfig executionConfig) {
        this.clazz = Preconditions.checkNotNull(clazz);
        this.fieldSerializers = Preconditions.checkNotNull(fieldSerializers);
        this.fields = Preconditions.checkNotNull(fields);
        this.numFields = fieldSerializers.length;
        this.executionConfig = Preconditions.checkNotNull(executionConfig);
        for (int i = 0; i < this.numFields; ++i) {
            this.fields[i].setAccessible(true);
        }
        this.cl = Thread.currentThread().getContextClassLoader();
        LinkedHashSet<Class<?>> registeredSubclasses = PojoSerializer.getRegisteredSubclassesFromExecutionConfig(clazz, executionConfig);
        this.registeredClasses = PojoSerializer.createRegisteredSubclassTags(registeredSubclasses);
        this.registeredSerializers = PojoSerializer.createRegisteredSubclassSerializers(registeredSubclasses, executionConfig);
        this.subclassSerializerCache = new HashMap();
    }

    PojoSerializer(Class<T> clazz, Field[] fields, TypeSerializer<Object>[] fieldSerializers, LinkedHashMap<Class<?>, Integer> registeredClasses, TypeSerializer<?>[] registeredSerializers, Map<Class<?>, TypeSerializer<?>> subclassSerializerCache, ExecutionConfig executionConfig) {
        this.clazz = Preconditions.checkNotNull(clazz);
        this.fields = Preconditions.checkNotNull(fields);
        this.numFields = fields.length;
        this.fieldSerializers = Preconditions.checkNotNull(fieldSerializers);
        this.registeredClasses = Preconditions.checkNotNull(registeredClasses);
        this.registeredSerializers = Preconditions.checkNotNull(registeredSerializers);
        this.subclassSerializerCache = Preconditions.checkNotNull(subclassSerializerCache);
        this.executionConfig = Preconditions.checkNotNull(executionConfig);
        this.cl = Thread.currentThread().getContextClassLoader();
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public PojoSerializer<T> duplicate() {
        boolean stateful = false;
        TypeSerializer[] duplicateFieldSerializers = new TypeSerializer[this.fieldSerializers.length];
        for (int i = 0; i < this.fieldSerializers.length; ++i) {
            duplicateFieldSerializers[i] = this.fieldSerializers[i].duplicate();
            if (duplicateFieldSerializers[i] == this.fieldSerializers[i]) continue;
            stateful = true;
        }
        if (!stateful) {
            duplicateFieldSerializers = this.fieldSerializers;
        }
        return new PojoSerializer<T>(this.clazz, duplicateFieldSerializers, this.fields, this.executionConfig);
    }

    @Override
    public T createInstance() {
        if (this.clazz.isInterface() || Modifier.isAbstract(this.clazz.getModifiers())) {
            return null;
        }
        try {
            T t = this.clazz.newInstance();
            this.initializeFields(t);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate class.", e);
        }
    }

    protected void initializeFields(T t) {
        for (int i = 0; i < this.numFields; ++i) {
            if (this.fields[i] == null) continue;
            try {
                this.fields[i].set(t, this.fieldSerializers[i].createInstance());
                continue;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot initialize fields.", e);
            }
        }
    }

    @Override
    public T copy(T from) {
        if (from == null) {
            return null;
        }
        Class<?> actualType = from.getClass();
        if (actualType == this.clazz) {
            Object target;
            try {
                target = from.getClass().newInstance();
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot instantiate class.", t);
            }
            try {
                for (int i = 0; i < this.numFields; ++i) {
                    if (this.fields[i] == null) continue;
                    Object value = this.fields[i].get(from);
                    if (value != null) {
                        Object copy = this.fieldSerializers[i].copy(value);
                        this.fields[i].set(target, copy);
                        continue;
                    }
                    this.fields[i].set(target, null);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error during POJO copy, this should not happen since we check the fields before.");
            }
            return (T)target;
        }
        TypeSerializer<?> subclassSerializer = this.getSubclassSerializer(actualType);
        return (T)subclassSerializer.copy(from);
    }

    @Override
    public T copy(T from, T reuse) {
        if (from == null) {
            return null;
        }
        Class<?> actualType = from.getClass();
        if (reuse == null || actualType != reuse.getClass()) {
            return this.copy(from);
        }
        if (actualType == this.clazz) {
            try {
                for (int i = 0; i < this.numFields; ++i) {
                    if (this.fields[i] == null) continue;
                    Object value = this.fields[i].get(from);
                    if (value != null) {
                        Object reuseValue = this.fields[i].get(reuse);
                        Object copy = reuseValue != null ? this.fieldSerializers[i].copy(value, reuseValue) : this.fieldSerializers[i].copy(value);
                        this.fields[i].set(reuse, copy);
                        continue;
                    }
                    this.fields[i].set(reuse, null);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error during POJO copy, this should not happen since we check the fields before.", e);
            }
        } else {
            TypeSerializer<?> subclassSerializer = this.getSubclassSerializer(actualType);
            reuse = subclassSerializer.copy(from, reuse);
        }
        return reuse;
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(T value, DataOutputView target) throws IOException {
        int flags = 0;
        if (value == null) {
            target.writeByte(flags |= IS_NULL);
            return;
        }
        Integer subclassTag = -1;
        Class<?> actualClass = value.getClass();
        TypeSerializer<?> subclassSerializer = null;
        if (this.clazz != actualClass) {
            subclassTag = this.registeredClasses.get(actualClass);
            if (subclassTag != null) {
                flags |= IS_TAGGED_SUBCLASS;
                subclassSerializer = this.registeredSerializers[subclassTag];
            } else {
                flags |= IS_SUBCLASS;
                subclassSerializer = this.getSubclassSerializer(actualClass);
            }
        } else {
            flags |= NO_SUBCLASS;
        }
        target.writeByte(flags);
        if ((flags & IS_SUBCLASS) != 0) {
            target.writeUTF(actualClass.getName());
        } else if ((flags & IS_TAGGED_SUBCLASS) != 0) {
            target.writeByte(subclassTag);
        }
        if ((flags & NO_SUBCLASS) != 0) {
            try {
                for (int i = 0; i < this.numFields; ++i) {
                    Object o;
                    Object object = o = this.fields[i] != null ? this.fields[i].get(value) : null;
                    if (o == null) {
                        target.writeBoolean(true);
                        continue;
                    }
                    target.writeBoolean(false);
                    this.fieldSerializers[i].serialize(o, target);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error during POJO copy, this should not happen since we check the fields before.", e);
            }
        } else if (subclassSerializer != null) {
            subclassSerializer.serialize(value, target);
        }
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        Object target;
        byte flags = source.readByte();
        if ((flags & IS_NULL) != 0) {
            return null;
        }
        Class<?> actualSubclass = null;
        TypeSerializer<?> subclassSerializer = null;
        if ((flags & IS_SUBCLASS) != 0) {
            String subclassName = source.readUTF();
            try {
                actualSubclass = Class.forName(subclassName, true, this.cl);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Cannot instantiate class.", e);
            }
            subclassSerializer = this.getSubclassSerializer(actualSubclass);
            target = subclassSerializer.createInstance();
            this.initializeFields(target);
        } else if ((flags & IS_TAGGED_SUBCLASS) != 0) {
            byte subclassTag = source.readByte();
            subclassSerializer = this.registeredSerializers[subclassTag];
            target = subclassSerializer.createInstance();
            this.initializeFields(target);
        } else {
            target = this.createInstance();
        }
        if ((flags & NO_SUBCLASS) != 0) {
            try {
                for (int i = 0; i < this.numFields; ++i) {
                    boolean isNull = source.readBoolean();
                    if (this.fields[i] != null) {
                        if (isNull) {
                            this.fields[i].set(target, null);
                            continue;
                        }
                        Object field = this.fieldSerializers[i].deserialize(source);
                        this.fields[i].set(target, field);
                        continue;
                    }
                    if (isNull) continue;
                    this.fieldSerializers[i].deserialize(source);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error during POJO copy, this should not happen since we check the fields before.", e);
            }
        } else if (subclassSerializer != null) {
            target = subclassSerializer.deserialize(target, source);
        }
        return target;
    }

    @Override
    public T deserialize(T reuse, DataInputView source) throws IOException {
        byte flags = source.readByte();
        if ((flags & IS_NULL) != 0) {
            return null;
        }
        Class<?> subclass = null;
        TypeSerializer<?> subclassSerializer = null;
        if ((flags & IS_SUBCLASS) != 0) {
            String subclassName = source.readUTF();
            try {
                subclass = Class.forName(subclassName, true, this.cl);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Cannot instantiate class.", e);
            }
            subclassSerializer = this.getSubclassSerializer(subclass);
            if (reuse == null || subclass != reuse.getClass()) {
                reuse = subclassSerializer.createInstance();
                this.initializeFields(reuse);
            }
        } else if ((flags & IS_TAGGED_SUBCLASS) != 0) {
            byte subclassTag = source.readByte();
            subclassSerializer = this.registeredSerializers[subclassTag];
            if (reuse == null || ((PojoSerializer)subclassSerializer).clazz != reuse.getClass()) {
                reuse = subclassSerializer.createInstance();
                this.initializeFields(reuse);
            }
        } else if (reuse == null || this.clazz != reuse.getClass()) {
            reuse = this.createInstance();
        }
        if ((flags & NO_SUBCLASS) != 0) {
            try {
                for (int i = 0; i < this.numFields; ++i) {
                    boolean isNull = source.readBoolean();
                    if (this.fields[i] != null) {
                        if (isNull) {
                            this.fields[i].set(reuse, null);
                            continue;
                        }
                        Object reuseField = this.fields[i].get(reuse);
                        Object field = reuseField != null ? this.fieldSerializers[i].deserialize(reuseField, source) : this.fieldSerializers[i].deserialize(source);
                        this.fields[i].set(reuse, field);
                        continue;
                    }
                    if (isNull) continue;
                    this.fieldSerializers[i].deserialize(source);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error during POJO copy, this should not happen since we check the fields before.", e);
            }
        } else if (subclassSerializer != null) {
            reuse = subclassSerializer.deserialize(reuse, source);
        }
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        byte flags = source.readByte();
        target.writeByte(flags);
        if ((flags & IS_NULL) != 0) {
            return;
        }
        TypeSerializer<?> subclassSerializer = null;
        if ((flags & IS_SUBCLASS) != 0) {
            String className = source.readUTF();
            target.writeUTF(className);
            try {
                Class<?> subclass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                subclassSerializer = this.getSubclassSerializer(subclass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Cannot instantiate class.", e);
            }
        } else if ((flags & IS_TAGGED_SUBCLASS) != 0) {
            byte subclassTag = source.readByte();
            target.writeByte(subclassTag);
            subclassSerializer = this.registeredSerializers[subclassTag];
        }
        if ((flags & NO_SUBCLASS) != 0) {
            for (int i = 0; i < this.numFields; ++i) {
                boolean isNull = source.readBoolean();
                target.writeBoolean(isNull);
                if (isNull) continue;
                this.fieldSerializers[i].copy(source, target);
            }
        } else if (subclassSerializer != null) {
            subclassSerializer.copy(source, target);
        }
    }

    @Override
    public int hashCode() {
        return 31 * (31 * Arrays.hashCode(this.fieldSerializers) + Arrays.hashCode(this.registeredSerializers)) + Objects.hash(this.clazz, this.numFields, this.registeredClasses);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PojoSerializer) {
            PojoSerializer other = (PojoSerializer)obj;
            return this.clazz == other.clazz && Arrays.equals(this.fieldSerializers, other.fieldSerializers) && Arrays.equals(this.registeredSerializers, other.registeredSerializers) && this.numFields == other.numFields && this.registeredClasses.equals(other.registeredClasses);
        }
        return false;
    }

    @Override
    public PojoSerializerSnapshot<T> snapshotConfiguration() {
        return PojoSerializer.buildSnapshot(this.clazz, this.registeredClasses, this.registeredSerializers, this.fields, this.fieldSerializers, this.subclassSerializerCache);
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        out.defaultWriteObject();
        out.writeInt(this.fields.length);
        for (Field field : this.fields) {
            FieldSerializer.serializeField(field, out);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int numFields = in.readInt();
        this.fields = new Field[numFields];
        for (int i = 0; i < numFields; ++i) {
            this.fields[i] = FieldSerializer.deserializeField(in);
        }
        this.cl = Thread.currentThread().getContextClassLoader();
        this.subclassSerializerCache = new HashMap();
    }

    Class<T> getPojoClass() {
        return this.clazz;
    }

    Field[] getFields() {
        return this.fields;
    }

    TypeSerializer<?>[] getFieldSerializers() {
        return this.fieldSerializers;
    }

    TypeSerializer<?> getFieldSerializer(Field targetField) {
        int fieldIndex = this.findField(targetField.getName());
        if (fieldIndex == -1) {
            return null;
        }
        return this.fieldSerializers[fieldIndex];
    }

    ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    LinkedHashMap<Class<?>, Integer> getRegisteredClasses() {
        return this.registeredClasses;
    }

    TypeSerializer<?>[] getRegisteredSerializers() {
        return this.registeredSerializers;
    }

    LinkedHashMap<Class<?>, TypeSerializer<?>> getBundledSubclassSerializerRegistry() {
        LinkedHashMap result = new LinkedHashMap(this.registeredClasses.size());
        this.registeredClasses.forEach((registeredClass, id) -> result.put((Class<?>)registeredClass, this.registeredSerializers[id]));
        return result;
    }

    Map<Class<?>, TypeSerializer<?>> getSubclassSerializerCache() {
        return this.subclassSerializerCache;
    }

    private static LinkedHashSet<Class<?>> getRegisteredSubclassesFromExecutionConfig(Class<?> basePojoClass, ExecutionConfig executionConfig) {
        LinkedHashSet subclassesInRegistrationOrder = new LinkedHashSet(executionConfig.getRegisteredPojoTypes().size());
        for (Class clazz : executionConfig.getRegisteredPojoTypes()) {
            if (clazz.equals(basePojoClass) || !basePojoClass.isAssignableFrom(clazz)) continue;
            subclassesInRegistrationOrder.add(clazz);
        }
        return subclassesInRegistrationOrder;
    }

    private static LinkedHashMap<Class<?>, Integer> createRegisteredSubclassTags(LinkedHashSet<Class<?>> registeredSubclasses) {
        LinkedHashMap classToTag = new LinkedHashMap();
        int id = 0;
        for (Class clazz : registeredSubclasses) {
            classToTag.put(clazz, id);
            ++id;
        }
        return classToTag;
    }

    private static TypeSerializer<?>[] createRegisteredSubclassSerializers(LinkedHashSet<Class<?>> registeredSubclasses, ExecutionConfig executionConfig) {
        TypeSerializer[] subclassSerializers = new TypeSerializer[registeredSubclasses.size()];
        int i = 0;
        for (Class clazz : registeredSubclasses) {
            subclassSerializers[i] = TypeExtractor.createTypeInfo(clazz).createSerializer(executionConfig);
            ++i;
        }
        return subclassSerializers;
    }

    TypeSerializer<?> getSubclassSerializer(Class<?> subclass) {
        TypeSerializer<?> result = this.subclassSerializerCache.get(subclass);
        if (result == null) {
            result = this.createSubclassSerializer(subclass);
            this.subclassSerializerCache.put(subclass, result);
        }
        return result;
    }

    private TypeSerializer<?> createSubclassSerializer(Class<?> subclass) {
        TypeSerializer<?> serializer = TypeExtractor.createTypeInfo(subclass).createSerializer(this.executionConfig);
        if (serializer instanceof PojoSerializer) {
            PojoSerializer subclassSerializer = (PojoSerializer)serializer;
            subclassSerializer.copyBaseFieldOrder(this);
        }
        return serializer;
    }

    private int findField(String fieldName) {
        int foundIndex = 0;
        for (Field field : this.fields) {
            if (field != null && fieldName.equals(field.getName())) {
                return foundIndex;
            }
            ++foundIndex;
        }
        return -1;
    }

    private void copyBaseFieldOrder(PojoSerializer<?> baseSerializer) {
    }

    private static <T> PojoSerializerSnapshot<T> buildSnapshot(Class<T> pojoType, LinkedHashMap<Class<?>, Integer> registeredSubclassesToTags, TypeSerializer<?>[] registeredSubclassSerializers, Field[] fields, TypeSerializer<?>[] fieldSerializers, Map<Class<?>, TypeSerializer<?>> nonRegisteredSubclassSerializerCache) {
        LinkedHashMap subclassRegistry = new LinkedHashMap(registeredSubclassesToTags.size());
        for (Map.Entry<Class<?>, Integer> entry : registeredSubclassesToTags.entrySet()) {
            subclassRegistry.put(entry.getKey(), registeredSubclassSerializers[entry.getValue()]);
        }
        return new PojoSerializerSnapshot<T>(pojoType, fields, fieldSerializers, subclassRegistry, nonRegisteredSubclassSerializerCache);
    }

    @Deprecated
    public static final class PojoSerializerConfigSnapshot<T>
    extends GenericTypeSerializerConfigSnapshot<T> {
        private static final int VERSION = 1;
        private LinkedHashMap<String, Tuple2<TypeSerializer<?>, TypeSerializerSnapshot<?>>> fieldToSerializerConfigSnapshot;
        private LinkedHashMap<Class<?>, Tuple2<TypeSerializer<?>, TypeSerializerSnapshot<?>>> registeredSubclassesToSerializerConfigSnapshots;
        private HashMap<Class<?>, Tuple2<TypeSerializer<?>, TypeSerializerSnapshot<?>>> nonRegisteredSubclassesToSerializerConfigSnapshots;
        private boolean ignoreTypeSerializerSerialization;

        public PojoSerializerConfigSnapshot() {
        }

        public PojoSerializerConfigSnapshot(Class<T> pojoType, LinkedHashMap<String, Tuple2<TypeSerializer<?>, TypeSerializerSnapshot<?>>> fieldToSerializerConfigSnapshot, LinkedHashMap<Class<?>, Tuple2<TypeSerializer<?>, TypeSerializerSnapshot<?>>> registeredSubclassesToSerializerConfigSnapshots, HashMap<Class<?>, Tuple2<TypeSerializer<?>, TypeSerializerSnapshot<?>>> nonRegisteredSubclassesToSerializerConfigSnapshots) {
            this(pojoType, fieldToSerializerConfigSnapshot, registeredSubclassesToSerializerConfigSnapshots, nonRegisteredSubclassesToSerializerConfigSnapshots, false);
        }

        public PojoSerializerConfigSnapshot(Class<T> pojoType, LinkedHashMap<String, Tuple2<TypeSerializer<?>, TypeSerializerSnapshot<?>>> fieldToSerializerConfigSnapshot, LinkedHashMap<Class<?>, Tuple2<TypeSerializer<?>, TypeSerializerSnapshot<?>>> registeredSubclassesToSerializerConfigSnapshots, HashMap<Class<?>, Tuple2<TypeSerializer<?>, TypeSerializerSnapshot<?>>> nonRegisteredSubclassesToSerializerConfigSnapshots, boolean ignoreTypeSerializerSerialization) {
            super(pojoType);
            this.fieldToSerializerConfigSnapshot = Preconditions.checkNotNull(fieldToSerializerConfigSnapshot);
            this.registeredSubclassesToSerializerConfigSnapshots = Preconditions.checkNotNull(registeredSubclassesToSerializerConfigSnapshots);
            this.nonRegisteredSubclassesToSerializerConfigSnapshots = Preconditions.checkNotNull(nonRegisteredSubclassesToSerializerConfigSnapshots);
            this.ignoreTypeSerializerSerialization = ignoreTypeSerializerSerialization;
        }

        @Override
        public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializer<T> newSerializer) {
            LinkedHashMap<String, TypeSerializerSnapshot<?>> legacyFieldSerializerSnapshots = PojoSerializerConfigSnapshot.preprocessLegacySerializerSnapshotTuples(this.fieldToSerializerConfigSnapshot);
            int numFields = legacyFieldSerializerSnapshots.size();
            ArrayList fields = new ArrayList(numFields);
            ArrayList fieldSerializerSnapshots = new ArrayList(numFields);
            legacyFieldSerializerSnapshots.forEach((fieldName, fieldSerializerSnapshot) -> {
                fields.add(PojoFieldUtils.getField(fieldName, this.getTypeClass()));
                fieldSerializerSnapshots.add(fieldSerializerSnapshot);
            });
            PojoSerializerSnapshot<T> newSnapshot = new PojoSerializerSnapshot<T>(this.getTypeClass(), fields.toArray(new Field[numFields]), fieldSerializerSnapshots.toArray(new TypeSerializerSnapshot[numFields]), PojoSerializerConfigSnapshot.preprocessLegacySerializerSnapshotTuples(this.registeredSubclassesToSerializerConfigSnapshots), PojoSerializerConfigSnapshot.preprocessLegacySerializerSnapshotTuples(this.nonRegisteredSubclassesToSerializerConfigSnapshots));
            return newSnapshot.resolveSchemaCompatibility(newSerializer);
        }

        private static <K> LinkedHashMap<K, TypeSerializerSnapshot<?>> preprocessLegacySerializerSnapshotTuples(Map<K, Tuple2<TypeSerializer<?>, TypeSerializerSnapshot<?>>> originalMap) {
            LinkedHashMap converted = new LinkedHashMap(originalMap.size());
            originalMap.forEach((key, serializerSnapshotTuple) -> {
                TypeSerializer serializer = (TypeSerializer)serializerSnapshotTuple.f0;
                TypeSerializerSnapshot snapshot = (TypeSerializerSnapshot)serializerSnapshotTuple.f1;
                if (snapshot instanceof TypeSerializerConfigSnapshot) {
                    ((TypeSerializerConfigSnapshot)snapshot).setPriorSerializer(serializer);
                }
                if (serializer instanceof LegacySerializerSnapshotTransformer) {
                    snapshot = ((LegacySerializerSnapshotTransformer)((Object)serializer)).transformLegacySerializerSnapshot(snapshot);
                }
                converted.put(key, snapshot);
            });
            return converted;
        }

        @Override
        public void write(DataOutputView out) throws IOException {
            super.write(out);
            try (ByteArrayOutputStreamWithPos outWithPos = new ByteArrayOutputStreamWithPos();
                 DataOutputViewStreamWrapper outViewWrapper = new DataOutputViewStreamWrapper(outWithPos);){
                out.writeInt(this.fieldToSerializerConfigSnapshot.size());
                for (Map.Entry<String, Tuple2<TypeSerializer<?>, TypeSerializerSnapshot<?>>> entry : this.fieldToSerializerConfigSnapshot.entrySet()) {
                    outViewWrapper.writeUTF(entry.getKey());
                    out.writeInt(outWithPos.getPosition());
                    if (!this.ignoreTypeSerializerSerialization) {
                        TypeSerializerSerializationUtil.writeSerializer(outViewWrapper, (TypeSerializer)entry.getValue().f0);
                    }
                    out.writeInt(outWithPos.getPosition());
                    TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot(outViewWrapper, (TypeSerializerSnapshot)entry.getValue().f1, (TypeSerializer)entry.getValue().f0);
                }
                out.writeInt(this.registeredSubclassesToSerializerConfigSnapshots.size());
                for (Map.Entry<Object, Tuple2<TypeSerializer<?>, TypeSerializerSnapshot<?>>> entry : this.registeredSubclassesToSerializerConfigSnapshots.entrySet()) {
                    outViewWrapper.writeUTF(((Class)entry.getKey()).getName());
                    out.writeInt(outWithPos.getPosition());
                    if (!this.ignoreTypeSerializerSerialization) {
                        TypeSerializerSerializationUtil.writeSerializer(outViewWrapper, (TypeSerializer)entry.getValue().f0);
                    }
                    out.writeInt(outWithPos.getPosition());
                    TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot(outViewWrapper, (TypeSerializerSnapshot)entry.getValue().f1, (TypeSerializer)entry.getValue().f0);
                }
                out.writeInt(this.nonRegisteredSubclassesToSerializerConfigSnapshots.size());
                for (Map.Entry<Object, Tuple2<TypeSerializer<?>, TypeSerializerSnapshot<?>>> entry : this.nonRegisteredSubclassesToSerializerConfigSnapshots.entrySet()) {
                    outViewWrapper.writeUTF(((Class)entry.getKey()).getName());
                    out.writeInt(outWithPos.getPosition());
                    if (!this.ignoreTypeSerializerSerialization) {
                        TypeSerializerSerializationUtil.writeSerializer(outViewWrapper, (TypeSerializer)entry.getValue().f0);
                    }
                    out.writeInt(outWithPos.getPosition());
                    TypeSerializerSnapshotSerializationUtil.writeSerializerSnapshot(outViewWrapper, (TypeSerializerSnapshot)entry.getValue().f1, (TypeSerializer)entry.getValue().f0);
                }
                out.writeInt(outWithPos.getPosition());
                out.write(outWithPos.getBuf(), 0, outWithPos.getPosition());
            }
        }

        @Override
        public void read(DataInputView in) throws IOException {
            super.read(in);
            int numFields = in.readInt();
            int[] fieldSerializerOffsets = new int[numFields * 2];
            for (int i = 0; i < numFields; ++i) {
                fieldSerializerOffsets[i * 2] = in.readInt();
                fieldSerializerOffsets[i * 2 + 1] = in.readInt();
            }
            int numRegisteredSubclasses = in.readInt();
            int[] registeredSerializerOffsets = new int[numRegisteredSubclasses * 2];
            for (int i = 0; i < numRegisteredSubclasses; ++i) {
                registeredSerializerOffsets[i * 2] = in.readInt();
                registeredSerializerOffsets[i * 2 + 1] = in.readInt();
            }
            int numCachedSubclassSerializers = in.readInt();
            int[] cachedSerializerOffsets = new int[numCachedSubclassSerializers * 2];
            for (int i = 0; i < numCachedSubclassSerializers; ++i) {
                cachedSerializerOffsets[i * 2] = in.readInt();
                cachedSerializerOffsets[i * 2 + 1] = in.readInt();
            }
            int totalBytes = in.readInt();
            byte[] buffer = new byte[totalBytes];
            in.readFully(buffer);
            try (ByteArrayInputStreamWithPos inWithPos = new ByteArrayInputStreamWithPos(buffer);
                 DataInputViewStreamWrapper inViewWrapper = new DataInputViewStreamWrapper(inWithPos);){
                this.fieldToSerializerConfigSnapshot = new LinkedHashMap(numFields);
                for (int i = 0; i < numFields; ++i) {
                    String fieldName = inViewWrapper.readUTF();
                    inWithPos.setPosition(fieldSerializerOffsets[i * 2]);
                    TypeSerializer fieldSerializer = TypeSerializerSerializationUtil.tryReadSerializer(inViewWrapper, this.getUserCodeClassLoader(), true);
                    inWithPos.setPosition(fieldSerializerOffsets[i * 2 + 1]);
                    TypeSerializerSnapshot fieldSerializerConfigSnapshot = TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot(inViewWrapper, this.getUserCodeClassLoader(), fieldSerializer);
                    this.fieldToSerializerConfigSnapshot.put(fieldName, new Tuple2(fieldSerializer, fieldSerializerConfigSnapshot));
                }
                this.registeredSubclassesToSerializerConfigSnapshots = new LinkedHashMap(numRegisteredSubclasses);
                for (int i = 0; i < numRegisteredSubclasses; ++i) {
                    Class<?> registeredSubclass;
                    String registeredSubclassname = inViewWrapper.readUTF();
                    try {
                        registeredSubclass = Class.forName(registeredSubclassname, true, this.getUserCodeClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException("Cannot find requested class " + registeredSubclassname + " in classpath.", e);
                    }
                    inWithPos.setPosition(registeredSerializerOffsets[i * 2]);
                    TypeSerializer registeredSubclassSerializer = TypeSerializerSerializationUtil.tryReadSerializer(inViewWrapper, this.getUserCodeClassLoader(), true);
                    inWithPos.setPosition(registeredSerializerOffsets[i * 2 + 1]);
                    TypeSerializerSnapshot registeredSubclassSerializerConfigSnapshot = TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot(inViewWrapper, this.getUserCodeClassLoader(), registeredSubclassSerializer);
                    this.registeredSubclassesToSerializerConfigSnapshots.put(registeredSubclass, new Tuple2(registeredSubclassSerializer, registeredSubclassSerializerConfigSnapshot));
                }
                this.nonRegisteredSubclassesToSerializerConfigSnapshots = new HashMap(numCachedSubclassSerializers);
                for (int i = 0; i < numCachedSubclassSerializers; ++i) {
                    Class<?> cachedSubclass;
                    String cachedSubclassname = inViewWrapper.readUTF();
                    try {
                        cachedSubclass = Class.forName(cachedSubclassname, true, this.getUserCodeClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException("Cannot find requested class " + cachedSubclassname + " in classpath.", e);
                    }
                    inWithPos.setPosition(cachedSerializerOffsets[i * 2]);
                    TypeSerializer cachedSubclassSerializer = TypeSerializerSerializationUtil.tryReadSerializer(inViewWrapper, this.getUserCodeClassLoader(), true);
                    inWithPos.setPosition(cachedSerializerOffsets[i * 2 + 1]);
                    TypeSerializerSnapshot cachedSubclassSerializerConfigSnapshot = TypeSerializerSnapshotSerializationUtil.readSerializerSnapshot(inViewWrapper, this.getUserCodeClassLoader(), cachedSubclassSerializer);
                    this.nonRegisteredSubclassesToSerializerConfigSnapshots.put(cachedSubclass, new Tuple2(cachedSubclassSerializer, cachedSubclassSerializerConfigSnapshot));
                }
            }
        }

        @Override
        public int getVersion() {
            return 1;
        }

        public LinkedHashMap<String, Tuple2<TypeSerializer<?>, TypeSerializerSnapshot<?>>> getFieldToSerializerConfigSnapshot() {
            return this.fieldToSerializerConfigSnapshot;
        }

        public LinkedHashMap<Class<?>, Tuple2<TypeSerializer<?>, TypeSerializerSnapshot<?>>> getRegisteredSubclassesToSerializerConfigSnapshots() {
            return this.registeredSubclassesToSerializerConfigSnapshots;
        }

        public HashMap<Class<?>, Tuple2<TypeSerializer<?>, TypeSerializerSnapshot<?>>> getNonRegisteredSubclassesToSerializerConfigSnapshots() {
            return this.nonRegisteredSubclassesToSerializerConfigSnapshots;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && obj instanceof PojoSerializerConfigSnapshot && this.fieldToSerializerConfigSnapshot.equals(((PojoSerializerConfigSnapshot)obj).getFieldToSerializerConfigSnapshot()) && this.registeredSubclassesToSerializerConfigSnapshots.equals(((PojoSerializerConfigSnapshot)obj).getRegisteredSubclassesToSerializerConfigSnapshots()) && this.nonRegisteredSubclassesToSerializerConfigSnapshots.equals(((PojoSerializerConfigSnapshot)obj).nonRegisteredSubclassesToSerializerConfigSnapshots);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + Objects.hash(this.fieldToSerializerConfigSnapshot, this.registeredSubclassesToSerializerConfigSnapshots, this.nonRegisteredSubclassesToSerializerConfigSnapshots);
        }
    }
}

