/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.nio.ByteBuffer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.memory.HybridMemorySegment;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemoryUtils;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TaskManagerExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class MemorySegmentFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MemorySegmentFactory.class);
    private static final Runnable NO_OP = () -> {};

    public static MemorySegment wrap(byte[] buffer) {
        return new HybridMemorySegment(buffer, null);
    }

    public static MemorySegment wrapCopy(byte[] bytes, int start, int end) throws IllegalArgumentException {
        Preconditions.checkArgument(end >= start);
        Preconditions.checkArgument(end <= bytes.length);
        MemorySegment copy = MemorySegmentFactory.allocateUnpooledSegment(end - start);
        copy.put(0, bytes, start, copy.size());
        return copy;
    }

    public static MemorySegment wrapInt(int value) {
        return MemorySegmentFactory.wrap(ByteBuffer.allocate(4).putInt(value).array());
    }

    public static MemorySegment allocateUnpooledSegment(int size) {
        return MemorySegmentFactory.allocateUnpooledSegment(size, null);
    }

    public static MemorySegment allocateUnpooledSegment(int size, Object owner) {
        return new HybridMemorySegment(new byte[size], owner);
    }

    public static MemorySegment allocateUnpooledOffHeapMemory(int size) {
        return MemorySegmentFactory.allocateUnpooledOffHeapMemory(size, null);
    }

    public static MemorySegment allocateUnpooledOffHeapMemory(int size, Object owner) {
        ByteBuffer memory = MemorySegmentFactory.allocateDirectMemory(size);
        return new HybridMemorySegment(memory, owner);
    }

    @VisibleForTesting
    public static MemorySegment allocateOffHeapUnsafeMemory(int size) {
        return MemorySegmentFactory.allocateOffHeapUnsafeMemory(size, null, NO_OP);
    }

    private static ByteBuffer allocateDirectMemory(int size) {
        try {
            return ByteBuffer.allocateDirect(size);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            TaskManagerExceptionUtils.tryEnrichTaskManagerError(outOfMemoryError);
            if (ExceptionUtils.isDirectOutOfMemoryError(outOfMemoryError)) {
                LOG.error("Cannot allocate direct memory segment", (Throwable)outOfMemoryError);
            }
            ExceptionUtils.rethrow(outOfMemoryError);
            return null;
        }
    }

    public static MemorySegment allocateOffHeapUnsafeMemory(int size, Object owner, Runnable customCleanupAction) {
        long address = MemoryUtils.allocateUnsafe(size);
        ByteBuffer offHeapBuffer = MemoryUtils.wrapUnsafeMemoryWithByteBuffer(address, size);
        Runnable cleaner = MemoryUtils.createMemoryGcCleaner(offHeapBuffer, address, customCleanupAction);
        return new HybridMemorySegment(offHeapBuffer, owner, false, cleaner);
    }

    public static MemorySegment wrapOffHeapMemory(ByteBuffer memory) {
        return new HybridMemorySegment(memory, null);
    }
}

