/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.transformations.SinkTransformation;
import org.apache.flink.streaming.connectors.kafka.FlinkKafkaProducer09;
import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkFixedPartitioner;
import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaDelegatePartitioner;
import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;
import org.apache.flink.streaming.connectors.kafka.partitioner.KafkaPartitioner;
import org.apache.flink.streaming.util.serialization.KeyedSerializationSchema;
import org.apache.flink.streaming.util.serialization.KeyedSerializationSchemaWrapper;
import org.apache.flink.util.SerializableObject;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

@PublicEvolving
public class FlinkKafkaProducer010<T>
extends FlinkKafkaProducer09<T> {
    private static final long serialVersionUID = 1L;
    private boolean writeTimestampToKafka = false;

    public FlinkKafkaProducer010(String brokerList, String topicId, SerializationSchema<T> serializationSchema) {
        this(topicId, (KeyedSerializationSchema<T>)new KeyedSerializationSchemaWrapper(serializationSchema), FlinkKafkaProducer010.getPropertiesFromBrokerList((String)brokerList), (FlinkKafkaPartitioner<T>)new FlinkFixedPartitioner());
    }

    public FlinkKafkaProducer010(String topicId, SerializationSchema<T> serializationSchema, Properties producerConfig) {
        this(topicId, (KeyedSerializationSchema<T>)new KeyedSerializationSchemaWrapper(serializationSchema), producerConfig, (FlinkKafkaPartitioner<T>)new FlinkFixedPartitioner());
    }

    public FlinkKafkaProducer010(String topicId, SerializationSchema<T> serializationSchema, Properties producerConfig, @Nullable FlinkKafkaPartitioner<T> customPartitioner) {
        this(topicId, (KeyedSerializationSchema<T>)new KeyedSerializationSchemaWrapper(serializationSchema), producerConfig, customPartitioner);
    }

    public FlinkKafkaProducer010(String brokerList, String topicId, KeyedSerializationSchema<T> serializationSchema) {
        this(topicId, serializationSchema, FlinkKafkaProducer010.getPropertiesFromBrokerList((String)brokerList), (FlinkKafkaPartitioner<T>)new FlinkFixedPartitioner());
    }

    public FlinkKafkaProducer010(String topicId, KeyedSerializationSchema<T> serializationSchema, Properties producerConfig) {
        this(topicId, serializationSchema, producerConfig, (FlinkKafkaPartitioner<T>)new FlinkFixedPartitioner());
    }

    public FlinkKafkaProducer010(String topicId, KeyedSerializationSchema<T> serializationSchema, Properties producerConfig, @Nullable FlinkKafkaPartitioner<T> customPartitioner) {
        super(topicId, serializationSchema, producerConfig, customPartitioner);
    }

    public void setWriteTimestampToKafka(boolean writeTimestampToKafka) {
        this.writeTimestampToKafka = writeTimestampToKafka;
    }

    @Deprecated
    public static <T> FlinkKafkaProducer010Configuration<T> writeToKafkaWithTimestamps(DataStream<T> inStream, String topicId, KeyedSerializationSchema<T> serializationSchema, Properties producerConfig) {
        return FlinkKafkaProducer010.writeToKafkaWithTimestamps(inStream, topicId, serializationSchema, producerConfig, new FlinkFixedPartitioner());
    }

    @Deprecated
    public static <T> FlinkKafkaProducer010Configuration<T> writeToKafkaWithTimestamps(DataStream<T> inStream, String topicId, SerializationSchema<T> serializationSchema, Properties producerConfig) {
        return FlinkKafkaProducer010.writeToKafkaWithTimestamps(inStream, topicId, new KeyedSerializationSchemaWrapper(serializationSchema), producerConfig, new FlinkFixedPartitioner());
    }

    @Deprecated
    public static <T> FlinkKafkaProducer010Configuration<T> writeToKafkaWithTimestamps(DataStream<T> inStream, String topicId, KeyedSerializationSchema<T> serializationSchema, Properties producerConfig, FlinkKafkaPartitioner<T> customPartitioner) {
        FlinkKafkaProducer010<T> kafkaProducer = new FlinkKafkaProducer010<T>(topicId, serializationSchema, producerConfig, customPartitioner);
        DataStreamSink streamSink = inStream.addSink(kafkaProducer);
        return new FlinkKafkaProducer010Configuration(streamSink, inStream, kafkaProducer);
    }

    @Deprecated
    public static <T> FlinkKafkaProducer010Configuration<T> writeToKafkaWithTimestamps(DataStream<T> inStream, String topicId, KeyedSerializationSchema<T> serializationSchema, Properties producerConfig, KafkaPartitioner<T> customPartitioner) {
        FlinkKafkaProducer010<T> kafkaProducer = new FlinkKafkaProducer010<T>(topicId, serializationSchema, producerConfig, new FlinkKafkaDelegatePartitioner(customPartitioner));
        DataStreamSink streamSink = inStream.addSink(kafkaProducer);
        return new FlinkKafkaProducer010Configuration(streamSink, inStream, kafkaProducer);
    }

    @Deprecated
    public FlinkKafkaProducer010(String topicId, SerializationSchema<T> serializationSchema, Properties producerConfig, KafkaPartitioner<T> customPartitioner) {
        this(topicId, (KeyedSerializationSchema<T>)new KeyedSerializationSchemaWrapper(serializationSchema), producerConfig, customPartitioner);
    }

    @Deprecated
    public FlinkKafkaProducer010(String topicId, KeyedSerializationSchema<T> serializationSchema, Properties producerConfig, KafkaPartitioner<T> customPartitioner) {
        super(topicId, serializationSchema, producerConfig, customPartitioner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(T value, SinkFunction.Context context) throws Exception {
        int[] partitions;
        this.checkErroneous();
        byte[] serializedKey = this.schema.serializeKey(value);
        byte[] serializedValue = this.schema.serializeValue(value);
        String targetTopic = this.schema.getTargetTopic(value);
        if (targetTopic == null) {
            targetTopic = this.defaultTopicId;
        }
        Long timestamp = null;
        if (this.writeTimestampToKafka) {
            timestamp = context.timestamp();
        }
        if (null == (partitions = (int[])this.topicPartitionsMap.get(targetTopic))) {
            partitions = FlinkKafkaProducer010.getPartitionsByTopic((String)targetTopic, (KafkaProducer)this.producer);
            this.topicPartitionsMap.put(targetTopic, partitions);
        }
        ProducerRecord record = this.flinkKafkaPartitioner == null ? new ProducerRecord(targetTopic, null, timestamp, (Object)serializedKey, (Object)serializedValue) : new ProducerRecord(targetTopic, Integer.valueOf(this.flinkKafkaPartitioner.partition(value, serializedKey, serializedValue, targetTopic, partitions)), timestamp, (Object)serializedKey, (Object)serializedValue);
        if (this.flushOnCheckpoint) {
            SerializableObject serializableObject = this.pendingRecordsLock;
            synchronized (serializableObject) {
                ++this.pendingRecords;
            }
        }
        this.producer.send(record, this.callback);
    }

    @Deprecated
    public static class FlinkKafkaProducer010Configuration<T>
    extends DataStreamSink<T> {
        private final FlinkKafkaProducer010 producer;
        private final SinkTransformation<T> transformation;

        private FlinkKafkaProducer010Configuration(DataStreamSink<T> originalSink, DataStream<T> inputStream, FlinkKafkaProducer010<T> producer) {
            super(inputStream, originalSink.getTransformation().getOperator());
            this.transformation = originalSink.getTransformation();
            this.producer = producer;
        }

        public void setLogFailuresOnly(boolean logFailuresOnly) {
            this.producer.setLogFailuresOnly(logFailuresOnly);
        }

        public void setFlushOnCheckpoint(boolean flush) {
            this.producer.setFlushOnCheckpoint(flush);
        }

        public void setWriteTimestampToKafka(boolean writeTimestampToKafka) {
            this.producer.writeTimestampToKafka = writeTimestampToKafka;
        }

        public SinkTransformation<T> getTransformation() {
            return this.transformation;
        }

        public DataStreamSink<T> name(String name) {
            this.transformation.setName(name);
            return this;
        }

        public DataStreamSink<T> uid(String uid) {
            this.transformation.setUid(uid);
            return this;
        }

        public DataStreamSink<T> setUidHash(String uidHash) {
            this.transformation.setUidHash(uidHash);
            return this;
        }

        public DataStreamSink<T> setParallelism(int parallelism) {
            this.transformation.setParallelism(parallelism);
            return this;
        }

        public DataStreamSink<T> disableChaining() {
            this.transformation.setChainingStrategy(ChainingStrategy.NEVER);
            return this;
        }

        public DataStreamSink<T> slotSharingGroup(String slotSharingGroup) {
            this.transformation.setSlotSharingGroup(slotSharingGroup);
            return this;
        }
    }
}

