/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.table;

import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcDmlOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcOptions;
import org.apache.flink.connector.jdbc.table.JdbcDynamicOutputFormatBuilder;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.OutputFormatProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

@Internal
public class JdbcDynamicTableSink
implements DynamicTableSink {
    private final JdbcOptions jdbcOptions;
    private final JdbcExecutionOptions executionOptions;
    private final JdbcDmlOptions dmlOptions;
    private final TableSchema tableSchema;
    private final String dialectName;

    public JdbcDynamicTableSink(JdbcOptions jdbcOptions, JdbcExecutionOptions executionOptions, JdbcDmlOptions dmlOptions, TableSchema tableSchema) {
        this.jdbcOptions = jdbcOptions;
        this.executionOptions = executionOptions;
        this.dmlOptions = dmlOptions;
        this.tableSchema = tableSchema;
        this.dialectName = dmlOptions.getDialect().dialectName();
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        this.validatePrimaryKey(requestedMode);
        return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.DELETE).addContainedKind(RowKind.UPDATE_AFTER).build();
    }

    private void validatePrimaryKey(ChangelogMode requestedMode) {
        Preconditions.checkState((ChangelogMode.insertOnly().equals((Object)requestedMode) || this.dmlOptions.getKeyFields().isPresent() ? 1 : 0) != 0, (Object)"please declare primary key for sink table when query contains update/delete record.");
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        TypeInformation rowDataTypeInformation = context.createTypeInformation(this.tableSchema.toRowDataType());
        JdbcDynamicOutputFormatBuilder builder = new JdbcDynamicOutputFormatBuilder();
        builder.setJdbcOptions(this.jdbcOptions);
        builder.setJdbcDmlOptions(this.dmlOptions);
        builder.setJdbcExecutionOptions(this.executionOptions);
        builder.setRowDataTypeInfo((TypeInformation<RowData>)rowDataTypeInformation);
        builder.setFieldDataTypes(this.tableSchema.getFieldDataTypes());
        return OutputFormatProvider.of(builder.build());
    }

    public DynamicTableSink copy() {
        return new JdbcDynamicTableSink(this.jdbcOptions, this.executionOptions, this.dmlOptions, this.tableSchema);
    }

    public String asSummaryString() {
        return "JDBC:" + this.dialectName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JdbcDynamicTableSink)) {
            return false;
        }
        JdbcDynamicTableSink that = (JdbcDynamicTableSink)o;
        return Objects.equals(this.jdbcOptions, that.jdbcOptions) && Objects.equals(this.executionOptions, that.executionOptions) && Objects.equals(this.dmlOptions, that.dmlOptions) && Objects.equals(this.tableSchema, that.tableSchema) && Objects.equals(this.dialectName, that.dialectName);
    }

    public int hashCode() {
        return Objects.hash(this.jdbcOptions, this.executionOptions, this.dmlOptions, this.tableSchema, this.dialectName);
    }
}

