/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal.executor;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.flink.connector.jdbc.internal.converter.JdbcRowConverter;
import org.apache.flink.connector.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.apache.flink.connector.jdbc.statement.FieldNamedPreparedStatement;
import org.apache.flink.connector.jdbc.statement.StatementFactory;
import org.apache.flink.table.data.RowData;
import org.apache.flink.util.Preconditions;

public final class TableSimpleStatementExecutor
implements JdbcBatchStatementExecutor<RowData> {
    private final StatementFactory stmtFactory;
    private final JdbcRowConverter converter;
    private transient FieldNamedPreparedStatement st;

    public TableSimpleStatementExecutor(StatementFactory stmtFactory, JdbcRowConverter converter) {
        this.stmtFactory = (StatementFactory)Preconditions.checkNotNull((Object)stmtFactory);
        this.converter = (JdbcRowConverter)Preconditions.checkNotNull((Object)converter);
    }

    @Override
    public void prepareStatements(Connection connection) throws SQLException {
        this.st = this.stmtFactory.createStatement(connection);
    }

    @Override
    public void addToBatch(RowData record) throws SQLException {
        this.converter.toExternal(record, this.st);
        this.st.addBatch();
    }

    @Override
    public void executeBatch() throws SQLException {
        this.st.executeBatch();
    }

    @Override
    public void closeStatements() throws SQLException {
        if (this.st != null) {
            this.st.close();
            this.st = null;
        }
    }
}

