/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal;

import java.io.Flushable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.jdbc.internal.connection.JdbcConnectionProvider;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcOutputFormat<T>
extends RichOutputFormat<T>
implements Flushable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_FLUSH_MAX_SIZE = 5000;
    public static final long DEFAULT_FLUSH_INTERVAL_MILLS = 0L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJdbcOutputFormat.class);
    protected transient Connection connection;
    protected final JdbcConnectionProvider connectionProvider;

    public AbstractJdbcOutputFormat(JdbcConnectionProvider connectionProvider) {
        this.connectionProvider = (JdbcConnectionProvider)Preconditions.checkNotNull((Object)connectionProvider);
    }

    public void configure(Configuration parameters) {
    }

    public void open(int taskNumber, int numTasks) throws IOException {
        try {
            this.establishConnection();
        }
        catch (Exception e) {
            throw new IOException("unable to open JDBC writer", e);
        }
    }

    protected void establishConnection() throws Exception {
        this.connection = this.connectionProvider.getConnection();
    }

    public void close() {
        this.closeDbConnection();
    }

    private void closeDbConnection() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException se) {
                LOG.warn("JDBC connection could not be closed: " + se.getMessage());
            }
            finally {
                this.connection = null;
            }
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @VisibleForTesting
    public Connection getConnection() {
        return this.connection;
    }
}

