/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.dialect;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.flink.connector.jdbc.dialect.DerbyDialect;
import org.apache.flink.connector.jdbc.dialect.JdbcDialect;
import org.apache.flink.connector.jdbc.dialect.MySQLDialect;
import org.apache.flink.connector.jdbc.dialect.PostgresDialect;

public final class JdbcDialects {
    private static final List<JdbcDialect> DIALECTS = Arrays.asList(new DerbyDialect(), new MySQLDialect(), new PostgresDialect());

    public static Optional<JdbcDialect> get(String url) {
        for (JdbcDialect dialect : DIALECTS) {
            if (!dialect.canHandle(url)) continue;
            return Optional.of(dialect);
        }
        return Optional.empty();
    }
}

