/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.dialect;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.flink.connector.jdbc.dialect.AbstractDialect;
import org.apache.flink.connector.jdbc.internal.converter.DerbyRowConverter;
import org.apache.flink.connector.jdbc.internal.converter.JdbcRowConverter;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;

class DerbyDialect
extends AbstractDialect {
    private static final long serialVersionUID = 1L;
    private static final int MAX_TIMESTAMP_PRECISION = 9;
    private static final int MIN_TIMESTAMP_PRECISION = 1;
    private static final int MAX_DECIMAL_PRECISION = 31;
    private static final int MIN_DECIMAL_PRECISION = 1;

    DerbyDialect() {
    }

    @Override
    public boolean canHandle(String url) {
        return url.startsWith("jdbc:derby:");
    }

    @Override
    public JdbcRowConverter getRowConverter(RowType rowType) {
        return new DerbyRowConverter(rowType);
    }

    @Override
    public Optional<String> defaultDriverName() {
        return Optional.of("org.apache.derby.jdbc.EmbeddedDriver");
    }

    @Override
    public String quoteIdentifier(String identifier) {
        return identifier;
    }

    @Override
    public String dialectName() {
        return "Derby";
    }

    @Override
    public int maxDecimalPrecision() {
        return 31;
    }

    @Override
    public int minDecimalPrecision() {
        return 1;
    }

    @Override
    public int maxTimestampPrecision() {
        return 9;
    }

    @Override
    public int minTimestampPrecision() {
        return 1;
    }

    @Override
    public List<LogicalTypeRoot> unsupportedTypes() {
        return Arrays.asList(LogicalTypeRoot.BINARY, LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE, LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE, LogicalTypeRoot.INTERVAL_YEAR_MONTH, LogicalTypeRoot.INTERVAL_DAY_TIME, LogicalTypeRoot.ARRAY, LogicalTypeRoot.MULTISET, LogicalTypeRoot.MAP, LogicalTypeRoot.ROW, LogicalTypeRoot.DISTINCT_TYPE, LogicalTypeRoot.STRUCTURED_TYPE, LogicalTypeRoot.NULL, LogicalTypeRoot.RAW, LogicalTypeRoot.SYMBOL, LogicalTypeRoot.UNRESOLVED);
    }
}

