/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.catalog.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.connector.jdbc.catalog.JdbcCatalog;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.JdbcCatalogValidator;
import org.apache.flink.table.factories.CatalogFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcCatalogFactory
implements CatalogFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcCatalogFactory.class);

    public Map<String, String> requiredContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("type", "jdbc");
        context.put("property-version", "1");
        return context;
    }

    public List<String> supportedProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("default-database");
        properties.add("base-url");
        properties.add("username");
        properties.add("password");
        return properties;
    }

    public Catalog createCatalog(String name, Map<String, String> properties) {
        DescriptorProperties prop = JdbcCatalogFactory.getValidatedProperties(properties);
        return new JdbcCatalog(name, prop.getString("default-database"), prop.getString("username"), prop.getString("password"), prop.getString("base-url"));
    }

    private static DescriptorProperties getValidatedProperties(Map<String, String> properties) {
        DescriptorProperties descriptorProperties = new DescriptorProperties(true);
        descriptorProperties.putProperties(properties);
        new JdbcCatalogValidator().validate(descriptorProperties);
        return descriptorProperties;
    }
}

