/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc;

import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class JdbcConnectionOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String url;
    protected final String driverName;
    @Nullable
    protected final String username;
    @Nullable
    protected final String password;

    protected JdbcConnectionOptions(String url, String driverName, String username, String password) {
        this.url = (String)Preconditions.checkNotNull((Object)url, (String)"jdbc url is empty");
        this.driverName = (String)Preconditions.checkNotNull((Object)driverName, (String)"driver name is empty");
        this.username = username;
        this.password = password;
    }

    public String getDbURL() {
        return this.url;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    public Optional<String> getPassword() {
        return Optional.ofNullable(this.password);
    }

    public static class JdbcConnectionOptionsBuilder {
        private String url;
        private String driverName;
        private String username;
        private String password;

        public JdbcConnectionOptionsBuilder withUrl(String url) {
            this.url = url;
            return this;
        }

        public JdbcConnectionOptionsBuilder withDriverName(String driverName) {
            this.driverName = driverName;
            return this;
        }

        public JdbcConnectionOptionsBuilder withUsername(String username) {
            this.username = username;
            return this;
        }

        public JdbcConnectionOptionsBuilder withPassword(String password) {
            this.password = password;
            return this;
        }

        public JdbcConnectionOptions build() {
            return new JdbcConnectionOptions(this.url, this.driverName, this.username, this.password);
        }
    }
}

