/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import java.util.ArrayList;
import java.util.HashMap;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserPTFInvocationSpec;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.WindowFunctionInfo;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;

public class HiveParserWindowingSpec {
    private final ArrayList<WindowExpressionSpec> windowExpressions = new ArrayList();
    private final HashMap<String, WindowSpec> windowSpecs = new HashMap();

    public void addWindowSpec(String name, WindowSpec wdwSpec) {
        this.windowSpecs.put(name, wdwSpec);
    }

    public void addWindowFunction(WindowFunctionSpec wFn) {
        this.windowExpressions.add(wFn);
    }

    public ArrayList<WindowExpressionSpec> getWindowExpressions() {
        return this.windowExpressions;
    }

    public HashMap<String, WindowSpec> getWindowSpecs() {
        return this.windowSpecs;
    }

    public void validateAndMakeEffective() throws SemanticException {
        for (WindowExpressionSpec expr : this.getWindowExpressions()) {
            WindowFunctionSpec wFn = (WindowFunctionSpec)expr;
            WindowSpec wdwSpec = wFn.getWindowSpec();
            if (wdwSpec != null) {
                ArrayList<String> sources = new ArrayList<String>();
                this.fillInWindowSpec(wdwSpec.getSourceId(), wdwSpec, sources);
            }
            if (wdwSpec == null) {
                wdwSpec = new WindowSpec();
                wFn.setWindowSpec(wdwSpec);
            }
            this.applyConstantPartition(wdwSpec);
            this.effectiveWindowFrame(wFn);
            this.validateWindowFrame(wdwSpec);
            this.setAndValidateOrderSpec(wFn);
        }
    }

    private void setAndValidateOrderSpec(WindowFunctionSpec wFn) throws SemanticException {
        WindowSpec wdwSpec = wFn.getWindowSpec();
        wdwSpec.ensureOrderSpec(wFn);
        WindowFrameSpec wFrame = wdwSpec.getWindowFrame();
        HiveParserPTFInvocationSpec.OrderSpec order = wdwSpec.getOrder();
        BoundarySpec start = wFrame.getStart();
        BoundarySpec end = wFrame.getEnd();
        if (wFrame.getWindowType() == WindowType.RANGE) {
            boolean multiOrderAllowed;
            if (order == null || order.getExpressions().size() == 0) {
                throw new SemanticException("Range based Window Frame needs to specify ORDER BY clause");
            }
            boolean currentRange = start.getDirection() == WindowingSpec.Direction.CURRENT && end.getDirection() == WindowingSpec.Direction.CURRENT;
            boolean defaultPreceding = start.getDirection() == WindowingSpec.Direction.PRECEDING && start.getAmt() == Integer.MAX_VALUE && end.getDirection() == WindowingSpec.Direction.CURRENT;
            boolean defaultFollowing = start.getDirection() == WindowingSpec.Direction.CURRENT && end.getDirection() == WindowingSpec.Direction.FOLLOWING && end.getAmt() == Integer.MAX_VALUE;
            boolean defaultPrecedingFollowing = start.getDirection() == WindowingSpec.Direction.PRECEDING && start.getAmt() == Integer.MAX_VALUE && end.getDirection() == WindowingSpec.Direction.FOLLOWING && end.getAmt() == Integer.MAX_VALUE;
            boolean bl = multiOrderAllowed = currentRange || defaultPreceding || defaultFollowing || defaultPrecedingFollowing;
            if (order.getExpressions().size() != 1 && !multiOrderAllowed) {
                throw new SemanticException("Range value based Window Frame can have only 1 Sort Key");
            }
        }
    }

    private void validateWindowFrame(WindowSpec wdwSpec) throws SemanticException {
        WindowFrameSpec wFrame = wdwSpec.getWindowFrame();
        BoundarySpec start = wFrame.getStart();
        BoundarySpec end = wFrame.getEnd();
        if (start.getDirection() == WindowingSpec.Direction.FOLLOWING && start.getAmt() == Integer.MAX_VALUE) {
            throw new SemanticException("Start of a WindowFrame cannot be UNBOUNDED FOLLOWING");
        }
        if (end.getDirection() == WindowingSpec.Direction.PRECEDING && end.getAmt() == Integer.MAX_VALUE) {
            throw new SemanticException("End of a WindowFrame cannot be UNBOUNDED PRECEDING");
        }
    }

    private void effectiveWindowFrame(WindowFunctionSpec wFn) throws SemanticException {
        WindowSpec wdwSpec = wFn.getWindowSpec();
        WindowFunctionInfo wFnInfo = FunctionRegistry.getWindowFunctionInfo((String)wFn.getName());
        boolean supportsWindowing = wFnInfo == null || wFnInfo.isSupportsWindow();
        WindowFrameSpec wFrame = wdwSpec.getWindowFrame();
        HiveParserPTFInvocationSpec.OrderSpec orderSpec = wdwSpec.getOrder();
        if (wFrame == null) {
            wFrame = !supportsWindowing ? (wFn.getName().toLowerCase().equals("last_value") && orderSpec != null ? new WindowFrameSpec(WindowType.ROWS, new BoundarySpec(WindowingSpec.Direction.CURRENT), new BoundarySpec(WindowingSpec.Direction.FOLLOWING, 0)) : new WindowFrameSpec(WindowType.ROWS, new BoundarySpec(WindowingSpec.Direction.PRECEDING, Integer.MAX_VALUE), new BoundarySpec(WindowingSpec.Direction.FOLLOWING, Integer.MAX_VALUE))) : (orderSpec == null ? new WindowFrameSpec(WindowType.ROWS, new BoundarySpec(WindowingSpec.Direction.PRECEDING, Integer.MAX_VALUE), new BoundarySpec(WindowingSpec.Direction.FOLLOWING, Integer.MAX_VALUE)) : new WindowFrameSpec(WindowType.RANGE, new BoundarySpec(WindowingSpec.Direction.PRECEDING, Integer.MAX_VALUE), new BoundarySpec(WindowingSpec.Direction.CURRENT)));
            wdwSpec.setWindowFrame(wFrame);
        } else if (wFrame.getEnd() == null) {
            wFrame.setEnd(new BoundarySpec(WindowingSpec.Direction.CURRENT));
        }
    }

    private void applyConstantPartition(WindowSpec wdwSpec) {
        HiveParserPTFInvocationSpec.PartitionSpec partSpec = wdwSpec.getPartition();
        if (partSpec == null) {
            partSpec = new HiveParserPTFInvocationSpec.PartitionSpec();
            HiveParserPTFInvocationSpec.PartitionExpression partExpr = new HiveParserPTFInvocationSpec.PartitionExpression();
            partExpr.setExpression(new HiveParserASTNode((Token)new CommonToken(341, "0")));
            partSpec.addExpression(partExpr);
            wdwSpec.setPartition(partSpec);
        }
    }

    private void fillInWindowSpec(String sourceId, WindowSpec dest, ArrayList<String> visited) throws SemanticException {
        if (sourceId != null) {
            if (visited.contains(sourceId)) {
                visited.add(sourceId);
                throw new SemanticException(String.format("Cycle in Window references %s", visited));
            }
            WindowSpec source = this.getWindowSpecs().get(sourceId);
            if (source == null || source.equals(dest)) {
                throw new SemanticException(String.format("%s refers to an unknown source", dest));
            }
            if (dest.getPartition() == null) {
                dest.setPartition(source.getPartition());
            }
            if (dest.getOrder() == null) {
                dest.setOrder(source.getOrder());
            }
            if (dest.getWindowFrame() == null) {
                dest.setWindowFrame(source.getWindowFrame());
            }
            visited.add(sourceId);
            this.fillInWindowSpec(source.getSourceId(), dest, visited);
        }
    }

    public static class WindowFunctionSpec
    extends WindowExpressionSpec {
        String name;
        boolean isStar;
        boolean isDistinct;
        ArrayList<HiveParserASTNode> args;
        WindowSpec windowSpec;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isStar() {
            return this.isStar;
        }

        public void setStar(boolean isStar) {
            this.isStar = isStar;
        }

        public boolean isDistinct() {
            return this.isDistinct;
        }

        public void setDistinct(boolean isDistinct) {
            this.isDistinct = isDistinct;
        }

        public ArrayList<HiveParserASTNode> getArgs() {
            this.args = this.args == null ? new ArrayList<HiveParserASTNode>() : this.args;
            return this.args;
        }

        public void setArgs(ArrayList<HiveParserASTNode> args) {
            this.args = args;
        }

        public void addArg(HiveParserASTNode arg) {
            this.args = this.args == null ? new ArrayList<HiveParserASTNode>() : this.args;
            this.args.add(arg);
        }

        public WindowSpec getWindowSpec() {
            return this.windowSpec;
        }

        public void setWindowSpec(WindowSpec windowSpec) {
            this.windowSpec = windowSpec;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.name).append("(");
            if (this.isStar) {
                buf.append("*");
            } else {
                if (this.isDistinct) {
                    buf.append("distinct ");
                }
                if (this.args != null) {
                    boolean first = true;
                    for (HiveParserASTNode arg : this.args) {
                        if (first) {
                            first = false;
                        } else {
                            buf.append(", ");
                        }
                        buf.append(arg.toStringTree());
                    }
                }
            }
            buf.append(")");
            if (this.windowSpec != null) {
                buf.append(" ").append(this.windowSpec.toString());
            }
            if (this.alias != null) {
                buf.append(" as ").append(this.alias);
            }
            return buf.toString();
        }
    }

    public static class WindowExpressionSpec {
        String alias;
        HiveParserASTNode expression;

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public HiveParserASTNode getExpression() {
            return this.expression;
        }

        public void setExpression(HiveParserASTNode expression) {
            this.expression = expression;
        }
    }

    public static class WindowFrameSpec {
        private final WindowType windowType;
        private BoundarySpec start;
        private BoundarySpec end;

        public WindowFrameSpec(WindowType windowType, BoundarySpec start, BoundarySpec end) {
            this.windowType = windowType;
            this.start = start;
            this.end = end;
        }

        public BoundarySpec getStart() {
            return this.start;
        }

        public void setStart(BoundarySpec start) {
            this.start = start;
        }

        public BoundarySpec getEnd() {
            return this.end;
        }

        public void setEnd(BoundarySpec end) {
            this.end = end;
        }

        public WindowType getWindowType() {
            return this.windowType;
        }

        public String toString() {
            return String.format("window(type=%s, start=%s, end=%s)", new Object[]{this.windowType, this.start, this.end});
        }
    }

    public static class WindowSpec {
        private String sourceId;
        private HiveParserPTFInvocationSpec.PartitioningSpec partitioning;
        private WindowFrameSpec windowFrame;

        public String getSourceId() {
            return this.sourceId;
        }

        public void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public HiveParserPTFInvocationSpec.PartitioningSpec getPartitioning() {
            return this.partitioning;
        }

        public void setPartitioning(HiveParserPTFInvocationSpec.PartitioningSpec partitioning) {
            this.partitioning = partitioning;
        }

        public WindowFrameSpec getWindowFrame() {
            return this.windowFrame;
        }

        public void setWindowFrame(WindowFrameSpec windowFrame) {
            this.windowFrame = windowFrame;
        }

        public HiveParserPTFInvocationSpec.PartitionSpec getPartition() {
            return this.getPartitioning() == null ? null : this.getPartitioning().getPartSpec();
        }

        public void setPartition(HiveParserPTFInvocationSpec.PartitionSpec partSpec) {
            this.partitioning = this.partitioning == null ? new HiveParserPTFInvocationSpec.PartitioningSpec() : this.partitioning;
            this.partitioning.setPartSpec(partSpec);
        }

        public HiveParserPTFInvocationSpec.OrderSpec getOrder() {
            return this.getPartitioning() == null ? null : this.getPartitioning().getOrderSpec();
        }

        public void setOrder(HiveParserPTFInvocationSpec.OrderSpec orderSpec) {
            this.partitioning = this.partitioning == null ? new HiveParserPTFInvocationSpec.PartitioningSpec() : this.partitioning;
            this.partitioning.setOrderSpec(orderSpec);
        }

        protected void ensureOrderSpec(WindowFunctionSpec wFn) throws SemanticException {
            if (this.getOrder() == null) {
                HiveParserPTFInvocationSpec.OrderSpec order = new HiveParserPTFInvocationSpec.OrderSpec();
                order.prefixBy(this.getPartition());
                this.setOrder(order);
            }
        }

        public String toString() {
            return String.format("Window Spec=[%s%s%s]", this.sourceId == null ? "" : "Name='" + this.sourceId + "'", this.partitioning == null ? "" : this.partitioning, this.windowFrame == null ? "" : this.windowFrame);
        }
    }

    public static class BoundarySpec
    implements Comparable<BoundarySpec> {
        public static final int UNBOUNDED_AMOUNT = Integer.MAX_VALUE;
        WindowingSpec.Direction direction;
        int amt;

        public BoundarySpec() {
        }

        public BoundarySpec(WindowingSpec.Direction direction) {
            this(direction, 0);
        }

        public BoundarySpec(WindowingSpec.Direction direction, int amt) {
            this.direction = direction;
            this.amt = amt;
        }

        public WindowingSpec.Direction getDirection() {
            return this.direction;
        }

        public void setDirection(WindowingSpec.Direction direction) {
            this.direction = direction;
        }

        public int getAmt() {
            return this.amt;
        }

        public void setAmt(int amt) {
            this.amt = amt;
        }

        public String toString() {
            if (this.direction == WindowingSpec.Direction.CURRENT) {
                return "currentRow";
            }
            return String.format("%s %s", this.amt == Integer.MAX_VALUE ? "Unbounded" : Integer.valueOf(this.amt), this.direction);
        }

        @Override
        public int compareTo(BoundarySpec other) {
            int c = this.direction.compareTo((Enum)other.getDirection());
            if (c != 0) {
                return c;
            }
            return this.direction == WindowingSpec.Direction.PRECEDING ? other.amt - this.amt : this.amt - other.amt;
        }
    }

    public static enum WindowType {
        ROWS,
        RANGE;

    }
}

