/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.antlr.runtime.TokenRewriteStream;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserBaseSemanticAnalyzer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;

public class HiveParserUnparseTranslator {
    private final NavigableMap<Integer, Translation> translations;
    private final List<CopyTranslation> copyTranslations;
    private boolean enabled;
    private final Configuration conf;

    public HiveParserUnparseTranslator(Configuration conf) {
        this.conf = conf;
        this.translations = new TreeMap<Integer, Translation>();
        this.copyTranslations = new ArrayList<CopyTranslation>();
    }

    public void enable() {
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void addTranslation(HiveParserASTNode node, String replacementText) {
        if (!this.enabled) {
            return;
        }
        if (node.getOrigin() != null) {
            return;
        }
        int tokenStartIndex = node.getTokenStartIndex();
        int tokenStopIndex = node.getTokenStopIndex();
        if (tokenStopIndex < 0) {
            return;
        }
        Translation translation = new Translation();
        translation.tokenStopIndex = tokenStopIndex;
        translation.replacementText = replacementText;
        assert (tokenStopIndex >= tokenStartIndex);
        ArrayList subsetEntries = new ArrayList();
        for (Map.Entry existingEntry : this.translations.headMap(tokenStopIndex, true).entrySet()) {
            if (((Translation)existingEntry.getValue()).tokenStopIndex <= tokenStopIndex && (Integer)existingEntry.getKey() >= tokenStartIndex) {
                assert (replacementText.contains(((Translation)existingEntry.getValue()).replacementText));
                subsetEntries.add(existingEntry.getKey());
                continue;
            }
            if (((Translation)existingEntry.getValue()).tokenStopIndex < tokenStopIndex || (Integer)existingEntry.getKey() > tokenStartIndex) continue;
            assert (((Translation)existingEntry.getValue()).replacementText.contains(replacementText));
            return;
        }
        for (Integer index : subsetEntries) {
            this.translations.remove(index);
        }
        this.translations.put(tokenStartIndex, translation);
    }

    public void addTableNameTranslation(HiveParserASTNode tableName, String currentDatabaseName) {
        if (!this.enabled) {
            return;
        }
        if (tableName.getToken().getType() == 24) {
            this.addIdentifierTranslation(tableName);
            return;
        }
        assert (tableName.getToken().getType() == 980);
        assert (tableName.getChildCount() <= 2);
        if (tableName.getChildCount() == 2) {
            this.addIdentifierTranslation((HiveParserASTNode)tableName.getChild(0));
            this.addIdentifierTranslation((HiveParserASTNode)tableName.getChild(1));
        } else {
            StringBuilder replacementText = new StringBuilder();
            replacementText.append(HiveUtils.unparseIdentifier((String)currentDatabaseName, (Configuration)this.conf));
            replacementText.append('.');
            HiveParserASTNode identifier = (HiveParserASTNode)tableName.getChild(0);
            String identifierText = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(identifier.getText());
            replacementText.append(HiveUtils.unparseIdentifier((String)identifierText, (Configuration)this.conf));
            this.addTranslation(identifier, replacementText.toString());
        }
    }

    public void addIdentifierTranslation(HiveParserASTNode identifier) {
        if (!this.enabled) {
            return;
        }
        assert (identifier.getToken().getType() == 24);
        String replacementText = identifier.getText();
        replacementText = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(replacementText);
        replacementText = HiveUtils.unparseIdentifier((String)replacementText, (Configuration)this.conf);
        this.addTranslation(identifier, replacementText);
    }

    public void addCopyTranslation(HiveParserASTNode targetNode, HiveParserASTNode sourceNode) {
        if (!this.enabled) {
            return;
        }
        if (targetNode.getOrigin() != null) {
            return;
        }
        CopyTranslation copyTranslation = new CopyTranslation();
        copyTranslation.targetNode = targetNode;
        copyTranslation.sourceNode = sourceNode;
        this.copyTranslations.add(copyTranslation);
    }

    public void applyTranslations(TokenRewriteStream tokenRewriteStream) {
        for (Map.Entry entry : this.translations.entrySet()) {
            if ((Integer)entry.getKey() <= 0) continue;
            tokenRewriteStream.replace(((Integer)entry.getKey()).intValue(), ((Translation)entry.getValue()).tokenStopIndex, (Object)((Translation)entry.getValue()).replacementText);
        }
        for (CopyTranslation copyTranslation : this.copyTranslations) {
            String replacementText = tokenRewriteStream.toString(copyTranslation.sourceNode.getTokenStartIndex(), copyTranslation.sourceNode.getTokenStopIndex());
            String currentText = tokenRewriteStream.toString(copyTranslation.targetNode.getTokenStartIndex(), copyTranslation.targetNode.getTokenStopIndex());
            if (currentText.equals(replacementText)) continue;
            this.addTranslation(copyTranslation.targetNode, replacementText);
            tokenRewriteStream.replace(copyTranslation.targetNode.getTokenStartIndex(), copyTranslation.targetNode.getTokenStopIndex(), (Object)replacementText);
        }
    }

    public void clear() {
        this.translations.clear();
        this.copyTranslations.clear();
        this.enabled = false;
    }

    private static class CopyTranslation {
        HiveParserASTNode targetNode;
        HiveParserASTNode sourceNode;

        private CopyTranslation() {
        }
    }

    private static class Translation {
        int tokenStopIndex;
        String replacementText;

        private Translation() {
        }

        public String toString() {
            return "" + this.tokenStopIndex + " -> " + this.replacementText;
        }
    }
}

