/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import org.apache.flink.table.planner.delegation.hive.copy.HiveParserQB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveParserQBExpr {
    private static final Logger LOG = LoggerFactory.getLogger(HiveParserQBExpr.class);
    private Opcode opcode;
    private HiveParserQBExpr qbexpr1;
    private HiveParserQBExpr qbexpr2;
    private HiveParserQB qb;
    private String alias;

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public HiveParserQBExpr(String alias) {
        this.alias = alias;
    }

    public void setQB(HiveParserQB qb) {
        this.qb = qb;
    }

    public void setOpcode(Opcode opcode) {
        this.opcode = opcode;
    }

    public void setQBExpr1(HiveParserQBExpr qbexpr) {
        this.qbexpr1 = qbexpr;
    }

    public void setQBExpr2(HiveParserQBExpr qbexpr) {
        this.qbexpr2 = qbexpr;
    }

    public HiveParserQB getQB() {
        return this.qb;
    }

    public Opcode getOpcode() {
        return this.opcode;
    }

    public HiveParserQBExpr getQBExpr1() {
        return this.qbexpr1;
    }

    public HiveParserQBExpr getQBExpr2() {
        return this.qbexpr2;
    }

    public void print(String msg) {
        if (this.opcode == Opcode.NULLOP) {
            LOG.info(msg + "start qb = " + this.qb);
            this.qb.print(msg + " ");
            LOG.info(msg + "end qb = " + this.qb);
        } else {
            LOG.info(msg + "start qbexpr1 = " + this.qbexpr1);
            this.qbexpr1.print(msg + " ");
            LOG.info(msg + "end qbexpr1 = " + this.qbexpr1);
            LOG.info(msg + "start qbexpr2 = " + this.qbexpr2);
            this.qbexpr2.print(msg + " ");
            LOG.info(msg + "end qbexpr2 = " + this.qbexpr2);
        }
    }

    public boolean isSimpleSelectQuery() {
        if (this.qb != null) {
            return this.qb.isSimpleSelectQuery();
        }
        return this.qbexpr1.isSimpleSelectQuery() && this.qbexpr2.isSimpleSelectQuery();
    }

    public boolean containsQueryWithoutSourceTable() {
        if (this.qb != null) {
            return this.qb.containsQueryWithoutSourceTable();
        }
        return this.qbexpr1.containsQueryWithoutSourceTable() || this.qbexpr2.containsQueryWithoutSourceTable();
    }

    public static enum Opcode {
        NULLOP,
        UNION,
        INTERSECT,
        INTERSECTALL,
        EXCEPT,
        EXCEPTALL,
        DIFF;

    }
}

