/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserPTFInvocationSpec;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserQBExpr;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserQBParseInfo;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserWindowingSpec;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.QBMetaData;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveParserQB {
    private static final Logger LOG = LoggerFactory.getLogger(HiveParserQB.class);
    private int numSels = 0;
    private int numSelDi = 0;
    private final HashMap<String, String> aliasToTabs;
    private final HashMap<String, HiveParserQBExpr> aliasToSubq;
    private final HashMap<String, Table> viewAliasToViewSchema;
    private final HashMap<String, Map<String, String>> aliasToProps;
    private final List<String> aliases;
    private final HiveParserQBParseInfo qbp;
    private final QBMetaData qbm;
    private final String id;
    private boolean isQuery;
    private boolean insideView;
    private Set<String> aliasInsideView;
    private final Map<String, List<List<String>>> valuesTableToData = new HashMap<String, List<List<String>>>();
    private HashMap<HiveParserASTNode, HiveParserPTFInvocationSpec> ptfNodeToSpec;
    private final HashMap<String, HiveParserWindowingSpec> destToWindowingSpec;
    private int numSubQueryPredicates;

    public void print(String msg) {
        LOG.info(msg + "alias=" + this.qbp.getAlias());
        for (String alias : this.getSubqAliases()) {
            HiveParserQBExpr qbexpr = this.getSubqForAlias(alias);
            LOG.info(msg + "start subquery " + alias);
            qbexpr.print(msg + " ");
            LOG.info(msg + "end subquery " + alias);
        }
    }

    public HiveParserQB(String outerId, String alias, boolean isSubQ) {
        this.aliasToTabs = new LinkedHashMap<String, String>();
        this.aliasToSubq = new LinkedHashMap<String, HiveParserQBExpr>();
        this.viewAliasToViewSchema = new LinkedHashMap<String, Table>();
        this.aliasToProps = new LinkedHashMap<String, Map<String, String>>();
        this.aliases = new ArrayList<String>();
        if (alias != null) {
            alias = alias.toLowerCase();
        }
        this.qbp = new HiveParserQBParseInfo(alias, isSubQ);
        this.qbm = new QBMetaData();
        this.ptfNodeToSpec = new LinkedHashMap<HiveParserASTNode, HiveParserPTFInvocationSpec>();
        this.destToWindowingSpec = new LinkedHashMap<String, HiveParserWindowingSpec>();
        this.id = HiveParserQB.getAppendedAliasFromId(outerId, alias);
        this.aliasInsideView = new HashSet<String>();
    }

    private static String getAppendedAliasFromId(String outerId, String alias) {
        return outerId == null ? alias : outerId + ":" + alias;
    }

    public HiveParserQBParseInfo getParseInfo() {
        return this.qbp;
    }

    public QBMetaData getMetaData() {
        return this.qbm;
    }

    public void countSelDi() {
        ++this.numSelDi;
    }

    public void countSel() {
        ++this.numSels;
    }

    public boolean exists(String alias) {
        return this.aliasToTabs.get(alias = alias.toLowerCase()) != null || this.aliasToSubq.get(alias) != null;
    }

    public void setTabAlias(String alias, String tabName) {
        this.aliasToTabs.put(alias.toLowerCase(), tabName);
    }

    public void setSubqAlias(String alias, HiveParserQBExpr qbexpr) {
        this.aliasToSubq.put(alias.toLowerCase(), qbexpr);
    }

    public void setTabProps(String alias, Map<String, String> props) {
        this.aliasToProps.put(alias.toLowerCase(), props);
    }

    public void addAlias(String alias) {
        if (!this.aliases.contains(alias.toLowerCase())) {
            this.aliases.add(alias.toLowerCase());
        }
    }

    public String getId() {
        return this.id;
    }

    public int getNumSels() {
        return this.numSels;
    }

    public Set<String> getSubqAliases() {
        return this.aliasToSubq.keySet();
    }

    public Set<String> getTabAliases() {
        return this.aliasToTabs.keySet();
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public HiveParserQBExpr getSubqForAlias(String alias) {
        return this.aliasToSubq.get(alias.toLowerCase());
    }

    public String getTabNameForAlias(String alias) {
        return this.aliasToTabs.get(alias.toLowerCase());
    }

    public void rewriteViewToSubq(String alias, String viewName, HiveParserQBExpr qbexpr, Table tab) {
        alias = alias.toLowerCase();
        String tableName = this.aliasToTabs.remove(alias);
        assert (viewName.equals(tableName));
        this.aliasToSubq.put(alias, qbexpr);
        if (tab != null) {
            this.viewAliasToViewSchema.put(alias, tab);
        }
    }

    public void rewriteCTEToSubq(String alias, String cteName, HiveParserQBExpr qbexpr) {
        this.rewriteViewToSubq(alias, cteName, qbexpr, null);
    }

    public void setIsQuery(boolean isQuery) {
        this.isQuery = isQuery;
    }

    public boolean getIsQuery() {
        return this.isQuery;
    }

    public boolean isSimpleSelectQuery() {
        if (!this.qbp.isSimpleSelectQuery() || this.isCTAS() || this.qbp.isAnalyzeCommand()) {
            return false;
        }
        for (HiveParserQBExpr qbexpr : this.aliasToSubq.values()) {
            if (qbexpr.isSimpleSelectQuery()) continue;
            return false;
        }
        return true;
    }

    public CreateTableDesc getTableDesc() {
        return null;
    }

    public void setDirectoryDesc(CreateTableDesc directoryDesc) {
    }

    public boolean isCTAS() {
        return false;
    }

    public List<String> getSkewedColumnNames(String alias) {
        List skewedColNames = null;
        if (null != this.qbm && null != this.qbm.getAliasToTable() && this.qbm.getAliasToTable().size() > 0) {
            Table tbl = this.getMetaData().getTableForAlias(alias);
            skewedColNames = tbl.getSkewedColNames();
        }
        return skewedColNames;
    }

    public HiveParserPTFInvocationSpec getPTFInvocationSpec(HiveParserASTNode node) {
        return this.ptfNodeToSpec == null ? null : this.ptfNodeToSpec.get(node);
    }

    public void addPTFNodeToSpec(HiveParserASTNode node, HiveParserPTFInvocationSpec spec) {
        this.ptfNodeToSpec = this.ptfNodeToSpec == null ? new LinkedHashMap() : this.ptfNodeToSpec;
        this.ptfNodeToSpec.put(node, spec);
    }

    public HiveParserWindowingSpec getWindowingSpec(String dest) {
        return this.destToWindowingSpec.get(dest);
    }

    public void addDestToWindowingSpec(String dest, HiveParserWindowingSpec windowingSpec) {
        this.destToWindowingSpec.put(dest, windowingSpec);
    }

    public boolean hasWindowingSpec(String dest) {
        return this.destToWindowingSpec.get(dest) != null;
    }

    public HashMap<String, HiveParserWindowingSpec> getAllWindowingSpecs() {
        return this.destToWindowingSpec;
    }

    public int incrNumSubQueryPredicates() {
        return ++this.numSubQueryPredicates;
    }

    public HashMap<String, Table> getViewToTabSchema() {
        return this.viewAliasToViewSchema;
    }

    public boolean isInsideView() {
        return this.insideView;
    }

    public void setInsideView(boolean insideView) {
        this.insideView = insideView;
    }

    public Set<String> getAliasInsideView() {
        return this.aliasInsideView;
    }

    public boolean containsQueryWithoutSourceTable() {
        for (HiveParserQBExpr qbexpr : this.aliasToSubq.values()) {
            if (!qbexpr.containsQueryWithoutSourceTable()) continue;
            return true;
        }
        return this.aliasToTabs.size() == 0 && this.aliasToSubq.size() == 0;
    }

    public boolean isMaterializedView() {
        return false;
    }

    public Map<String, List<List<String>>> getValuesTableToData() {
        return this.valuesTableToData;
    }
}

