/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserPlannerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveParserPreCboCtx
extends HiveParserPlannerContext {
    private static final Logger LOG = LoggerFactory.getLogger(HiveParserPreCboCtx.class);
    public HiveParserASTNode nodeOfInterest;
    public Type type = Type.NONE;

    private void set(Type type, HiveParserASTNode ast) {
        if (this.type != Type.NONE) {
            LOG.warn("Setting " + (Object)((Object)type) + " when already " + (Object)((Object)this.type) + "; node " + ast.dump() + " vs old node " + this.nodeOfInterest.dump());
            this.type = Type.UNEXPECTED;
            return;
        }
        this.type = type;
        this.nodeOfInterest = ast;
    }

    @Override
    void setCTASToken(HiveParserASTNode child) {
        this.set(Type.CTAS, child);
    }

    @Override
    void setViewToken(HiveParserASTNode child) {
        this.set(Type.VIEW, child);
    }

    @Override
    void setInsertToken(HiveParserASTNode ast, boolean isTmpFileDest) {
        if (!isTmpFileDest) {
            this.set(Type.INSERT, ast);
        }
    }

    @Override
    void setMultiInsertToken(HiveParserASTNode child) {
        this.set(Type.MULTI_INSERT, child);
    }

    @Override
    void resetToken() {
        this.type = Type.NONE;
        this.nodeOfInterest = null;
    }

    public static enum Type {
        NONE,
        INSERT,
        MULTI_INSERT,
        CTAS,
        VIEW,
        UNEXPECTED;

    }
}

