/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.flink.table.planner.delegation.hive.HiveParserTypeCheckProcFactory;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserBaseSemanticAnalyzer;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserJoinTypeCheckCtx;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserRowResolver;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserTypeCheckCtx;
import org.apache.flink.table.planner.delegation.hive.parse.HiveParserErrorMsg;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;

public class HiveParserJoinCondTypeCheckProcFactory
extends HiveParserTypeCheckProcFactory {
    @Override
    public HiveParserTypeCheckProcFactory.ColumnExprProcessor getColumnExprProcessor() {
        return new JoinCondColumnExprProcessor();
    }

    @Override
    public HiveParserTypeCheckProcFactory.DefaultExprProcessor getDefaultExprProcessor() {
        return new JoinCondDefaultExprProcessor();
    }

    public static class JoinCondDefaultExprProcessor
    extends HiveParserTypeCheckProcFactory.DefaultExprProcessor {
        @Override
        protected List<String> getReferenceableColumnAliases(HiveParserTypeCheckCtx ctx) {
            HiveParserJoinTypeCheckCtx jCtx = (HiveParserJoinTypeCheckCtx)ctx;
            ArrayList<String> possibleColumnNames = new ArrayList<String>();
            for (HiveParserRowResolver rr : jCtx.getInputRRList()) {
                possibleColumnNames.addAll(rr.getReferenceableColumnAliases(null, -1));
            }
            return possibleColumnNames;
        }

        protected ExprNodeColumnDesc processQualifiedColRef(HiveParserTypeCheckCtx ctx, HiveParserASTNode expr, Object ... nodeOutputs) throws SemanticException {
            String tableAlias = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText());
            ColumnInfo colInfo = JoinCondDefaultExprProcessor.getColInfo((HiveParserJoinTypeCheckCtx)ctx, tableAlias, ((ExprNodeConstantDesc)nodeOutputs[1]).getValue().toString(), expr);
            if (colInfo == null) {
                ctx.setError(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_COLUMN, expr.getChild(1)), expr);
                return null;
            }
            return new ExprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), tableAlias, colInfo.getIsVirtualCol());
        }

        private static ColumnInfo getColInfo(HiveParserJoinTypeCheckCtx ctx, String tabName, String colAlias, HiveParserASTNode expr) throws SemanticException {
            ColumnInfo cInfoToRet = null;
            for (HiveParserRowResolver rr : ctx.getInputRRList()) {
                ColumnInfo tmp = rr.get(tabName, colAlias);
                if (tmp == null) continue;
                if (cInfoToRet != null) {
                    throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.AMBIGUOUS_TABLE_OR_COLUMN, expr));
                }
                cInfoToRet = tmp;
            }
            return cInfoToRet;
        }
    }

    public static class JoinCondColumnExprProcessor
    extends HiveParserTypeCheckProcFactory.ColumnExprProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            boolean qualifiedAccess;
            HiveParserASTNode parent;
            HiveParserJoinTypeCheckCtx ctx = (HiveParserJoinTypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            HiveParserASTNode expr = (HiveParserASTNode)nd;
            HiveParserASTNode hiveParserASTNode = parent = stack.size() > 1 ? (HiveParserASTNode)stack.get(stack.size() - 2) : null;
            if (expr.getType() != 977) {
                ctx.setError(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_COLUMN, expr), expr);
                return null;
            }
            assert (expr.getChildCount() == 1);
            String tableOrCol = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText());
            boolean bl = qualifiedAccess = parent != null && parent.getType() == 16;
            if (!qualifiedAccess) {
                ColumnInfo colInfo = JoinCondColumnExprProcessor.getColInfo(ctx, tableOrCol, expr);
                return new ExprNodeColumnDesc(colInfo);
            }
            if (JoinCondColumnExprProcessor.hasTableAlias(ctx, tableOrCol, expr)) {
                return null;
            }
            throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_TABLE_ALIAS, expr));
        }

        private static boolean hasTableAlias(HiveParserJoinTypeCheckCtx ctx, String tabName, HiveParserASTNode expr) throws SemanticException {
            int tblAliasCnt = 0;
            for (HiveParserRowResolver rr : ctx.getInputRRList()) {
                if (!rr.hasTableAlias(tabName)) continue;
                ++tblAliasCnt;
            }
            if (tblAliasCnt > 1) {
                throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.AMBIGUOUS_TABLE_OR_COLUMN, expr));
            }
            return tblAliasCnt == 1;
        }

        private static ColumnInfo getColInfo(HiveParserJoinTypeCheckCtx ctx, String colAlias, HiveParserASTNode expr) throws SemanticException {
            ColumnInfo cInfoToRet = null;
            for (HiveParserRowResolver rr : ctx.getInputRRList()) {
                ColumnInfo tmp = rr.get(null, colAlias);
                if (tmp == null) continue;
                if (cInfoToRet != null) {
                    throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.AMBIGUOUS_TABLE_OR_COLUMN, expr));
                }
                cInfoToRet = tmp;
            }
            return cInfoToRet;
        }
    }
}

