/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNodeOrigin;
import org.apache.hadoop.hive.ql.lib.Node;

public class HiveParserASTNode
extends CommonTree
implements Node,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient StringBuilder astStr;
    private transient HiveParserASTNodeOrigin origin;
    private transient int startIndx = -1;
    private transient int endIndx = -1;
    private transient HiveParserASTNode rootNode;
    private transient boolean isValidASTStr;
    private transient boolean visited = false;

    public HiveParserASTNode() {
    }

    public HiveParserASTNode(Token t) {
        super(t);
    }

    public HiveParserASTNode(HiveParserASTNode node) {
        super((CommonTree)node);
        this.origin = node.origin;
    }

    public Tree dupNode() {
        return new HiveParserASTNode(this);
    }

    public ArrayList<Node> getChildren() {
        if (super.getChildCount() == 0) {
            return null;
        }
        ArrayList<Node> retVec = new ArrayList<Node>();
        for (int i = 0; i < super.getChildCount(); ++i) {
            retVec.add((Node)super.getChild(i));
        }
        return retVec;
    }

    public String getName() {
        return String.valueOf(super.getToken().getType());
    }

    public void setUnknownTokenBoundaries() {
        HiveParserASTNode next;
        ArrayDeque<HiveParserASTNode> stack1 = new ArrayDeque<HiveParserASTNode>();
        ArrayDeque<HiveParserASTNode> stack2 = new ArrayDeque<HiveParserASTNode>();
        stack1.push(this);
        while (!stack1.isEmpty()) {
            next = (HiveParserASTNode)stack1.pop();
            stack2.push(next);
            if (next.children == null) continue;
            for (int i = next.children.size() - 1; i >= 0; --i) {
                stack1.push((HiveParserASTNode)next.children.get(i));
            }
        }
        while (!stack2.isEmpty()) {
            next = (HiveParserASTNode)stack2.pop();
            if (next.children == null) {
                if (next.startIndex >= 0 && next.stopIndex >= 0) continue;
                next.startIndex = next.stopIndex = next.token.getTokenIndex();
                continue;
            }
            if (next.startIndex >= 0 && next.stopIndex >= 0 || next.children.size() <= 0) continue;
            HiveParserASTNode firstChild = (HiveParserASTNode)next.children.get(0);
            HiveParserASTNode lastChild = (HiveParserASTNode)next.children.get(next.children.size() - 1);
            next.startIndex = firstChild.getTokenStartIndex();
            next.stopIndex = lastChild.getTokenStopIndex();
        }
    }

    public HiveParserASTNodeOrigin getOrigin() {
        return this.origin;
    }

    public void setOrigin(HiveParserASTNodeOrigin origin) {
        this.origin = origin;
    }

    public String dump() {
        StringBuilder sb = new StringBuilder("\n");
        this.dump(sb);
        return sb.toString();
    }

    private StringBuilder dump(StringBuilder sb) {
        ArrayDeque<HiveParserASTNode> stack = new ArrayDeque<HiveParserASTNode>();
        stack.push(this);
        int tabLength = 0;
        while (!stack.isEmpty()) {
            HiveParserASTNode next = (HiveParserASTNode)stack.peek();
            if (!next.visited) {
                sb.append(StringUtils.repeat((String)" ", (int)(tabLength * 3)));
                sb.append(next.toString());
                sb.append("\n");
                if (next.children != null) {
                    for (int i = next.children.size() - 1; i >= 0; --i) {
                        stack.push((HiveParserASTNode)next.children.get(i));
                    }
                }
                ++tabLength;
                next.visited = true;
                continue;
            }
            --tabLength;
            next.visited = false;
            stack.pop();
        }
        return sb;
    }

    private void getRootNodeWithValidASTStr() {
        if (this.rootNode != null && this.rootNode.parent == null && this.rootNode.hasValidMemoizedString()) {
            return;
        }
        HiveParserASTNode retNode = this;
        while (retNode.parent != null) {
            retNode = (HiveParserASTNode)retNode.parent;
        }
        this.rootNode = retNode;
        if (!this.rootNode.isValidASTStr) {
            this.rootNode.astStr = new StringBuilder();
            this.rootNode.toStringTree(this.rootNode);
            this.rootNode.isValidASTStr = true;
        }
    }

    private boolean hasValidMemoizedString() {
        return this.isValidASTStr && this.astStr != null;
    }

    private void resetRootInformation() {
        if (this.rootNode != null) {
            this.rootNode.astStr = null;
            this.rootNode.isValidASTStr = false;
        }
    }

    private int getMemoizedStringLen() {
        return this.astStr == null ? 0 : this.astStr.length();
    }

    private String getMemoizedSubString(int start, int end) {
        return this.astStr == null || start < 0 || end > this.astStr.length() || start >= end ? null : this.astStr.subSequence(start, end).toString();
    }

    private void addtoMemoizedString(String string) {
        if (this.astStr == null) {
            this.astStr = new StringBuilder();
        }
        this.astStr.append(string);
    }

    public void setParent(Tree t) {
        super.setParent(t);
        this.resetRootInformation();
    }

    public void addChild(Tree t) {
        super.addChild(t);
        this.resetRootInformation();
    }

    public void addChildren(List kids) {
        super.addChildren(kids);
        this.resetRootInformation();
    }

    public void setChild(int i, Tree t) {
        super.setChild(i, t);
        this.resetRootInformation();
    }

    public void insertChild(int i, Object t) {
        super.insertChild(i, t);
        this.resetRootInformation();
    }

    public Object deleteChild(int i) {
        Object ret = super.deleteChild(i);
        this.resetRootInformation();
        return ret;
    }

    public void replaceChildren(int startChildIndex, int stopChildIndex, Object t) {
        super.replaceChildren(startChildIndex, stopChildIndex, t);
        this.resetRootInformation();
    }

    public String toStringTree() {
        this.getRootNodeWithValidASTStr();
        if (this.startIndx >= 0 && this.endIndx <= this.rootNode.getMemoizedStringLen()) {
            return this.rootNode.getMemoizedSubString(this.startIndx, this.endIndx);
        }
        return this.toStringTree(this.rootNode);
    }

    private String toStringTree(HiveParserASTNode rootNode) {
        ArrayDeque<HiveParserASTNode> stack = new ArrayDeque<HiveParserASTNode>();
        stack.push(this);
        while (!stack.isEmpty()) {
            HiveParserASTNode next = (HiveParserASTNode)stack.peek();
            if (!next.visited) {
                String str;
                if (next.parent != null && next.parent.getChildCount() > 1 && next != next.parent.getChild(0)) {
                    rootNode.addtoMemoizedString(" ");
                }
                next.rootNode = rootNode;
                next.startIndx = rootNode.getMemoizedStringLen();
                if (next.children == null || next.children.size() == 0) {
                    str = next.toString();
                    rootNode.addtoMemoizedString(next.getType() != 353 ? str.toLowerCase() : str);
                    next.endIndx = rootNode.getMemoizedStringLen();
                    stack.pop();
                    continue;
                }
                if (!next.isNil()) {
                    rootNode.addtoMemoizedString("(");
                    str = next.toString();
                    rootNode.addtoMemoizedString(next.getType() == 353 || null == str ? str : str.toLowerCase());
                    rootNode.addtoMemoizedString(" ");
                }
                if (next.children != null) {
                    for (int i = next.children.size() - 1; i >= 0; --i) {
                        stack.push((HiveParserASTNode)next.children.get(i));
                    }
                }
                next.visited = true;
                continue;
            }
            if (!next.isNil()) {
                rootNode.addtoMemoizedString(")");
            }
            next.endIndx = rootNode.getMemoizedStringLen();
            next.visited = false;
            stack.pop();
        }
        return rootNode.getMemoizedSubString(this.startIndx, this.endIndx);
    }
}

