/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive.copy;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.flink.table.planner.delegation.hive.HiveParserTypeCheckProcFactory;
import org.apache.flink.table.planner.delegation.hive.copy.HiveASTParseDriver;
import org.apache.flink.table.planner.delegation.hive.copy.HiveASTParseException;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTBuilder;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserContext;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.hive.ql.exec.PTFUtils;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveASTParseUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HiveASTParseUtils.class);

    private HiveASTParseUtils() {
    }

    public static HiveParserASTNode parse(String command, HiveParserContext ctx) throws HiveASTParseException {
        return HiveASTParseUtils.parse(command, ctx, null);
    }

    public static HiveParserASTNode parse(String command, HiveParserContext ctx, String viewFullyQualifiedName) throws HiveASTParseException {
        HiveASTParseDriver pd = new HiveASTParseDriver();
        HiveParserASTNode tree = pd.parse(command, ctx, viewFullyQualifiedName);
        tree = HiveASTParseUtils.findRootNonNullToken(tree);
        HiveASTParseUtils.handleSetColRefs(tree);
        return tree;
    }

    private static HiveParserASTNode findRootNonNullToken(HiveParserASTNode tree) {
        while (tree.getToken() == null && tree.getChildCount() > 0) {
            tree = (HiveParserASTNode)tree.getChild(0);
        }
        return tree;
    }

    private static void handleSetColRefs(HiveParserASTNode tree) {
        ASTSearcher astSearcher = new ASTSearcher();
        while (true) {
            astSearcher.reset();
            HiveParserASTNode setCols = astSearcher.depthFirstSearch(tree, 910);
            if (setCols == null) break;
            HiveASTParseUtils.processSetColsNode(setCols, astSearcher);
        }
    }

    private static void processSetColsNode(HiveParserASTNode setCols, ASTSearcher searcher) {
        HiveParserASTNode select;
        Tree child;
        Tree fromWhat;
        searcher.reset();
        HiveParserASTNode rootNode = setCols;
        while (rootNode != null && rootNode.getType() != 785) {
            rootNode = rootNode.parent;
        }
        if (rootNode == null || rootNode.parent == null) {
            LOG.debug("Replacing SETCOLREF with ALLCOLREF because we couldn't find the root INSERT");
            setCols.token.setType(652);
            return;
        }
        rootNode = rootNode.parent;
        Tree fromNode = null;
        for (int j = 0; j < rootNode.getChildCount(); ++j) {
            Tree child2 = rootNode.getChild(j);
            if (child2.getType() != 764) continue;
            fromNode = child2;
            break;
        }
        if (!(fromNode instanceof HiveParserASTNode)) {
            LOG.debug("Replacing SETCOLREF with ALLCOLREF because we couldn't find the FROM");
            setCols.token.setType(652);
            return;
        }
        String alias = null;
        if (fromNode.getChildCount() > 0 && (fromWhat = fromNode.getChild(0)).getType() == 945 && fromWhat.getChildCount() > 1 && (child = fromWhat.getChild(fromWhat.getChildCount() - 1)).getType() == 24) {
            alias = child.getText();
        }
        if ((select = searcher.simpleBreadthFirstSearchAny((HiveParserASTNode)fromNode, 903, 904)) == null) {
            LOG.debug("Replacing SETCOLREF with ALLCOLREF because we couldn't find the SELECT");
            setCols.token.setType(652);
            return;
        }
        while (true) {
            CommonTree queryOfSelect = select.parent;
            while (queryOfSelect != null && queryOfSelect.getType() != 880) {
                queryOfSelect = queryOfSelect.parent;
            }
            if (queryOfSelect == null || queryOfSelect.parent == null) {
                LOG.debug("Replacing SETCOLREF with ALLCOLREF because we couldn't find the QUERY");
                setCols.token.setType(652);
                return;
            }
            if (queryOfSelect.childIndex == 0) break;
            Tree moreToTheLeft = queryOfSelect.parent.getChild(0);
            Preconditions.checkState((moreToTheLeft != queryOfSelect ? 1 : 0) != 0);
            HiveParserASTNode newSelect = searcher.simpleBreadthFirstSearchAny((HiveParserASTNode)moreToTheLeft, 903, 904);
            Preconditions.checkState((newSelect != select ? 1 : 0) != 0);
            select = newSelect;
        }
        ArrayList<HiveParserASTNode> newChildren = new ArrayList<HiveParserASTNode>(select.getChildCount());
        HashSet<String> aliases = new HashSet<String>();
        block11: for (int i = 0; i < select.getChildCount(); ++i) {
            Tree selExpr = select.getChild(i);
            assert (selExpr.getType() == 905);
            assert (selExpr.getChildCount() > 0);
            Tree child3 = selExpr.getChild(selExpr.getChildCount() - 1);
            switch (child3.getType()) {
                case 910: {
                    HiveASTParseUtils.processSetColsNode((HiveParserASTNode)child3, searcher);
                    HiveASTParseUtils.processSetColsNode(setCols, searcher);
                    return;
                }
                case 652: {
                    LOG.debug("Replacing SETCOLREF with ALLCOLREF because of nested ALLCOLREF");
                    setCols.token.setType(652);
                    return;
                }
                case 977: {
                    Tree idChild = child3.getChild(0);
                    assert (idChild.getType() == 24) : idChild;
                    if (HiveASTParseUtils.createChildColumnRef(idChild, alias, newChildren, aliases)) continue block11;
                    setCols.token.setType(652);
                    return;
                }
                case 24: {
                    if (HiveASTParseUtils.createChildColumnRef(child3, alias, newChildren, aliases)) continue block11;
                    setCols.token.setType(652);
                    return;
                }
                case 16: {
                    Tree colChild = child3.getChild(child3.getChildCount() - 1);
                    assert (colChild.getType() == 24) : colChild;
                    if (HiveASTParseUtils.createChildColumnRef(colChild, alias, newChildren, aliases)) continue block11;
                    setCols.token.setType(652);
                    return;
                }
                default: {
                    LOG.debug("Replacing SETCOLREF with ALLCOLREF because of the nested node " + child3.getType() + " " + child3.getText());
                    setCols.token.setType(652);
                    return;
                }
            }
        }
        HiveParserASTNode parent = (HiveParserASTNode)setCols.parent.parent;
        int t = parent.getType();
        assert (t == 903 || t == 904) : t;
        int ix = setCols.parent.childIndex;
        parent.deleteChild(ix);
        for (HiveParserASTNode node : newChildren) {
            parent.insertChild(ix++, node);
        }
    }

    private static boolean createChildColumnRef(Tree child, String alias, List<HiveParserASTNode> newChildren, HashSet<String> aliases) {
        String colAlias = child.getText();
        if (!aliases.add(colAlias)) {
            LOG.debug("Replacing SETCOLREF with ALLCOLREF because of duplicate alias " + colAlias);
            return false;
        }
        HiveParserASTBuilder selExpr = HiveParserASTBuilder.construct(905, "TOK_SELEXPR");
        HiveParserASTBuilder toc = HiveParserASTBuilder.construct(977, "TOK_TABLE_OR_COL");
        HiveParserASTBuilder id = HiveParserASTBuilder.construct(24, colAlias);
        if (alias == null) {
            selExpr = selExpr.add(toc.add(id));
        } else {
            HiveParserASTBuilder dot = HiveParserASTBuilder.construct(16, ".");
            HiveParserASTBuilder aliasNode = HiveParserASTBuilder.construct(24, alias);
            selExpr = selExpr.add(dot.add(toc.add(aliasNode)).add(id));
        }
        newChildren.add(selExpr.node());
        return true;
    }

    public static boolean containsTokenOfType(HiveParserASTNode root, Integer ... tokens) {
        final HashSet<Integer> tokensToMatch = new HashSet<Integer>(Arrays.asList(tokens));
        return HiveASTParseUtils.containsTokenOfType(root, new PTFUtils.Predicate<HiveParserASTNode>(){

            public boolean apply(HiveParserASTNode node) {
                return tokensToMatch.contains(node.getType());
            }
        });
    }

    private static boolean containsTokenOfType(HiveParserASTNode root, PTFUtils.Predicate<HiveParserASTNode> predicate) {
        ArrayDeque<HiveParserASTNode> queue = new ArrayDeque<HiveParserASTNode>();
        queue.add(root);
        while (!queue.isEmpty()) {
            HiveParserASTNode current = (HiveParserASTNode)queue.remove();
            if (predicate.apply((Object)current)) {
                return true;
            }
            if (current.getChildCount() <= 0) continue;
            for (Node child : current.getChildren()) {
                queue.add((HiveParserASTNode)child);
            }
        }
        return false;
    }

    public static ExprNodeDesc createConversionCast(ExprNodeDesc column, PrimitiveTypeInfo tableFieldTypeInfo) throws SemanticException {
        String baseType = TypeInfoUtils.getBaseName((String)tableFieldTypeInfo.getTypeName());
        return HiveParserTypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDescWithUdfData(baseType, (TypeInfo)tableFieldTypeInfo, column);
    }

    public static CharTypeInfo getCharTypeInfo(HiveParserASTNode node) throws SemanticException {
        if (node.getChildCount() != 1) {
            throw new SemanticException("Bad params for type char");
        }
        String lengthStr = node.getChild(0).getText();
        return TypeInfoFactory.getCharTypeInfo((int)Integer.parseInt(lengthStr));
    }

    public static VarcharTypeInfo getVarcharTypeInfo(HiveParserASTNode node) throws SemanticException {
        if (node.getChildCount() != 1) {
            throw new SemanticException("Bad params for type varchar");
        }
        String lengthStr = node.getChild(0).getText();
        return TypeInfoFactory.getVarcharTypeInfo((int)Integer.parseInt(lengthStr));
    }

    public static DecimalTypeInfo getDecimalTypeTypeInfo(HiveParserASTNode node) throws SemanticException {
        if (node.getChildCount() > 2) {
            throw new SemanticException("Bad params for type decimal");
        }
        int precision = 10;
        int scale = 0;
        if (node.getChildCount() >= 1) {
            String precStr = node.getChild(0).getText();
            precision = Integer.parseInt(precStr);
        }
        if (node.getChildCount() == 2) {
            String scaleStr = node.getChild(1).getText();
            scale = Integer.parseInt(scaleStr);
        }
        return TypeInfoFactory.getDecimalTypeInfo((int)precision, (int)scale);
    }

    private static class ASTSearcher {
        private final LinkedList<HiveParserASTNode> searchQueue = new LinkedList();

        private ASTSearcher() {
        }

        public HiveParserASTNode depthFirstSearch(HiveParserASTNode ast, int token) {
            this.searchQueue.clear();
            this.searchQueue.add(ast);
            while (!this.searchQueue.isEmpty()) {
                HiveParserASTNode next = this.searchQueue.poll();
                if (next.getType() == token) {
                    return next;
                }
                for (int j = 0; j < next.getChildCount(); ++j) {
                    this.searchQueue.add((HiveParserASTNode)next.getChild(j));
                }
            }
            return null;
        }

        public HiveParserASTNode simpleBreadthFirstSearchAny(HiveParserASTNode ast, int ... tokens) {
            this.searchQueue.clear();
            this.searchQueue.add(ast);
            while (!this.searchQueue.isEmpty()) {
                int i;
                HiveParserASTNode next = this.searchQueue.poll();
                for (i = 0; i < tokens.length; ++i) {
                    if (next.getType() != tokens[i]) continue;
                    return next;
                }
                for (i = 0; i < next.getChildCount(); ++i) {
                    this.searchQueue.add((HiveParserASTNode)next.getChild(i));
                }
            }
            return null;
        }

        public void reset() {
            this.searchQueue.clear();
        }
    }
}

