/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation.hive;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.util.NlsString;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.connectors.hive.FlinkHiveException;
import org.apache.flink.table.catalog.hive.client.HiveShim;
import org.apache.flink.table.planner.delegation.hive.HiveParserRexNodeConverter;
import org.apache.flink.table.planner.delegation.hive.HiveParserUtils;
import org.apache.flink.table.planner.delegation.hive.SqlOperatorExprNodeDesc;
import org.apache.flink.table.planner.delegation.hive.copy.HiveASTParseUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserASTNode;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserBaseSemanticAnalyzer;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserExprNodeColumnListDesc;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserExprNodeDescUtils;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserExprNodeSubQueryDesc;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserExpressionWalker;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserIntervalDayTime;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserIntervalYearMonth;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserRowResolver;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserTypeCheckCtx;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserTypeConverter;
import org.apache.flink.table.planner.delegation.hive.copy.HiveParserTypeInfoUtils;
import org.apache.flink.table.planner.delegation.hive.parse.HiveParserErrorMsg;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.ConstantPropagateProcFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.SettableUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFNvl;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.NullWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveParserTypeCheckProcFactory {
    protected static final Logger LOG = LoggerFactory.getLogger((String)HiveParserTypeCheckProcFactory.class.getName());

    protected HiveParserTypeCheckProcFactory() {
    }

    public static ExprNodeDesc processGByExpr(Node nd, Object procCtx) throws SemanticException {
        HiveParserASTNode expr = (HiveParserASTNode)nd;
        HiveParserTypeCheckCtx ctx = (HiveParserTypeCheckCtx)procCtx;
        if (!ctx.isUseCaching() && ctx.getOuterRR() == null) {
            return null;
        }
        HiveParserRowResolver input = ctx.getInputRR();
        ExprNodeColumnDesc desc = null;
        if (input == null || !ctx.getAllowGBExprElimination()) {
            return null;
        }
        ColumnInfo colInfo = input.getExpression(expr);
        HiveParserRowResolver outerRR = ctx.getOuterRR();
        if (colInfo == null && outerRR != null) {
            colInfo = outerRR.getExpression(expr);
        }
        if (colInfo != null) {
            desc = new ExprNodeColumnDesc(colInfo);
            HiveParserASTNode source = input.getExpressionSource(expr);
            if (source != null) {
                ctx.getUnparseTranslator().addCopyTranslation(expr, source);
            }
            return desc;
        }
        return desc;
    }

    public static Map<HiveParserASTNode, ExprNodeDesc> genExprNode(HiveParserASTNode expr, HiveParserTypeCheckCtx tcCtx) throws SemanticException {
        return HiveParserTypeCheckProcFactory.genExprNode(expr, tcCtx, new HiveParserTypeCheckProcFactory());
    }

    public static Map<HiveParserASTNode, ExprNodeDesc> genExprNode(HiveParserASTNode expr, HiveParserTypeCheckCtx tcCtx, HiveParserTypeCheckProcFactory tf) throws SemanticException {
        LinkedHashMap<RuleRegExp, Object> opRules = new LinkedHashMap<RuleRegExp, Object>();
        opRules.put(new RuleRegExp("R1", "829%"), tf.getNullExprProcessor());
        opRules.put(new RuleRegExp("R2", "341%|25%|342%"), tf.getNumExprProcessor());
        opRules.put(new RuleRegExp("R3", "24%|353%|704%|943%|%|140%|51%|323%|142%|35%|178%|278%|110%|949%"), tf.getStrExprProcessor());
        opRules.put(new RuleRegExp("R4", "295%|117%"), tf.getBoolExprProcessor());
        opRules.put(new RuleRegExp("R5", "726%|988%"), tf.getDateTimeExprProcessor());
        opRules.put(new RuleRegExp("R6", "799%|792%|797%|795%|790%|793%|794%|796%"), tf.getIntervalExprProcessor());
        opRules.put(new RuleRegExp("R7", "977%"), tf.getColumnExprProcessor());
        opRules.put(new RuleRegExp("R8", "946%"), tf.getSubQueryExprProcessor());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher((NodeProcessor)tf.getDefaultExprProcessor(), opRules, (NodeProcessorCtx)tcCtx);
        HiveParserExpressionWalker ogw = new HiveParserExpressionWalker((Dispatcher)disp);
        ArrayList<HiveParserASTNode> topNodes = new ArrayList<HiveParserASTNode>(Collections.singleton(expr));
        LinkedHashMap<Node, Object> nodeOutputs = new LinkedHashMap<Node, Object>();
        ogw.startWalking(topNodes, nodeOutputs);
        return HiveParserTypeCheckProcFactory.convert(nodeOutputs);
    }

    private static Map<HiveParserASTNode, ExprNodeDesc> convert(Map<Node, Object> outputs) {
        LinkedHashMap<HiveParserASTNode, ExprNodeDesc> converted = new LinkedHashMap<HiveParserASTNode, ExprNodeDesc>();
        for (Map.Entry<Node, Object> entry : outputs.entrySet()) {
            if (entry.getKey() instanceof HiveParserASTNode && (entry.getValue() == null || entry.getValue() instanceof ExprNodeDesc)) {
                converted.put((HiveParserASTNode)entry.getKey(), (ExprNodeDesc)entry.getValue());
                continue;
            }
            LOG.warn("Invalid type entry " + entry);
        }
        return converted;
    }

    public NullExprProcessor getNullExprProcessor() {
        return new NullExprProcessor();
    }

    public NumExprProcessor getNumExprProcessor() {
        return new NumExprProcessor();
    }

    public StrExprProcessor getStrExprProcessor() {
        return new StrExprProcessor();
    }

    public BoolExprProcessor getBoolExprProcessor() {
        return new BoolExprProcessor();
    }

    public IntervalExprProcessor getIntervalExprProcessor() {
        return new IntervalExprProcessor();
    }

    public DateTimeExprProcessor getDateTimeExprProcessor() {
        return new DateTimeExprProcessor();
    }

    private static ExprNodeDesc toExprNodeDesc(ColumnInfo colInfo) {
        ObjectInspector inspector = colInfo.getObjectInspector();
        if (inspector instanceof ConstantObjectInspector && inspector instanceof PrimitiveObjectInspector) {
            PrimitiveObjectInspector poi = (PrimitiveObjectInspector)inspector;
            Object constant = ((ConstantObjectInspector)inspector).getWritableConstantValue();
            return new ExprNodeConstantDesc(colInfo.getType(), poi.getPrimitiveJavaObject(constant));
        }
        ExprNodeColumnDesc column = new ExprNodeColumnDesc(colInfo);
        column.setSkewedCol(colInfo.isSkewedCol());
        return column;
    }

    public ColumnExprProcessor getColumnExprProcessor() {
        return new ColumnExprProcessor();
    }

    public DefaultExprProcessor getDefaultExprProcessor() {
        return new DefaultExprProcessor();
    }

    public SubQueryExprProcessor getSubQueryExprProcessor() {
        return new SubQueryExprProcessor();
    }

    public static class SubQueryExprProcessor
    implements NodeProcessor {
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            HiveParserTypeCheckCtx ctx = (HiveParserTypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            HiveParserASTNode expr = (HiveParserASTNode)nd;
            HiveParserASTNode sqNode = (HiveParserASTNode)expr.getParent().getChild(1);
            if (!ctx.getallowSubQueryExpr()) {
                throw new SemanticException(HiveParserUtils.generateErrorMessage(sqNode, ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg("Currently SubQuery expressions are only allowed as Where and Having Clause predicates")));
            }
            ExprNodeDesc desc = HiveParserTypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            assert (((ArrayList)expr.getChildren()).size() == 3 || ((ArrayList)expr.getChildren()).size() == 2);
            assert (expr.getChild(0).getType() == 947);
            HiveParserASTNode subqueryOp = (HiveParserASTNode)expr.getChild(0);
            boolean isIN = subqueryOp.getChildCount() > 0 && (subqueryOp.getChild(0).getType() == 142 || subqueryOp.getChild(0).getType() == 949);
            boolean isEXISTS = subqueryOp.getChildCount() > 0 && (subqueryOp.getChild(0).getType() == 110 || subqueryOp.getChild(0).getType() == 948);
            boolean isScalar = subqueryOp.getChildCount() == 0;
            Map<HiveParserASTNode, RelNode> subqueryToRelNode = ctx.getSubqueryToRelNode();
            if (subqueryToRelNode == null) {
                throw new SemanticException(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(" Currently SubQuery expressions are only allowed as Where and Having Clause predicates"));
            }
            RelNode subqueryRel = subqueryToRelNode.get(expr);
            if (isEXISTS) {
                return new HiveParserExprNodeSubQueryDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, subqueryRel, HiveParserExprNodeSubQueryDesc.SubqueryType.EXISTS);
            }
            if (isIN) {
                assert (nodeOutputs[2] != null);
                ExprNodeDesc lhs = (ExprNodeDesc)nodeOutputs[2];
                return new HiveParserExprNodeSubQueryDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, subqueryRel, HiveParserExprNodeSubQueryDesc.SubqueryType.IN, lhs);
            }
            if (isScalar) {
                if (subqueryRel.getRowType().getFieldCount() != 1) {
                    throw new SemanticException(ErrorMsg.INVALID_SUBQUERY_EXPRESSION.getMsg("More than one column expression in subquery"));
                }
                TypeInfo subExprType = HiveParserTypeConverter.convert(((RelDataTypeField)subqueryRel.getRowType().getFieldList().get(0)).getType());
                return new HiveParserExprNodeSubQueryDesc(subExprType, subqueryRel, HiveParserExprNodeSubQueryDesc.SubqueryType.SCALAR);
            }
            ctx.setError(HiveParserErrorMsg.getMsg(ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION, sqNode, "Currently only IN & EXISTS SubQuery expressions are allowed"), sqNode);
            return null;
        }
    }

    public static class DefaultExprProcessor
    implements NodeProcessor {
        static HashMap<Integer, String> specialUnaryOperatorTextHashMap = new HashMap();
        static HashMap<Integer, String> specialFunctionTextHashMap;
        static HashMap<Integer, String> conversionFunctionTextHashMap;
        static HashSet<Integer> windowingTokens;

        protected static boolean isRedundantConversionFunction(HiveParserASTNode expr, boolean isFunction, ArrayList<ExprNodeDesc> children) {
            if (!isFunction) {
                return false;
            }
            if (children.size() != 1) {
                return false;
            }
            String funcText = conversionFunctionTextHashMap.get(expr.getChild(0).getType());
            if (funcText == null) {
                return false;
            }
            return children.get(0).getTypeInfo().getTypeName().equalsIgnoreCase(funcText);
        }

        public static String getFunctionText(HiveParserASTNode expr, boolean isFunction) {
            String funcText = null;
            if (!isFunction) {
                if (expr.getChildCount() == 1) {
                    funcText = specialUnaryOperatorTextHashMap.get(expr.getType());
                }
                if (funcText == null) {
                    funcText = expr.getText();
                }
            } else {
                assert (expr.getChildCount() >= 1);
                int funcType = expr.getChild(0).getType();
                funcText = specialFunctionTextHashMap.get(funcType);
                if (funcText == null) {
                    funcText = conversionFunctionTextHashMap.get(funcType);
                }
                if (funcText == null) {
                    funcText = expr.getChild(0).getText();
                }
            }
            return HiveParserBaseSemanticAnalyzer.unescapeIdentifier(funcText);
        }

        public static ExprNodeDesc getFuncExprNodeDescWithUdfData(String udfName, TypeInfo typeInfo, ExprNodeDesc ... children) throws UDFArgumentException {
            FunctionInfo fi;
            try {
                fi = HiveParserUtils.getFunctionInfo(udfName);
            }
            catch (SemanticException e) {
                throw new UDFArgumentException((Throwable)e);
            }
            if (fi == null) {
                throw new UDFArgumentException(udfName + " not found.");
            }
            GenericUDF genericUDF = fi.getGenericUDF();
            if (genericUDF == null) {
                throw new UDFArgumentException(udfName + " is an aggregation function or a table function.");
            }
            if (typeInfo != null && genericUDF instanceof SettableUDF) {
                ((SettableUDF)genericUDF).setTypeInfo(typeInfo);
            }
            ArrayList<ExprNodeDesc> childrenList = new ArrayList<ExprNodeDesc>(children.length);
            childrenList.addAll(Arrays.asList(children));
            return ExprNodeGenericFuncDesc.newInstance((GenericUDF)genericUDF, (String)udfName, childrenList);
        }

        protected void validateUDF(HiveParserASTNode expr, boolean isFunction, HiveParserTypeCheckCtx ctx, FunctionInfo fi, GenericUDF genericUDF) throws SemanticException {
            if (fi.getGenericUDTF() != null) {
                throw new SemanticException(ErrorMsg.UDTF_INVALID_LOCATION.getMsg());
            }
            if (fi.getGenericUDAFResolver() != null) {
                if (isFunction) {
                    throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.UDAF_INVALID_LOCATION, expr.getChild(0)));
                }
                throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.UDAF_INVALID_LOCATION, expr));
            }
            if (!ctx.getAllowStatefulFunctions() && genericUDF != null && FunctionRegistry.isStateful((GenericUDF)genericUDF)) {
                throw new SemanticException(ErrorMsg.UDF_STATEFUL_INVALID_LOCATION.getMsg());
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected ExprNodeDesc getXpathOrFuncExprNodeDesc(HiveParserASTNode expr, boolean isFunction, ArrayList<ExprNodeDesc> children, HiveParserTypeCheckCtx ctx) throws SemanticException, UDFArgumentException {
            ExprNodeGenericFuncDesc desc;
            if (DefaultExprProcessor.isRedundantConversionFunction(expr, isFunction, children)) {
                assert (children.size() == 1);
                assert (children.get(0) != null);
                return children.get(0);
            }
            String funcText = DefaultExprProcessor.getFunctionText(expr, isFunction);
            if (funcText.equals(".")) {
                boolean isList;
                assert (children.size() == 2);
                assert (children.get(1) instanceof ExprNodeConstantDesc);
                ExprNodeDesc object = children.get(0);
                ExprNodeConstantDesc fieldName = (ExprNodeConstantDesc)children.get(1);
                assert (fieldName.getValue() instanceof String);
                String fieldNameString = (String)fieldName.getValue();
                TypeInfo objectTypeInfo = object.getTypeInfo();
                boolean bl = isList = object.getTypeInfo().getCategory() == ObjectInspector.Category.LIST;
                if (isList) {
                    objectTypeInfo = ((ListTypeInfo)objectTypeInfo).getListElementTypeInfo();
                }
                if (objectTypeInfo.getCategory() != ObjectInspector.Category.STRUCT) {
                    throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_DOT, expr));
                }
                TypeInfo t = ((StructTypeInfo)objectTypeInfo).getStructFieldTypeInfo(fieldNameString);
                if (isList) {
                    t = TypeInfoFactory.getListTypeInfo((TypeInfo)t);
                }
                desc = new ExprNodeFieldDesc(t, children.get(0), fieldNameString, Boolean.valueOf(isList));
            } else if (funcText.equals("[")) {
                if (!ctx.getallowIndexExpr()) {
                    throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_FUNCTION, expr));
                }
                assert (children.size() == 2);
                TypeInfo myt = children.get(0).getTypeInfo();
                if (myt.getCategory() == ObjectInspector.Category.LIST) {
                    if (!HiveParserTypeInfoUtils.implicitConvertible(children.get(1).getTypeInfo(), (TypeInfo)TypeInfoFactory.intTypeInfo)) {
                        throw new SemanticException(HiveParserUtils.generateErrorMessage(expr, ErrorMsg.INVALID_ARRAYINDEX_TYPE.getMsg()));
                    }
                    TypeInfo t = ((ListTypeInfo)myt).getListElementTypeInfo();
                    desc = new ExprNodeGenericFuncDesc(t, FunctionRegistry.getGenericUDFForIndex(), children);
                } else {
                    if (myt.getCategory() != ObjectInspector.Category.MAP) throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.NON_COLLECTION_TYPE, expr, myt.getTypeName()));
                    if (!HiveParserTypeInfoUtils.implicitConvertible(children.get(1).getTypeInfo(), ((MapTypeInfo)myt).getMapKeyTypeInfo())) {
                        throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_MAPINDEX_TYPE, expr));
                    }
                    TypeInfo t = ((MapTypeInfo)myt).getMapValueTypeInfo();
                    desc = new ExprNodeGenericFuncDesc(t, FunctionRegistry.getGenericUDFForIndex(), children);
                }
            } else {
                ExprNodeDesc constantExpr;
                FunctionInfo fi = HiveParserUtils.getFunctionInfo(funcText);
                if (fi == null) {
                    ExprNodeDesc desc2 = this.convertSqlOperator(funcText, children, ctx);
                    if (desc2 != null) return desc2;
                    if (!isFunction) throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_FUNCTION, expr));
                    throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_FUNCTION, expr.getChild(0)));
                }
                GenericUDF genericUDF = fi.getGenericUDF();
                if (!fi.isNative()) {
                    ctx.getUnparseTranslator().addIdentifierTranslation((HiveParserASTNode)expr.getChild(0));
                }
                if (isFunction) {
                    HiveParserASTNode funcNameNode = (HiveParserASTNode)expr.getChild(0);
                    switch (funcNameNode.getType()) {
                        case 703: {
                            CharTypeInfo charTypeInfo = HiveASTParseUtils.getCharTypeInfo(funcNameNode);
                            if (genericUDF == null) break;
                            ((SettableUDF)genericUDF).setTypeInfo((TypeInfo)charTypeInfo);
                            break;
                        }
                        case 1014: {
                            VarcharTypeInfo varcharTypeInfo = HiveASTParseUtils.getVarcharTypeInfo(funcNameNode);
                            if (genericUDF == null) break;
                            ((SettableUDF)genericUDF).setTypeInfo((TypeInfo)varcharTypeInfo);
                            break;
                        }
                        case 730: {
                            DecimalTypeInfo decTypeInfo = HiveASTParseUtils.getDecimalTypeTypeInfo(funcNameNode);
                            if (genericUDF == null) break;
                            ((SettableUDF)genericUDF).setTypeInfo((TypeInfo)decTypeInfo);
                            break;
                        }
                    }
                }
                this.validateUDF(expr, isFunction, ctx, fi, genericUDF);
                if (genericUDF instanceof GenericUDFBaseCompare && children.size() == 2 && (children.get(0) instanceof ExprNodeConstantDesc && children.get(1) instanceof ExprNodeColumnDesc || children.get(0) instanceof ExprNodeColumnDesc && children.get(1) instanceof ExprNodeConstantDesc)) {
                    PrimitiveTypeInfo colTypeInfo;
                    String constType;
                    int constIdx;
                    block55: {
                        constIdx = children.get(0) instanceof ExprNodeConstantDesc ? 0 : 1;
                        constType = children.get(constIdx).getTypeString().toLowerCase();
                        String columnType = children.get(1 - constIdx).getTypeString().toLowerCase();
                        colTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo((String)columnType);
                        Object constVal = ((ExprNodeConstantDesc)children.get(constIdx)).getValue();
                        try {
                            if (PrimitiveObjectInspectorUtils.intTypeEntry.equals(colTypeInfo.getPrimitiveTypeEntry()) && (constVal instanceof Number || constVal instanceof String)) {
                                children.set(constIdx, (ExprNodeDesc)new ExprNodeConstantDesc((Object)new Integer(constVal.toString())));
                            } else if (PrimitiveObjectInspectorUtils.longTypeEntry.equals(colTypeInfo.getPrimitiveTypeEntry()) && (constVal instanceof Number || constVal instanceof String)) {
                                children.set(constIdx, (ExprNodeDesc)new ExprNodeConstantDesc((Object)new Long(constVal.toString())));
                            } else if (PrimitiveObjectInspectorUtils.doubleTypeEntry.equals(colTypeInfo.getPrimitiveTypeEntry()) && (constVal instanceof Number || constVal instanceof String)) {
                                children.set(constIdx, (ExprNodeDesc)new ExprNodeConstantDesc((Object)new Double(constVal.toString())));
                            } else if (PrimitiveObjectInspectorUtils.floatTypeEntry.equals(colTypeInfo.getPrimitiveTypeEntry()) && (constVal instanceof Number || constVal instanceof String)) {
                                children.set(constIdx, (ExprNodeDesc)new ExprNodeConstantDesc((Object)new Float(constVal.toString())));
                            } else if (PrimitiveObjectInspectorUtils.byteTypeEntry.equals(colTypeInfo.getPrimitiveTypeEntry()) && (constVal instanceof Number || constVal instanceof String)) {
                                children.set(constIdx, (ExprNodeDesc)new ExprNodeConstantDesc((Object)new Byte(constVal.toString())));
                            } else if (PrimitiveObjectInspectorUtils.shortTypeEntry.equals(colTypeInfo.getPrimitiveTypeEntry()) && (constVal instanceof Number || constVal instanceof String)) {
                                children.set(constIdx, (ExprNodeDesc)new ExprNodeConstantDesc((Object)new Short(constVal.toString())));
                            }
                        }
                        catch (NumberFormatException nfe) {
                            LOG.trace("Failed to narrow type of constant", (Throwable)nfe);
                            if (!(genericUDF instanceof GenericUDFOPEqual) || NumberUtils.isNumber((String)constVal.toString())) break block55;
                            return new ExprNodeConstantDesc((Object)false);
                        }
                    }
                    if (constType.equalsIgnoreCase("string") && colTypeInfo instanceof CharTypeInfo) {
                        Object originalValue = ((ExprNodeConstantDesc)children.get(constIdx)).getValue();
                        String constValue = originalValue.toString();
                        int length = TypeInfoUtils.getCharacterLengthForType((PrimitiveTypeInfo)colTypeInfo);
                        HiveChar newValue = new HiveChar(constValue, length);
                        children.set(constIdx, (ExprNodeDesc)new ExprNodeConstantDesc((TypeInfo)colTypeInfo, (Object)newValue));
                    }
                }
                if (genericUDF instanceof GenericUDFOPOr) {
                    ArrayList<ExprNodeDesc> childrenList = new ArrayList<ExprNodeDesc>(children.size());
                    for (ExprNodeDesc child : children) {
                        if (FunctionRegistry.isOpOr((ExprNodeDesc)child)) {
                            childrenList.addAll(child.getChildren());
                            continue;
                        }
                        childrenList.add(child);
                    }
                    desc = ExprNodeGenericFuncDesc.newInstance((GenericUDF)genericUDF, (String)funcText, children);
                } else if (genericUDF instanceof GenericUDFOPAnd) {
                    ArrayList<ExprNodeDesc> childrenList = new ArrayList<ExprNodeDesc>(children.size());
                    for (ExprNodeDesc child : children) {
                        if (FunctionRegistry.isOpAnd((ExprNodeDesc)child)) {
                            childrenList.addAll(child.getChildren());
                            continue;
                        }
                        childrenList.add(child);
                    }
                    desc = ExprNodeGenericFuncDesc.newInstance((GenericUDF)genericUDF, (String)funcText, children);
                } else if (ctx.isFoldExpr() && this.canConvertIntoNvl(genericUDF, children)) {
                    desc = ExprNodeGenericFuncDesc.newInstance((GenericUDF)new GenericUDFNvl(), new ArrayList<ExprNodeDesc>(Arrays.asList(children.get(0), new ExprNodeConstantDesc((Object)false))));
                    if (Boolean.FALSE.equals(((ExprNodeConstantDesc)children.get(1)).getValue())) {
                        desc = ExprNodeGenericFuncDesc.newInstance((GenericUDF)new GenericUDFOPNot(), new ArrayList<ExprNodeGenericFuncDesc>(Collections.singleton(desc)));
                    }
                } else {
                    desc = ExprNodeGenericFuncDesc.newInstance((GenericUDF)genericUDF, (String)funcText, children);
                }
                if (ctx.isFoldExpr() && desc instanceof ExprNodeGenericFuncDesc && FunctionRegistry.isDeterministic((GenericUDF)genericUDF) && HiveParserExprNodeDescUtils.isAllConstants(children) && (constantExpr = ConstantPropagateProcFactory.foldExpr((ExprNodeGenericFuncDesc)desc)) != null) {
                    desc = constantExpr;
                }
            }
            if (FunctionRegistry.isOpPositive((ExprNodeDesc)desc)) {
                assert (desc.getChildren().size() == 1);
                desc = (ExprNodeDesc)desc.getChildren().get(0);
            }
            assert (desc != null);
            return desc;
        }

        private ExprNodeDesc convertSqlOperator(String funcText, List<ExprNodeDesc> children, HiveParserTypeCheckCtx ctx) throws SemanticException {
            SqlOperator sqlOperator = HiveParserUtils.getSqlOperator(funcText, ctx.getSqlOperatorTable(), SqlFunctionCategory.USER_DEFINED_FUNCTION);
            if (sqlOperator == null) {
                return null;
            }
            List<RelDataType> relDataTypes = children.stream().map(ExprNodeDesc::getTypeInfo).map(t -> {
                try {
                    return HiveParserTypeConverter.convert(t, ctx.getTypeFactory());
                }
                catch (SemanticException e) {
                    throw new FlinkHiveException(e);
                }
            }).collect(Collectors.toList());
            ArrayList<RexNode> operands = new ArrayList<RexNode>(children.size());
            for (ExprNodeDesc child : children) {
                if (child instanceof ExprNodeConstantDesc) {
                    operands.add(HiveParserRexNodeConverter.convertConstant((ExprNodeConstantDesc)child, ctx.getCluster()));
                    continue;
                }
                operands.add(null);
            }
            TypeInfo returnType = HiveParserTypeConverter.convert(HiveParserUtils.inferReturnTypeForOperandsTypes(sqlOperator, relDataTypes, operands, ctx.getTypeFactory()));
            return new SqlOperatorExprNodeDesc(funcText, sqlOperator, children, returnType);
        }

        private boolean canConvertIntoNvl(GenericUDF genericUDF, ArrayList<ExprNodeDesc> children) {
            if (genericUDF instanceof GenericUDFWhen && children.size() == 3 && children.get(1) instanceof ExprNodeConstantDesc && children.get(2) instanceof ExprNodeConstantDesc) {
                ExprNodeConstantDesc constThen = (ExprNodeConstantDesc)children.get(1);
                ExprNodeConstantDesc constElse = (ExprNodeConstantDesc)children.get(2);
                Object thenVal = constThen.getValue();
                Object elseVal = constElse.getValue();
                return thenVal instanceof Boolean && elseVal instanceof Boolean;
            }
            return false;
        }

        private boolean isDescendant(Node ans, Node des) {
            if (ans.getChildren() == null) {
                return false;
            }
            for (Node c : ans.getChildren()) {
                if (c == des) {
                    return true;
                }
                if (!this.isDescendant(c, des)) continue;
                return true;
            }
            return false;
        }

        protected ExprNodeDesc processQualifiedColRef(HiveParserTypeCheckCtx ctx, HiveParserASTNode expr, Object ... nodeOutputs) throws SemanticException {
            String colName;
            HiveParserRowResolver input = ctx.getInputRR();
            String tableAlias = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText());
            if (nodeOutputs[1] instanceof ExprNodeConstantDesc) {
                colName = ((ExprNodeConstantDesc)nodeOutputs[1]).getValue().toString();
            } else if (nodeOutputs[1] instanceof ExprNodeColumnDesc) {
                colName = ((ExprNodeColumnDesc)nodeOutputs[1]).getColumn();
            } else {
                throw new SemanticException("Unexpected ExprNode : " + nodeOutputs[1]);
            }
            ColumnInfo colInfo = input.get(tableAlias, colName);
            if (colInfo == null && ctx.getOuterRR() != null) {
                HiveParserRowResolver outerRR = ctx.getOuterRR();
                colInfo = outerRR.get(tableAlias, colName);
            }
            if (colInfo == null) {
                ctx.setError(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_COLUMN, expr.getChild(1)), expr);
                return null;
            }
            return HiveParserTypeCheckProcFactory.toExprNodeDesc(colInfo);
        }

        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            boolean isFunction;
            HiveParserTypeCheckCtx ctx = (HiveParserTypeCheckCtx)procCtx;
            ExprNodeDesc desc = HiveParserTypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                if (this.isDescendant(nd, ctx.getErrorSrcNode())) {
                    ctx.setError(null, null);
                }
                return desc;
            }
            if (ctx.getError() != null) {
                return null;
            }
            HiveParserASTNode expr = (HiveParserASTNode)nd;
            if (windowingTokens.contains(expr.getType())) {
                if (!ctx.getallowWindowing()) {
                    throw new SemanticException(HiveParserUtils.generateErrorMessage(expr, ErrorMsg.INVALID_FUNCTION.getMsg("Windowing is not supported in the context")));
                }
                return null;
            }
            if (expr.getType() == 947 || expr.getType() == 880) {
                return null;
            }
            if (expr.getType() == 980) {
                return null;
            }
            if (expr.getType() == 652) {
                if (!ctx.getallowAllColRef()) {
                    throw new SemanticException(HiveParserUtils.generateErrorMessage(expr, ErrorMsg.INVALID_COLUMN.getMsg("All column reference is not supported in the context")));
                }
                HiveParserRowResolver input = ctx.getInputRR();
                HiveParserExprNodeColumnListDesc columnList = new HiveParserExprNodeColumnListDesc();
                assert (expr.getChildCount() <= 1);
                if (expr.getChildCount() == 1) {
                    HiveParserASTNode child = (HiveParserASTNode)expr.getChild(0);
                    assert (child.getType() == 980);
                    assert (child.getChildCount() == 1);
                    String tableAlias = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText());
                    LinkedHashMap<String, ColumnInfo> columns = input.getFieldMap(tableAlias);
                    if (columns == null) {
                        throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_TABLE_ALIAS, child));
                    }
                    for (Map.Entry colMap : ((HashMap)columns).entrySet()) {
                        ColumnInfo colInfo = (ColumnInfo)colMap.getValue();
                        if (colInfo.getIsVirtualCol()) continue;
                        columnList.addColumn(HiveParserTypeCheckProcFactory.toExprNodeDesc(colInfo));
                    }
                } else {
                    for (ColumnInfo colInfo : input.getColumnInfos()) {
                        if (colInfo.getIsVirtualCol()) continue;
                        columnList.addColumn(HiveParserTypeCheckProcFactory.toExprNodeDesc(colInfo));
                    }
                }
                return columnList;
            }
            if (expr.getType() == 16 && expr.getChild(0).getType() == 977 && nodeOutputs[0] == null) {
                return this.processQualifiedColRef(ctx, expr, nodeOutputs);
            }
            if (conversionFunctionTextHashMap.keySet().contains(expr.getType()) || specialFunctionTextHashMap.keySet().contains(expr.getType()) || expr.getToken().getType() == 12 || expr.getToken().getType() == 11) {
                return null;
            }
            boolean bl = isFunction = expr.getType() == 766 || expr.getType() == 768 || expr.getType() == 767;
            if (!ctx.getAllowDistinctFunctions() && expr.getType() == 767) {
                throw new SemanticException(HiveParserUtils.generateErrorMessage(expr, ErrorMsg.DISTINCT_NOT_SUPPORTED.getMsg()));
            }
            int childrenBegin = isFunction ? 1 : 0;
            ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>(expr.getChildCount() - childrenBegin);
            for (int ci = childrenBegin; ci < expr.getChildCount(); ++ci) {
                if (nodeOutputs[ci] instanceof HiveParserExprNodeColumnListDesc) {
                    children.addAll(((HiveParserExprNodeColumnListDesc)((Object)nodeOutputs[ci])).getChildren());
                    continue;
                }
                children.add((ExprNodeDesc)nodeOutputs[ci]);
            }
            if (expr.getType() == 768) {
                if (!ctx.getallowFunctionStar()) {
                    throw new SemanticException(HiveParserUtils.generateErrorMessage(expr, ErrorMsg.INVALID_COLUMN.getMsg(".* reference is not supported in the context")));
                }
                HiveParserRowResolver input = ctx.getInputRR();
                for (ColumnInfo colInfo : input.getColumnInfos()) {
                    if (colInfo.getIsVirtualCol()) continue;
                    children.add(HiveParserTypeCheckProcFactory.toExprNodeDesc(colInfo));
                }
            }
            if (children.contains(null)) {
                List<String> possibleColumnNames = this.getReferenceableColumnAliases(ctx);
                String reason = String.format("(possible column names are: %s)", StringUtils.join(possibleColumnNames, (String)", "));
                ctx.setError(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_COLUMN, expr.getChild(0), reason), expr);
                return null;
            }
            try {
                return this.getXpathOrFuncExprNodeDesc(expr, isFunction, children, ctx);
            }
            catch (UDFArgumentTypeException e) {
                throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_ARGUMENT_TYPE, expr.getChild(childrenBegin + e.getArgumentId()), e.getMessage()), (Throwable)e);
            }
            catch (UDFArgumentLengthException e) {
                throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_ARGUMENT_LENGTH, expr, e.getMessage()), (Throwable)e);
            }
            catch (UDFArgumentException e) {
                throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_ARGUMENT, expr, e.getMessage()), (Throwable)e);
            }
        }

        protected List<String> getReferenceableColumnAliases(HiveParserTypeCheckCtx ctx) {
            return ctx.getInputRR().getReferenceableColumnAliases(null, -1);
        }

        static {
            specialUnaryOperatorTextHashMap.put(343, "positive");
            specialUnaryOperatorTextHashMap.put(338, "negative");
            specialFunctionTextHashMap = new HashMap();
            specialFunctionTextHashMap.put(801, "isnull");
            specialFunctionTextHashMap.put(800, "isnotnull");
            conversionFunctionTextHashMap = new HashMap();
            conversionFunctionTextHashMap.put(700, "boolean");
            conversionFunctionTextHashMap.put(989, "tinyint");
            conversionFunctionTextHashMap.put(937, "smallint");
            conversionFunctionTextHashMap.put(787, "int");
            conversionFunctionTextHashMap.put(697, "bigint");
            conversionFunctionTextHashMap.put(762, "float");
            conversionFunctionTextHashMap.put(742, "double");
            conversionFunctionTextHashMap.put(942, "string");
            conversionFunctionTextHashMap.put(703, "char");
            conversionFunctionTextHashMap.put(1014, "varchar");
            conversionFunctionTextHashMap.put(698, "binary");
            conversionFunctionTextHashMap.put(725, "date");
            conversionFunctionTextHashMap.put(987, "timestamp");
            conversionFunctionTextHashMap.put(798, "interval_year_month");
            conversionFunctionTextHashMap.put(791, "interval_day_time");
            conversionFunctionTextHashMap.put(730, "decimal");
            windowingTokens = new HashSet();
            windowingTokens.add(208);
            windowingTokens.add(857);
            windowingTokens.add(741);
            windowingTokens.add(938);
            windowingTokens.add(705);
            windowingTokens.add(1021);
            windowingTokens.add(1020);
            windowingTokens.add(1022);
            windowingTokens.add(298);
            windowingTokens.add(217);
            windowingTokens.add(125);
            windowingTokens.add(73);
            windowingTokens.add(982);
            windowingTokens.add(983);
            windowingTokens.add(830);
            windowingTokens.add(831);
        }
    }

    public static class ColumnExprProcessor
    implements NodeProcessor {
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            HiveParserTypeCheckCtx ctx = (HiveParserTypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = HiveParserTypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            HiveParserASTNode expr = (HiveParserASTNode)nd;
            HiveParserASTNode parent = stack.size() > 1 ? (HiveParserASTNode)stack.get(stack.size() - 2) : null;
            HiveParserRowResolver input = ctx.getInputRR();
            if (expr.getType() != 977) {
                ctx.setError(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_COLUMN, expr), expr);
                return null;
            }
            assert (expr.getChildCount() == 1);
            String tableOrCol = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText());
            boolean isTableAlias = input.hasTableAlias(tableOrCol);
            ColumnInfo colInfo = input.get(null, tableOrCol);
            if (ctx.getOuterRR() != null && colInfo == null && !isTableAlias) {
                HiveParserRowResolver outerRR = ctx.getOuterRR();
                isTableAlias = outerRR.hasTableAlias(tableOrCol);
                colInfo = outerRR.get(null, tableOrCol);
            }
            if (isTableAlias) {
                if (colInfo != null) {
                    if (parent != null && parent.getType() == 16) {
                        return null;
                    }
                    return HiveParserTypeCheckProcFactory.toExprNodeDesc(colInfo);
                }
                return null;
            }
            if (colInfo == null) {
                if (input.getIsExprResolver()) {
                    HiveParserASTNode exprNode = expr;
                    if (!stack.empty()) {
                        HiveParserASTNode tmp = (HiveParserASTNode)stack.pop();
                        if (!stack.empty()) {
                            exprNode = (HiveParserASTNode)stack.peek();
                        }
                        stack.push(tmp);
                    }
                    ctx.setError(HiveParserErrorMsg.getMsg(ErrorMsg.NON_KEY_EXPR_IN_GROUPBY, exprNode), expr);
                    return null;
                }
                List<String> possibleColumnNames = input.getReferenceableColumnAliases(tableOrCol, -1);
                String reason = String.format("(possible column names are: %s)", StringUtils.join(possibleColumnNames, (String)", "));
                ctx.setError(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_TABLE_OR_COLUMN, expr.getChild(0), reason), expr);
                LOG.debug(ErrorMsg.INVALID_TABLE_OR_COLUMN.toString() + ":" + input.toString());
                return null;
            }
            return HiveParserTypeCheckProcFactory.toExprNodeDesc(colInfo);
        }
    }

    public static class IntervalExprProcessor
    implements NodeProcessor {
        private static final BigDecimal NANOS_PER_SEC_BD = new BigDecimal(1000000000);
        private final HiveShim hiveShim = HiveParserUtils.getSessionHiveShim();

        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            HiveParserTypeCheckCtx ctx = (HiveParserTypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = HiveParserTypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            HiveParserASTNode expr = (HiveParserASTNode)nd;
            String intervalString = HiveParserBaseSemanticAnalyzer.stripQuotes(expr.getText());
            try {
                switch (expr.getType()) {
                    case 799: {
                        return new ExprNodeConstantDesc((TypeInfo)this.hiveShim.getIntervalYearMonthTypeInfo(), (Object)HiveParserIntervalYearMonth.valueOf(intervalString));
                    }
                    case 792: {
                        return new ExprNodeConstantDesc((TypeInfo)this.hiveShim.getIntervalDayTimeTypeInfo(), (Object)HiveParserIntervalDayTime.valueOf(intervalString));
                    }
                    case 797: {
                        return new ExprNodeConstantDesc((TypeInfo)this.hiveShim.getIntervalYearMonthTypeInfo(), (Object)new HiveParserIntervalYearMonth(Integer.parseInt(intervalString), 0));
                    }
                    case 795: {
                        return new ExprNodeConstantDesc((TypeInfo)this.hiveShim.getIntervalYearMonthTypeInfo(), (Object)new HiveParserIntervalYearMonth(0, Integer.parseInt(intervalString)));
                    }
                    case 790: {
                        return new ExprNodeConstantDesc((TypeInfo)this.hiveShim.getIntervalDayTimeTypeInfo(), (Object)new HiveParserIntervalDayTime(Integer.parseInt(intervalString), 0, 0, 0, 0));
                    }
                    case 793: {
                        return new ExprNodeConstantDesc((TypeInfo)this.hiveShim.getIntervalDayTimeTypeInfo(), (Object)new HiveParserIntervalDayTime(0, Integer.parseInt(intervalString), 0, 0, 0));
                    }
                    case 794: {
                        return new ExprNodeConstantDesc((TypeInfo)this.hiveShim.getIntervalDayTimeTypeInfo(), (Object)new HiveParserIntervalDayTime(0, 0, Integer.parseInt(intervalString), 0, 0));
                    }
                    case 796: {
                        BigDecimal bd = new BigDecimal(intervalString);
                        BigDecimal bdSeconds = new BigDecimal(bd.toBigInteger());
                        BigDecimal bdNanos = bd.subtract(bdSeconds);
                        return new ExprNodeConstantDesc((TypeInfo)this.hiveShim.getIntervalDayTimeTypeInfo(), (Object)new HiveParserIntervalDayTime(0, 0, 0, bdSeconds.intValueExact(), bdNanos.multiply(NANOS_PER_SEC_BD).intValue()));
                    }
                }
                throw new IllegalArgumentException("Invalid time literal type " + expr.getType());
            }
            catch (Exception err) {
                throw new SemanticException("Unable to convert interval literal '" + intervalString + "' to interval value.", (Throwable)err);
            }
        }
    }

    public static class DateTimeExprProcessor
    implements NodeProcessor {
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            HiveParserTypeCheckCtx ctx = (HiveParserTypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = HiveParserTypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            HiveParserASTNode expr = (HiveParserASTNode)nd;
            String timeString = HiveParserBaseSemanticAnalyzer.stripQuotes(expr.getText());
            try {
                if (expr.getType() == 726) {
                    PrimitiveTypeInfo typeInfo = TypeInfoFactory.dateTypeInfo;
                    return new ExprNodeConstantDesc((TypeInfo)typeInfo, HiveParserUtils.getSessionHiveShim().toHiveDate(Date.valueOf(timeString)));
                }
                if (expr.getType() == 988) {
                    return new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.timestampTypeInfo, HiveParserUtils.getSessionHiveShim().toHiveTimestamp(Timestamp.valueOf(timeString)));
                }
                throw new IllegalArgumentException("Invalid time literal type " + expr.getType());
            }
            catch (Exception err) {
                throw new SemanticException("Unable to convert time literal '" + timeString + "' to time value.", (Throwable)err);
            }
        }
    }

    public static class BoolExprProcessor
    implements NodeProcessor {
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            HiveParserTypeCheckCtx ctx = (HiveParserTypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = HiveParserTypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            HiveParserASTNode expr = (HiveParserASTNode)nd;
            Boolean bool = null;
            switch (expr.getToken().getType()) {
                case 295: {
                    bool = Boolean.TRUE;
                    break;
                }
                case 117: {
                    bool = Boolean.FALSE;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (Object)bool);
        }
    }

    public static class StrExprProcessor
    implements NodeProcessor {
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            String str;
            HiveParserTypeCheckCtx ctx = (HiveParserTypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = HiveParserTypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            HiveParserASTNode expr = (HiveParserASTNode)nd;
            switch (expr.getToken().getType()) {
                case 353: {
                    str = HiveParserBaseSemanticAnalyzer.unescapeSQLString(expr.getText());
                    break;
                }
                case 943: {
                    StringBuilder sb = new StringBuilder();
                    for (Node n : expr.getChildren()) {
                        sb.append(HiveParserBaseSemanticAnalyzer.unescapeSQLString(((HiveParserASTNode)n).getText()));
                    }
                    str = sb.toString();
                    break;
                }
                case 704: {
                    Tuple2<String, String> charSetAndVal = HiveParserBaseSemanticAnalyzer.charSetString(expr.getChild(0).getText(), expr.getChild(1).getText());
                    String charSet = (String)charSetAndVal.f0;
                    String text = (String)charSetAndVal.f1;
                    str = new NlsString(text, charSet, SqlCollation.IMPLICIT);
                    break;
                }
                default: {
                    str = HiveParserBaseSemanticAnalyzer.unescapeIdentifier(expr.getText().toLowerCase());
                }
            }
            return new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)str);
        }
    }

    public static class NumExprProcessor
    implements NodeProcessor {
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            HiveParserTypeCheckCtx ctx = (HiveParserTypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = HiveParserTypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            Number v = null;
            ExprNodeConstantDesc decimalNode = null;
            HiveParserASTNode expr = (HiveParserASTNode)nd;
            try {
                if (expr.getText().endsWith("L")) {
                    v = Long.valueOf(expr.getText().substring(0, expr.getText().length() - 1));
                } else if (expr.getText().endsWith("S")) {
                    v = Short.valueOf(expr.getText().substring(0, expr.getText().length() - 1));
                } else if (expr.getText().endsWith("Y")) {
                    v = Byte.valueOf(expr.getText().substring(0, expr.getText().length() - 1));
                } else {
                    if (expr.getText().endsWith("BD")) {
                        String strVal = expr.getText().substring(0, expr.getText().length() - 2);
                        return NumExprProcessor.createDecimal(strVal, false);
                    }
                    if (expr.getText().endsWith("D")) {
                        v = Double.valueOf(expr.getText().substring(0, expr.getText().length() - 1));
                    } else {
                        v = Double.valueOf(expr.getText());
                        if (expr.getText() != null && !expr.getText().toLowerCase().contains("e") && (decimalNode = NumExprProcessor.createDecimal(expr.getText(), true)) != null) {
                            v = null;
                        }
                        v = Long.valueOf(expr.getText());
                        v = Integer.valueOf(expr.getText());
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (v == null && decimalNode == null) {
                throw new SemanticException(HiveParserErrorMsg.getMsg(ErrorMsg.INVALID_NUMERICAL_CONSTANT, expr));
            }
            return v != null ? new ExprNodeConstantDesc(v) : decimalNode;
        }

        public static ExprNodeConstantDesc createDecimal(String strVal, boolean notNull) {
            HiveDecimal hd = HiveDecimal.create((String)strVal);
            if (notNull && hd == null) {
                return null;
            }
            int prec = 1;
            int scale = 0;
            if (hd != null) {
                prec = hd.precision();
                scale = hd.scale();
            }
            DecimalTypeInfo typeInfo = TypeInfoFactory.getDecimalTypeInfo((int)prec, (int)scale);
            return new ExprNodeConstantDesc((TypeInfo)typeInfo, (Object)hd);
        }
    }

    public static class NullExprProcessor
    implements NodeProcessor {
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            HiveParserTypeCheckCtx ctx = (HiveParserTypeCheckCtx)procCtx;
            if (ctx.getError() != null) {
                return null;
            }
            ExprNodeDesc desc = HiveParserTypeCheckProcFactory.processGByExpr(nd, procCtx);
            if (desc != null) {
                return desc;
            }
            return new ExprNodeConstantDesc(TypeInfoFactory.getPrimitiveTypeInfoFromPrimitiveWritable(NullWritable.class), null);
        }
    }
}

