/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc.nohive;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.core.fs.Path;
import org.apache.flink.orc.OrcColumnarRowSplitReader;
import org.apache.flink.orc.OrcFilters;
import org.apache.flink.orc.OrcSplitReaderUtil;
import org.apache.flink.orc.nohive.shim.OrcNoHiveShim;
import org.apache.flink.orc.nohive.vector.AbstractOrcNoHiveVector;
import org.apache.flink.table.data.vector.ColumnVector;
import org.apache.flink.table.data.vector.VectorizedColumnBatch;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.hadoop.conf.Configuration;
import org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;

public class OrcNoHiveSplitReaderUtil {
    public static OrcColumnarRowSplitReader<VectorizedRowBatch> genPartColumnarRowReader(Configuration conf, String[] fullFieldNames, DataType[] fullFieldTypes, Map<String, Object> partitionSpec, int[] selectedFields, List<OrcFilters.Predicate> conjunctPredicates, int batchSize, Path path, long splitStart, long splitLength) throws IOException {
        List<String> nonPartNames = OrcSplitReaderUtil.getNonPartNames(fullFieldNames, partitionSpec);
        int[] selectedOrcFields = OrcSplitReaderUtil.getSelectedOrcFields(fullFieldNames, selectedFields, nonPartNames);
        OrcColumnarRowSplitReader.ColumnBatchGenerator<VectorizedRowBatch> gen = rowBatch -> {
            ColumnVector[] vectors = new ColumnVector[selectedFields.length];
            for (int i = 0; i < vectors.length; ++i) {
                String name = fullFieldNames[selectedFields[i]];
                LogicalType type = fullFieldTypes[selectedFields[i]].getLogicalType();
                vectors[i] = partitionSpec.containsKey(name) ? AbstractOrcNoHiveVector.createFlinkVectorFromConstant(type, partitionSpec.get(name), batchSize) : AbstractOrcNoHiveVector.createFlinkVector(rowBatch.cols[nonPartNames.indexOf(name)]);
            }
            return new VectorizedColumnBatch(vectors);
        };
        return new OrcColumnarRowSplitReader<VectorizedRowBatch>(new OrcNoHiveShim(), conf, OrcSplitReaderUtil.convertToOrcTypeWithPart(fullFieldNames, fullFieldTypes, partitionSpec.keySet()), selectedOrcFields, gen, conjunctPredicates, batchSize, path, splitStart, splitLength);
    }
}

