/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.orc.OrcColumnarRowFileInputFormat;
import org.apache.flink.orc.OrcFilters;
import org.apache.flink.orc.OrcSplitReaderUtil;
import org.apache.flink.orc.shim.OrcShim;
import org.apache.flink.orc.vector.RowDataVectorizer;
import org.apache.flink.orc.writer.OrcBulkWriterFactory;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.BulkDecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.factories.BulkReaderFormatFactory;
import org.apache.flink.table.factories.BulkWriterFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.filesystem.FileSystemOptions;
import org.apache.flink.table.filesystem.PartitionFieldExtractor;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.orc.TypeDescription;

public class OrcFileFormatFactory
implements BulkReaderFormatFactory,
BulkWriterFormatFactory {
    public static final String IDENTIFIER = "orc";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return new HashSet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return new HashSet();
    }

    private static Properties getOrcProperties(ReadableConfig options) {
        Properties orcProperties = new Properties();
        Properties properties = new Properties();
        ((Configuration)options).addAllToProperties(properties);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> orcProperties.put("orc." + k, v)));
        return orcProperties;
    }

    public BulkDecodingFormat<RowData> createDecodingFormat(final DynamicTableFactory.Context context, final ReadableConfig formatOptions) {
        return new BulkDecodingFormat<RowData>(){
            private List<ResolvedExpression> filters;

            public BulkFormat<RowData, FileSourceSplit> createRuntimeDecoder(DynamicTableSource.Context sourceContext, DataType producedDataType) {
                ArrayList<OrcFilters.Predicate> orcPredicates = new ArrayList<OrcFilters.Predicate>();
                if (this.filters != null) {
                    for (Expression expression : this.filters) {
                        OrcFilters.Predicate orcPred = OrcFilters.toOrcPredicate(expression);
                        if (orcPred == null) continue;
                        orcPredicates.add(orcPred);
                    }
                }
                RowType tableType = (RowType)context.getCatalogTable().getSchema().toPhysicalRowDataType().getLogicalType();
                List list = tableType.getFieldNames();
                RowType projectedType = (RowType)producedDataType.getLogicalType();
                int[] selectedFields = projectedType.getFieldNames().stream().mapToInt(list::indexOf).toArray();
                Properties properties = OrcFileFormatFactory.getOrcProperties(formatOptions);
                org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration();
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> conf.set(k.toString(), v.toString())));
                String defaultPartName = (String)context.getCatalogTable().getOptions().getOrDefault(FileSystemOptions.PARTITION_DEFAULT_NAME.key(), FileSystemOptions.PARTITION_DEFAULT_NAME.defaultValue());
                return OrcColumnarRowFileInputFormat.createPartitionedFormat(OrcShim.defaultShim(), conf, tableType, context.getCatalogTable().getPartitionKeys(), PartitionFieldExtractor.forFileSystem((String)defaultPartName), selectedFields, orcPredicates, 2048);
            }

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }

            public void applyFilters(List<ResolvedExpression> filters) {
                this.filters = filters;
            }
        };
    }

    public EncodingFormat<BulkWriter.Factory<RowData>> createEncodingFormat(DynamicTableFactory.Context context, final ReadableConfig formatOptions) {
        return new EncodingFormat<BulkWriter.Factory<RowData>>(){

            public BulkWriter.Factory<RowData> createRuntimeEncoder(DynamicTableSink.Context sinkContext, DataType consumedDataType) {
                RowType formatRowType = (RowType)consumedDataType.getLogicalType();
                LogicalType[] orcTypes = formatRowType.getChildren().toArray(new LogicalType[0]);
                TypeDescription typeDescription = OrcSplitReaderUtil.logicalTypeToOrcType((LogicalType)formatRowType);
                return new OrcBulkWriterFactory<RowData>(new RowDataVectorizer(typeDescription.toString(), orcTypes), OrcFileFormatFactory.getOrcProperties(formatOptions), new org.apache.hadoop.conf.Configuration());
            }

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }
        };
    }
}

