/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.orc;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.function.LongFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.types.Row;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.orc.TypeDescription;

class OrcBatchReader {
    private static final long MILLIS_PER_DAY = 86400000L;
    private static final TimeZone LOCAL_TZ = TimeZone.getDefault();

    OrcBatchReader() {
    }

    static TypeInformation schemaToTypeInfo(TypeDescription schema) {
        switch (schema.getCategory()) {
            case BOOLEAN: {
                return BasicTypeInfo.BOOLEAN_TYPE_INFO;
            }
            case BYTE: {
                return BasicTypeInfo.BYTE_TYPE_INFO;
            }
            case SHORT: {
                return BasicTypeInfo.SHORT_TYPE_INFO;
            }
            case INT: {
                return BasicTypeInfo.INT_TYPE_INFO;
            }
            case LONG: {
                return BasicTypeInfo.LONG_TYPE_INFO;
            }
            case FLOAT: {
                return BasicTypeInfo.FLOAT_TYPE_INFO;
            }
            case DOUBLE: {
                return BasicTypeInfo.DOUBLE_TYPE_INFO;
            }
            case DECIMAL: {
                return BasicTypeInfo.BIG_DEC_TYPE_INFO;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return BasicTypeInfo.STRING_TYPE_INFO;
            }
            case DATE: {
                return SqlTimeTypeInfo.DATE;
            }
            case TIMESTAMP: {
                return SqlTimeTypeInfo.TIMESTAMP;
            }
            case BINARY: {
                return PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO;
            }
            case STRUCT: {
                List fieldSchemas = schema.getChildren();
                TypeInformation[] fieldTypes = new TypeInformation[fieldSchemas.size()];
                for (int i = 0; i < fieldSchemas.size(); ++i) {
                    fieldTypes[i] = OrcBatchReader.schemaToTypeInfo((TypeDescription)fieldSchemas.get(i));
                }
                String[] fieldNames = schema.getFieldNames().toArray(new String[0]);
                return new RowTypeInfo(fieldTypes, fieldNames);
            }
            case LIST: {
                TypeDescription elementSchema = (TypeDescription)schema.getChildren().get(0);
                TypeInformation elementType = OrcBatchReader.schemaToTypeInfo(elementSchema);
                return ObjectArrayTypeInfo.getInfoFor((TypeInformation)elementType);
            }
            case MAP: {
                TypeDescription keySchema = (TypeDescription)schema.getChildren().get(0);
                TypeDescription valSchema = (TypeDescription)schema.getChildren().get(1);
                TypeInformation keyType = OrcBatchReader.schemaToTypeInfo(keySchema);
                TypeInformation valType = OrcBatchReader.schemaToTypeInfo(valSchema);
                return new MapTypeInfo(keyType, valType);
            }
            case UNION: {
                throw new UnsupportedOperationException("UNION type is not supported yet.");
            }
        }
        throw new IllegalArgumentException("Unknown type " + schema);
    }

    static int fillRows(Row[] rows, TypeDescription schema, VectorizedRowBatch batch, int[] selectedFields) {
        int rowsToRead = Math.min((int)batch.count(), rows.length);
        List fieldTypes = schema.getChildren();
        for (int fieldIdx = 0; fieldIdx < selectedFields.length; ++fieldIdx) {
            int orcIdx = selectedFields[fieldIdx];
            OrcBatchReader.readField(rows, fieldIdx, (TypeDescription)fieldTypes.get(orcIdx), batch.cols[orcIdx], rowsToRead);
        }
        return rowsToRead;
    }

    private static void readField(Object[] vals, int fieldIdx, TypeDescription schema, ColumnVector vector, int childCount) {
        switch (schema.getCategory()) {
            case BOOLEAN: {
                if (vector.noNulls) {
                    OrcBatchReader.readNonNullLongColumn(vals, fieldIdx, (LongColumnVector)vector, childCount, OrcBatchReader::readBoolean);
                    break;
                }
                OrcBatchReader.readLongColumn(vals, fieldIdx, (LongColumnVector)vector, childCount, OrcBatchReader::readBoolean);
                break;
            }
            case BYTE: {
                if (vector.noNulls) {
                    OrcBatchReader.readNonNullLongColumn(vals, fieldIdx, (LongColumnVector)vector, childCount, OrcBatchReader::readByte);
                    break;
                }
                OrcBatchReader.readLongColumn(vals, fieldIdx, (LongColumnVector)vector, childCount, OrcBatchReader::readByte);
                break;
            }
            case SHORT: {
                if (vector.noNulls) {
                    OrcBatchReader.readNonNullLongColumn(vals, fieldIdx, (LongColumnVector)vector, childCount, OrcBatchReader::readShort);
                    break;
                }
                OrcBatchReader.readLongColumn(vals, fieldIdx, (LongColumnVector)vector, childCount, OrcBatchReader::readShort);
                break;
            }
            case INT: {
                if (vector.noNulls) {
                    OrcBatchReader.readNonNullLongColumn(vals, fieldIdx, (LongColumnVector)vector, childCount, OrcBatchReader::readInt);
                    break;
                }
                OrcBatchReader.readLongColumn(vals, fieldIdx, (LongColumnVector)vector, childCount, OrcBatchReader::readInt);
                break;
            }
            case LONG: {
                if (vector.noNulls) {
                    OrcBatchReader.readNonNullLongColumn(vals, fieldIdx, (LongColumnVector)vector, childCount, OrcBatchReader::readLong);
                    break;
                }
                OrcBatchReader.readLongColumn(vals, fieldIdx, (LongColumnVector)vector, childCount, OrcBatchReader::readLong);
                break;
            }
            case FLOAT: {
                if (vector.noNulls) {
                    OrcBatchReader.readNonNullDoubleColumn(vals, fieldIdx, (DoubleColumnVector)vector, childCount, OrcBatchReader::readFloat);
                    break;
                }
                OrcBatchReader.readDoubleColumn(vals, fieldIdx, (DoubleColumnVector)vector, childCount, OrcBatchReader::readFloat);
                break;
            }
            case DOUBLE: {
                if (vector.noNulls) {
                    OrcBatchReader.readNonNullDoubleColumn(vals, fieldIdx, (DoubleColumnVector)vector, childCount, OrcBatchReader::readDouble);
                    break;
                }
                OrcBatchReader.readDoubleColumn(vals, fieldIdx, (DoubleColumnVector)vector, childCount, OrcBatchReader::readDouble);
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                if (vector.noNulls) {
                    OrcBatchReader.readNonNullBytesColumnAsString(vals, fieldIdx, (BytesColumnVector)vector, childCount);
                    break;
                }
                OrcBatchReader.readBytesColumnAsString(vals, fieldIdx, (BytesColumnVector)vector, childCount);
                break;
            }
            case DATE: {
                if (vector.noNulls) {
                    OrcBatchReader.readNonNullLongColumnAsDate(vals, fieldIdx, (LongColumnVector)vector, childCount);
                    break;
                }
                OrcBatchReader.readLongColumnAsDate(vals, fieldIdx, (LongColumnVector)vector, childCount);
                break;
            }
            case TIMESTAMP: {
                if (vector.noNulls) {
                    OrcBatchReader.readNonNullTimestampColumn(vals, fieldIdx, (TimestampColumnVector)vector, childCount);
                    break;
                }
                OrcBatchReader.readTimestampColumn(vals, fieldIdx, (TimestampColumnVector)vector, childCount);
                break;
            }
            case BINARY: {
                if (vector.noNulls) {
                    OrcBatchReader.readNonNullBytesColumnAsBinary(vals, fieldIdx, (BytesColumnVector)vector, childCount);
                    break;
                }
                OrcBatchReader.readBytesColumnAsBinary(vals, fieldIdx, (BytesColumnVector)vector, childCount);
                break;
            }
            case DECIMAL: {
                if (vector.noNulls) {
                    OrcBatchReader.readNonNullDecimalColumn(vals, fieldIdx, (DecimalColumnVector)vector, childCount);
                    break;
                }
                OrcBatchReader.readDecimalColumn(vals, fieldIdx, (DecimalColumnVector)vector, childCount);
                break;
            }
            case STRUCT: {
                if (vector.noNulls) {
                    OrcBatchReader.readNonNullStructColumn(vals, fieldIdx, (StructColumnVector)vector, schema, childCount);
                    break;
                }
                OrcBatchReader.readStructColumn(vals, fieldIdx, (StructColumnVector)vector, schema, childCount);
                break;
            }
            case LIST: {
                if (vector.noNulls) {
                    OrcBatchReader.readNonNullListColumn(vals, fieldIdx, (ListColumnVector)vector, schema, childCount);
                    break;
                }
                OrcBatchReader.readListColumn(vals, fieldIdx, (ListColumnVector)vector, schema, childCount);
                break;
            }
            case MAP: {
                if (vector.noNulls) {
                    OrcBatchReader.readNonNullMapColumn(vals, fieldIdx, (MapColumnVector)vector, schema, childCount);
                    break;
                }
                OrcBatchReader.readMapColumn(vals, fieldIdx, (MapColumnVector)vector, schema, childCount);
                break;
            }
            case UNION: {
                throw new UnsupportedOperationException("UNION type not supported yet");
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + schema);
            }
        }
    }

    private static <T> void readNonNullLongColumn(Object[] vals, int fieldIdx, LongColumnVector vector, int childCount, LongFunction<T> reader) {
        if (vector.isRepeating) {
            T repeatingValue = reader.apply(vector.vector[0]);
            OrcBatchReader.fillColumnWithRepeatingValue(vals, fieldIdx, repeatingValue, childCount);
        } else if (fieldIdx == -1) {
            for (int i = 0; i < childCount; ++i) {
                vals[i] = reader.apply(vector.vector[i]);
            }
        } else {
            Row[] rows = (Row[])vals;
            for (int i = 0; i < childCount; ++i) {
                rows[i].setField(fieldIdx, reader.apply(vector.vector[i]));
            }
        }
    }

    private static <T> void readNonNullDoubleColumn(Object[] vals, int fieldIdx, DoubleColumnVector vector, int childCount, DoubleFunction<T> reader) {
        if (vector.isRepeating) {
            T repeatingValue = reader.apply(vector.vector[0]);
            OrcBatchReader.fillColumnWithRepeatingValue(vals, fieldIdx, repeatingValue, childCount);
        } else if (fieldIdx == -1) {
            for (int i = 0; i < childCount; ++i) {
                vals[i] = reader.apply(vector.vector[i]);
            }
        } else {
            Row[] rows = (Row[])vals;
            for (int i = 0; i < childCount; ++i) {
                rows[i].setField(fieldIdx, reader.apply(vector.vector[i]));
            }
        }
    }

    private static void readNonNullBytesColumnAsString(Object[] vals, int fieldIdx, BytesColumnVector bytes, int childCount) {
        if (bytes.isRepeating) {
            String repeatingValue = OrcBatchReader.readString(bytes.vector[0], bytes.start[0], bytes.length[0]);
            OrcBatchReader.fillColumnWithRepeatingValue(vals, fieldIdx, repeatingValue, childCount);
        } else if (fieldIdx == -1) {
            for (int i = 0; i < childCount; ++i) {
                vals[i] = OrcBatchReader.readString(bytes.vector[i], bytes.start[i], bytes.length[i]);
            }
        } else {
            Row[] rows = (Row[])vals;
            for (int i = 0; i < childCount; ++i) {
                rows[i].setField(fieldIdx, (Object)OrcBatchReader.readString(bytes.vector[i], bytes.start[i], bytes.length[i]));
            }
        }
    }

    private static void readNonNullBytesColumnAsBinary(Object[] vals, int fieldIdx, BytesColumnVector bytes, int childCount) {
        if (bytes.isRepeating) {
            if (fieldIdx == -1) {
                for (int i = 0; i < childCount; ++i) {
                    vals[i] = OrcBatchReader.readBinary(bytes.vector[0], bytes.start[0], bytes.length[0]);
                }
            } else {
                Row[] rows = (Row[])vals;
                for (int i = 0; i < childCount; ++i) {
                    rows[i].setField(fieldIdx, (Object)OrcBatchReader.readBinary(bytes.vector[0], bytes.start[0], bytes.length[0]));
                }
            }
        } else if (fieldIdx == -1) {
            for (int i = 0; i < childCount; ++i) {
                vals[i] = OrcBatchReader.readBinary(bytes.vector[i], bytes.start[i], bytes.length[i]);
            }
        } else {
            Row[] rows = (Row[])vals;
            for (int i = 0; i < childCount; ++i) {
                rows[i].setField(fieldIdx, (Object)OrcBatchReader.readBinary(bytes.vector[i], bytes.start[i], bytes.length[i]));
            }
        }
    }

    private static void readNonNullLongColumnAsDate(Object[] vals, int fieldIdx, LongColumnVector vector, int childCount) {
        if (vector.isRepeating) {
            if (fieldIdx == -1) {
                for (int i = 0; i < childCount; ++i) {
                    vals[i] = OrcBatchReader.readDate(vector.vector[0]);
                }
            } else {
                Row[] rows = (Row[])vals;
                for (int i = 0; i < childCount; ++i) {
                    rows[i].setField(fieldIdx, (Object)OrcBatchReader.readDate(vector.vector[0]));
                }
            }
        } else if (fieldIdx == -1) {
            for (int i = 0; i < childCount; ++i) {
                vals[i] = OrcBatchReader.readDate(vector.vector[i]);
            }
        } else {
            Row[] rows = (Row[])vals;
            for (int i = 0; i < childCount; ++i) {
                rows[i].setField(fieldIdx, (Object)OrcBatchReader.readDate(vector.vector[i]));
            }
        }
    }

    private static void readNonNullTimestampColumn(Object[] vals, int fieldIdx, TimestampColumnVector vector, int childCount) {
        if (vector.isRepeating) {
            if (fieldIdx == -1) {
                for (int i = 0; i < childCount; ++i) {
                    vals[i] = OrcBatchReader.readTimestamp(vector.time[0], vector.nanos[0]);
                }
            } else {
                Row[] rows = (Row[])vals;
                for (int i = 0; i < childCount; ++i) {
                    rows[i].setField(fieldIdx, (Object)OrcBatchReader.readTimestamp(vector.time[0], vector.nanos[0]));
                }
            }
        } else if (fieldIdx == -1) {
            for (int i = 0; i < childCount; ++i) {
                vals[i] = OrcBatchReader.readTimestamp(vector.time[i], vector.nanos[i]);
            }
        } else {
            Row[] rows = (Row[])vals;
            for (int i = 0; i < childCount; ++i) {
                rows[i].setField(fieldIdx, (Object)OrcBatchReader.readTimestamp(vector.time[i], vector.nanos[i]));
            }
        }
    }

    private static void readNonNullDecimalColumn(Object[] vals, int fieldIdx, DecimalColumnVector vector, int childCount) {
        if (vector.isRepeating) {
            OrcBatchReader.fillColumnWithRepeatingValue(vals, fieldIdx, OrcBatchReader.readBigDecimal(vector.vector[0]), childCount);
        } else if (fieldIdx == -1) {
            for (int i = 0; i < childCount; ++i) {
                vals[i] = OrcBatchReader.readBigDecimal(vector.vector[i]);
            }
        } else {
            Row[] rows = (Row[])vals;
            for (int i = 0; i < childCount; ++i) {
                rows[i].setField(fieldIdx, (Object)OrcBatchReader.readBigDecimal(vector.vector[i]));
            }
        }
    }

    private static void readNonNullStructColumn(Object[] vals, int fieldIdx, StructColumnVector structVector, TypeDescription schema, int childCount) {
        int i;
        List childrenTypes = schema.getChildren();
        int numFields = childrenTypes.size();
        Object[] structs = new Row[childCount];
        for (i = 0; i < childCount; ++i) {
            structs[i] = new Row(numFields);
        }
        for (i = 0; i < numFields; ++i) {
            OrcBatchReader.readField(structs, i, (TypeDescription)childrenTypes.get(i), structVector.fields[i], childCount);
        }
        if (fieldIdx == -1) {
            System.arraycopy(structs, 0, vals, 0, childCount);
        } else {
            Row[] rows = (Row[])vals;
            for (int i2 = 0; i2 < childCount; ++i2) {
                rows[i2].setField(fieldIdx, structs[i2]);
            }
        }
    }

    private static void readNonNullListColumn(Object[] vals, int fieldIdx, ListColumnVector list, TypeDescription schema, int childCount) {
        TypeDescription fieldType = (TypeDescription)schema.getChildren().get(0);
        Class<?> classType = OrcBatchReader.getClassForType(fieldType);
        if (list.isRepeating) {
            Object[] first;
            int offset = (int)list.offsets[0];
            int length = (int)list.lengths[0];
            int entriesToRead = offset + length;
            Object[] children = (Object[])Array.newInstance(classType, entriesToRead);
            OrcBatchReader.readField(children, -1, fieldType, list.child, entriesToRead);
            Function<Object, Object> copyList = OrcBatchReader.getCopyFunction(schema);
            if (offset == 0) {
                first = children;
            } else {
                first = (Object[])Array.newInstance(classType, length);
                System.arraycopy(children, offset, first, 0, length);
            }
            for (int i = 0; i < childCount; ++i) {
                Object[] copy = (Object[])copyList.apply(first);
                if (fieldIdx == -1) {
                    vals[i] = copy;
                    continue;
                }
                ((Row)vals[i]).setField(fieldIdx, (Object)copy);
            }
        } else {
            Object[] children = (Object[])Array.newInstance(classType, list.childCount);
            OrcBatchReader.readField(children, -1, fieldType, list.child, list.childCount);
            for (int i = 0; i < childCount; ++i) {
                int offset = (int)list.offsets[i];
                int length = (int)list.lengths[i];
                Object[] temp = (Object[])Array.newInstance(classType, length);
                System.arraycopy(children, offset, temp, 0, length);
                if (fieldIdx == -1) {
                    vals[i] = temp;
                    continue;
                }
                ((Row)vals[i]).setField(fieldIdx, (Object)temp);
            }
        }
    }

    private static void readNonNullMapColumn(Object[] vals, int fieldIdx, MapColumnVector mapsVector, TypeDescription schema, int childCount) {
        List fieldType = schema.getChildren();
        TypeDescription keyType = (TypeDescription)fieldType.get(0);
        TypeDescription valueType = (TypeDescription)fieldType.get(1);
        ColumnVector keys = mapsVector.keys;
        ColumnVector values = mapsVector.values;
        if (mapsVector.isRepeating) {
            Function<Object, Object> copyMap = OrcBatchReader.getCopyFunction(schema);
            int offset = (int)mapsVector.offsets[0];
            int length = (int)mapsVector.lengths[0];
            int entriesToRead = offset + length;
            Object[] keyRows = new Object[entriesToRead];
            Object[] valueRows = new Object[entriesToRead];
            OrcBatchReader.readField(keyRows, -1, keyType, keys, entriesToRead);
            OrcBatchReader.readField(valueRows, -1, valueType, values, entriesToRead);
            HashMap map = OrcBatchReader.readHashMap(keyRows, valueRows, offset, length);
            for (int i = 0; i < childCount; ++i) {
                if (fieldIdx == -1) {
                    vals[i] = copyMap.apply(map);
                    continue;
                }
                ((Row)vals[i]).setField(fieldIdx, copyMap.apply(map));
            }
        } else {
            Object[] keyRows = new Object[mapsVector.childCount];
            Object[] valueRows = new Object[mapsVector.childCount];
            OrcBatchReader.readField(keyRows, -1, keyType, keys, keyRows.length);
            OrcBatchReader.readField(valueRows, -1, valueType, values, valueRows.length);
            long[] lengthVectorMap = mapsVector.lengths;
            int offset = 0;
            for (int i = 0; i < childCount; ++i) {
                long numMapEntries = lengthVectorMap[i];
                HashMap map = OrcBatchReader.readHashMap(keyRows, valueRows, offset, numMapEntries);
                offset = (int)((long)offset + numMapEntries);
                if (fieldIdx == -1) {
                    vals[i] = map;
                    continue;
                }
                ((Row)vals[i]).setField(fieldIdx, (Object)map);
            }
        }
    }

    private static <T> void readLongColumn(Object[] vals, int fieldIdx, LongColumnVector vector, int childCount, LongFunction<T> reader) {
        if (vector.isRepeating) {
            if (vector.isNull[0]) {
                OrcBatchReader.fillColumnWithRepeatingValue(vals, fieldIdx, null, childCount);
            } else {
                OrcBatchReader.readNonNullLongColumn(vals, fieldIdx, vector, childCount, reader);
            }
        } else {
            boolean[] isNullVector = vector.isNull;
            if (fieldIdx == -1) {
                for (int i = 0; i < childCount; ++i) {
                    vals[i] = isNullVector[i] ? null : reader.apply(vector.vector[i]);
                }
            } else {
                Row[] rows = (Row[])vals;
                for (int i = 0; i < childCount; ++i) {
                    if (isNullVector[i]) {
                        rows[i].setField(fieldIdx, null);
                        continue;
                    }
                    rows[i].setField(fieldIdx, reader.apply(vector.vector[i]));
                }
            }
        }
    }

    private static <T> void readDoubleColumn(Object[] vals, int fieldIdx, DoubleColumnVector vector, int childCount, DoubleFunction<T> reader) {
        if (vector.isRepeating) {
            if (vector.isNull[0]) {
                OrcBatchReader.fillColumnWithRepeatingValue(vals, fieldIdx, null, childCount);
            } else {
                OrcBatchReader.readNonNullDoubleColumn(vals, fieldIdx, vector, childCount, reader);
            }
        } else {
            boolean[] isNullVector = vector.isNull;
            if (fieldIdx == -1) {
                for (int i = 0; i < childCount; ++i) {
                    vals[i] = isNullVector[i] ? null : reader.apply(vector.vector[i]);
                }
            } else {
                Row[] rows = (Row[])vals;
                for (int i = 0; i < childCount; ++i) {
                    if (isNullVector[i]) {
                        rows[i].setField(fieldIdx, null);
                        continue;
                    }
                    rows[i].setField(fieldIdx, reader.apply(vector.vector[i]));
                }
            }
        }
    }

    private static void readBytesColumnAsString(Object[] vals, int fieldIdx, BytesColumnVector bytes, int childCount) {
        if (bytes.isRepeating) {
            if (bytes.isNull[0]) {
                OrcBatchReader.fillColumnWithRepeatingValue(vals, fieldIdx, null, childCount);
            } else {
                OrcBatchReader.readNonNullBytesColumnAsString(vals, fieldIdx, bytes, childCount);
            }
        } else {
            boolean[] isNullVector = bytes.isNull;
            if (fieldIdx == -1) {
                for (int i = 0; i < childCount; ++i) {
                    vals[i] = isNullVector[i] ? null : OrcBatchReader.readString(bytes.vector[i], bytes.start[i], bytes.length[i]);
                }
            } else {
                Row[] rows = (Row[])vals;
                for (int i = 0; i < childCount; ++i) {
                    if (isNullVector[i]) {
                        rows[i].setField(fieldIdx, null);
                        continue;
                    }
                    rows[i].setField(fieldIdx, (Object)OrcBatchReader.readString(bytes.vector[i], bytes.start[i], bytes.length[i]));
                }
            }
        }
    }

    private static void readBytesColumnAsBinary(Object[] vals, int fieldIdx, BytesColumnVector bytes, int childCount) {
        if (bytes.isRepeating) {
            if (bytes.isNull[0]) {
                OrcBatchReader.fillColumnWithRepeatingValue(vals, fieldIdx, null, childCount);
            } else {
                OrcBatchReader.readNonNullBytesColumnAsBinary(vals, fieldIdx, bytes, childCount);
            }
        } else {
            boolean[] isNullVector = bytes.isNull;
            if (fieldIdx == -1) {
                for (int i = 0; i < childCount; ++i) {
                    vals[i] = isNullVector[i] ? null : (Object)OrcBatchReader.readBinary(bytes.vector[i], bytes.start[i], bytes.length[i]);
                }
            } else {
                Row[] rows = (Row[])vals;
                for (int i = 0; i < childCount; ++i) {
                    if (isNullVector[i]) {
                        rows[i].setField(fieldIdx, null);
                        continue;
                    }
                    rows[i].setField(fieldIdx, (Object)OrcBatchReader.readBinary(bytes.vector[i], bytes.start[i], bytes.length[i]));
                }
            }
        }
    }

    private static void readLongColumnAsDate(Object[] vals, int fieldIdx, LongColumnVector vector, int childCount) {
        if (vector.isRepeating) {
            if (vector.isNull[0]) {
                OrcBatchReader.fillColumnWithRepeatingValue(vals, fieldIdx, null, childCount);
            } else {
                OrcBatchReader.readNonNullLongColumnAsDate(vals, fieldIdx, vector, childCount);
            }
        } else {
            boolean[] isNullVector = vector.isNull;
            if (fieldIdx == -1) {
                for (int i = 0; i < childCount; ++i) {
                    vals[i] = isNullVector[i] ? null : OrcBatchReader.readDate(vector.vector[i]);
                }
            } else {
                Row[] rows = (Row[])vals;
                for (int i = 0; i < childCount; ++i) {
                    if (isNullVector[i]) {
                        rows[i].setField(fieldIdx, null);
                        continue;
                    }
                    rows[i].setField(fieldIdx, (Object)OrcBatchReader.readDate(vector.vector[i]));
                }
            }
        }
    }

    private static void readTimestampColumn(Object[] vals, int fieldIdx, TimestampColumnVector vector, int childCount) {
        if (vector.isRepeating) {
            if (vector.isNull[0]) {
                OrcBatchReader.fillColumnWithRepeatingValue(vals, fieldIdx, null, childCount);
            } else {
                OrcBatchReader.readNonNullTimestampColumn(vals, fieldIdx, vector, childCount);
            }
        } else {
            boolean[] isNullVector = vector.isNull;
            if (fieldIdx == -1) {
                for (int i = 0; i < childCount; ++i) {
                    if (isNullVector[i]) {
                        vals[i] = null;
                        continue;
                    }
                    Timestamp ts = OrcBatchReader.readTimestamp(vector.time[i], vector.nanos[i]);
                    vals[i] = ts;
                }
            } else {
                Row[] rows = (Row[])vals;
                for (int i = 0; i < childCount; ++i) {
                    if (isNullVector[i]) {
                        rows[i].setField(fieldIdx, null);
                        continue;
                    }
                    Timestamp ts = OrcBatchReader.readTimestamp(vector.time[i], vector.nanos[i]);
                    rows[i].setField(fieldIdx, (Object)ts);
                }
            }
        }
    }

    private static void readDecimalColumn(Object[] vals, int fieldIdx, DecimalColumnVector vector, int childCount) {
        if (vector.isRepeating) {
            if (vector.isNull[0]) {
                OrcBatchReader.fillColumnWithRepeatingValue(vals, fieldIdx, null, childCount);
            } else {
                OrcBatchReader.readNonNullDecimalColumn(vals, fieldIdx, vector, childCount);
            }
        } else {
            boolean[] isNullVector = vector.isNull;
            if (fieldIdx == -1) {
                for (int i = 0; i < childCount; ++i) {
                    vals[i] = isNullVector[i] ? null : OrcBatchReader.readBigDecimal(vector.vector[i]);
                }
            } else {
                Row[] rows = (Row[])vals;
                for (int i = 0; i < childCount; ++i) {
                    if (isNullVector[i]) {
                        rows[i].setField(fieldIdx, null);
                        continue;
                    }
                    rows[i].setField(fieldIdx, (Object)OrcBatchReader.readBigDecimal(vector.vector[i]));
                }
            }
        }
    }

    private static void readStructColumn(Object[] vals, int fieldIdx, StructColumnVector structVector, TypeDescription schema, int childCount) {
        int i;
        List childrenTypes = schema.getChildren();
        int numFields = childrenTypes.size();
        if (structVector.isRepeating && structVector.isNull[0]) {
            if (fieldIdx < 0) {
                for (int i2 = 0; i2 < childCount; ++i2) {
                    vals[i2] = null;
                }
            } else {
                for (int i3 = 0; i3 < childCount; ++i3) {
                    ((Row)vals[i3]).setField(fieldIdx, null);
                }
            }
            return;
        }
        Object[] structs = new Row[childCount];
        for (i = 0; i < childCount; ++i) {
            structs[i] = new Row(numFields);
        }
        for (i = 0; i < numFields; ++i) {
            ColumnVector fieldVector = structVector.fields[i];
            if (!fieldVector.isRepeating) {
                if (fieldVector.noNulls) {
                    System.arraycopy(structVector.isNull, 0, fieldVector.isNull, 0, structVector.isNull.length);
                    structVector.fields[i].noNulls = false;
                } else {
                    for (int j = 0; j < structVector.isNull.length; ++j) {
                        structVector.fields[i].isNull[j] = structVector.isNull[j] || structVector.fields[i].isNull[j];
                    }
                }
            }
            OrcBatchReader.readField(structs, i, (TypeDescription)childrenTypes.get(i), structVector.fields[i], childCount);
        }
        boolean[] isNullVector = structVector.isNull;
        if (fieldIdx == -1) {
            for (int i4 = 0; i4 < childCount; ++i4) {
                vals[i4] = isNullVector[i4] ? null : structs[i4];
            }
        } else {
            Row[] rows = (Row[])vals;
            for (int i5 = 0; i5 < childCount; ++i5) {
                if (isNullVector[i5]) {
                    rows[i5].setField(fieldIdx, null);
                    continue;
                }
                rows[i5].setField(fieldIdx, structs[i5]);
            }
        }
    }

    private static void readListColumn(Object[] vals, int fieldIdx, ListColumnVector list, TypeDescription schema, int childCount) {
        TypeDescription fieldType = (TypeDescription)schema.getChildren().get(0);
        Class<?> classType = OrcBatchReader.getClassForType(fieldType);
        if (list.isRepeating) {
            if (list.isNull[0]) {
                for (int i = 0; i < childCount; ++i) {
                    if (fieldIdx == -1) {
                        vals[i] = null;
                        continue;
                    }
                    ((Row)vals[i]).setField(fieldIdx, null);
                }
            } else {
                Object[] temp;
                Function<Object, Object> copyList = OrcBatchReader.getCopyFunction(schema);
                int offset = (int)list.offsets[0];
                int length = (int)list.lengths[0];
                int entriesToRead = offset + length;
                Object[] children = (Object[])Array.newInstance(classType, entriesToRead);
                OrcBatchReader.readField(children, -1, fieldType, list.child, entriesToRead);
                if (offset == 0) {
                    temp = children;
                } else {
                    temp = (Object[])Array.newInstance(classType, length);
                    System.arraycopy(children, offset, temp, 0, length);
                }
                for (int i = 0; i < childCount; ++i) {
                    Object[] copy = (Object[])copyList.apply(temp);
                    if (fieldIdx == -1) {
                        vals[i] = copy;
                        continue;
                    }
                    ((Row)vals[i]).setField(fieldIdx, (Object)copy);
                }
            }
        } else {
            if (!list.child.isRepeating) {
                boolean[] childIsNull = new boolean[list.childCount];
                Arrays.fill(childIsNull, true);
                for (int i = 0; i < childCount; ++i) {
                    if (list.isNull[i]) continue;
                    int offset = (int)list.offsets[i];
                    int length = (int)list.lengths[i];
                    System.arraycopy(list.child.isNull, offset, childIsNull, offset, length);
                }
                list.child.isNull = childIsNull;
                list.child.noNulls = false;
            }
            Object[] children = (Object[])Array.newInstance(classType, list.childCount);
            OrcBatchReader.readField(children, -1, fieldType, list.child, list.childCount);
            for (int i = 0; i < childCount; ++i) {
                Object[] temp;
                if (list.isNull[i]) {
                    temp = null;
                } else {
                    int offset = (int)list.offsets[i];
                    int length = (int)list.lengths[i];
                    temp = (Object[])Array.newInstance(classType, length);
                    System.arraycopy(children, offset, temp, 0, length);
                }
                if (fieldIdx == -1) {
                    vals[i] = temp;
                    continue;
                }
                ((Row)vals[i]).setField(fieldIdx, temp);
            }
        }
    }

    private static void readMapColumn(Object[] vals, int fieldIdx, MapColumnVector map, TypeDescription schema, int childCount) {
        List fieldType = schema.getChildren();
        TypeDescription keyType = (TypeDescription)fieldType.get(0);
        TypeDescription valueType = (TypeDescription)fieldType.get(1);
        ColumnVector keys = map.keys;
        ColumnVector values = map.values;
        if (map.isRepeating) {
            if (map.isNull[0]) {
                for (int i = 0; i < childCount; ++i) {
                    if (fieldIdx == -1) {
                        vals[i] = null;
                        continue;
                    }
                    ((Row)vals[i]).setField(fieldIdx, null);
                }
            } else {
                Function<Object, Object> copyMap = OrcBatchReader.getCopyFunction(schema);
                int offset = (int)map.offsets[0];
                int length = (int)map.lengths[0];
                int entriesToRead = offset + length;
                Object[] keyRows = new Object[entriesToRead];
                Object[] valueRows = new Object[entriesToRead];
                OrcBatchReader.readField(keyRows, -1, keyType, keys, entriesToRead);
                OrcBatchReader.readField(valueRows, -1, valueType, values, entriesToRead);
                HashMap temp = OrcBatchReader.readHashMap(keyRows, valueRows, offset, length);
                for (int i = 0; i < childCount; ++i) {
                    if (fieldIdx == -1) {
                        vals[i] = copyMap.apply(temp);
                        continue;
                    }
                    ((Row)vals[i]).setField(fieldIdx, copyMap.apply(temp));
                }
            }
        } else {
            int length;
            int offset;
            int i;
            if (!keys.isRepeating) {
                boolean[] keyIsNull = new boolean[map.childCount];
                Arrays.fill(keyIsNull, true);
                for (i = 0; i < childCount; ++i) {
                    if (map.isNull[i]) continue;
                    offset = (int)map.offsets[i];
                    length = (int)map.lengths[i];
                    System.arraycopy(keys.isNull, offset, keyIsNull, offset, length);
                }
                keys.isNull = keyIsNull;
                keys.noNulls = false;
            }
            if (!values.isRepeating) {
                boolean[] valIsNull = new boolean[map.childCount];
                Arrays.fill(valIsNull, true);
                for (i = 0; i < childCount; ++i) {
                    if (map.isNull[i]) continue;
                    offset = (int)map.offsets[i];
                    length = (int)map.lengths[i];
                    System.arraycopy(values.isNull, offset, valIsNull, offset, length);
                }
                values.isNull = valIsNull;
                values.noNulls = false;
            }
            Object[] keyRows = new Object[map.childCount];
            Object[] valueRows = new Object[map.childCount];
            OrcBatchReader.readField(keyRows, -1, keyType, keys, keyRows.length);
            OrcBatchReader.readField(valueRows, -1, valueType, values, valueRows.length);
            boolean[] isNullVector = map.isNull;
            long[] lengths = map.lengths;
            long[] offsets = map.offsets;
            if (fieldIdx == -1) {
                for (int i2 = 0; i2 < childCount; ++i2) {
                    vals[i2] = isNullVector[i2] ? null : OrcBatchReader.readHashMap(keyRows, valueRows, (int)offsets[i2], lengths[i2]);
                }
            } else {
                Row[] rows = (Row[])vals;
                for (int i3 = 0; i3 < childCount; ++i3) {
                    if (isNullVector[i3]) {
                        rows[i3].setField(fieldIdx, null);
                        continue;
                    }
                    rows[i3].setField(fieldIdx, (Object)OrcBatchReader.readHashMap(keyRows, valueRows, (int)offsets[i3], lengths[i3]));
                }
            }
        }
    }

    private static void fillColumnWithRepeatingValue(Object[] vals, int fieldIdx, Object repeatingValue, int childCount) {
        if (fieldIdx == -1) {
            Arrays.fill(vals, 0, childCount, repeatingValue);
        } else {
            Row[] rows = (Row[])vals;
            for (int i = 0; i < childCount; ++i) {
                rows[i].setField(fieldIdx, repeatingValue);
            }
        }
    }

    private static Class<?> getClassForType(TypeDescription schema) {
        switch (schema.getCategory()) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case BYTE: {
                return Byte.class;
            }
            case SHORT: {
                return Short.class;
            }
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return String.class;
            }
            case DATE: {
                return Date.class;
            }
            case TIMESTAMP: {
                return Timestamp.class;
            }
            case BINARY: {
                return byte[].class;
            }
            case DECIMAL: {
                return BigDecimal.class;
            }
            case STRUCT: {
                return Row.class;
            }
            case LIST: {
                Class<?> childClass = OrcBatchReader.getClassForType((TypeDescription)schema.getChildren().get(0));
                return Array.newInstance(childClass, 0).getClass();
            }
            case MAP: {
                return HashMap.class;
            }
            case UNION: {
                throw new UnsupportedOperationException("UNION type not supported yet");
            }
        }
        throw new IllegalArgumentException("Unknown type " + schema);
    }

    private static Boolean readBoolean(long l) {
        return l != 0L;
    }

    private static Byte readByte(long l) {
        return (byte)l;
    }

    private static Short readShort(long l) {
        return (short)l;
    }

    private static Integer readInt(long l) {
        return (int)l;
    }

    private static Long readLong(long l) {
        return l;
    }

    private static Float readFloat(double d) {
        return Float.valueOf((float)d);
    }

    private static Double readDouble(double d) {
        return d;
    }

    private static Date readDate(long l) {
        long t = l * 86400000L;
        return new Date(t - (long)LOCAL_TZ.getOffset(t));
    }

    private static String readString(byte[] bytes, int start, int length) {
        return new String(bytes, start, length, StandardCharsets.UTF_8);
    }

    private static byte[] readBinary(byte[] src, int srcPos, int length) {
        byte[] result = new byte[length];
        System.arraycopy(src, srcPos, result, 0, length);
        return result;
    }

    private static BigDecimal readBigDecimal(HiveDecimalWritable hiveDecimalWritable) {
        HiveDecimal hiveDecimal = hiveDecimalWritable.getHiveDecimal();
        return hiveDecimal.bigDecimalValue();
    }

    private static Timestamp readTimestamp(long time, int nanos) {
        Timestamp ts = new Timestamp(time);
        ts.setNanos(nanos);
        return ts;
    }

    private static HashMap readHashMap(Object[] keyRows, Object[] valueRows, int offset, long length) {
        HashMap<Object, Object> resultMap = new HashMap<Object, Object>();
        int j = 0;
        while ((long)j < length) {
            resultMap.put(keyRows[offset], valueRows[offset]);
            ++offset;
            ++j;
        }
        return resultMap;
    }

    private static Function<Object, Object> getCopyFunction(TypeDescription schema) {
        switch (schema.getCategory()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return OrcBatchReader::returnImmutable;
            }
            case DATE: {
                return OrcBatchReader::copyDate;
            }
            case TIMESTAMP: {
                return OrcBatchReader::copyTimestamp;
            }
            case BINARY: {
                return OrcBatchReader::copyBinary;
            }
            case STRUCT: {
                List fieldTypes = schema.getChildren();
                Function[] copyFields = new Function[fieldTypes.size()];
                for (int i = 0; i < fieldTypes.size(); ++i) {
                    copyFields[i] = OrcBatchReader.getCopyFunction((TypeDescription)fieldTypes.get(i));
                }
                return new CopyStruct(copyFields);
            }
            case LIST: {
                TypeDescription entryType = (TypeDescription)schema.getChildren().get(0);
                Function<Object, Object> copyEntry = OrcBatchReader.getCopyFunction(entryType);
                Class<?> entryClass = OrcBatchReader.getClassForType(entryType);
                return new CopyList(copyEntry, entryClass);
            }
            case MAP: {
                TypeDescription keyType = (TypeDescription)schema.getChildren().get(0);
                TypeDescription valueType = (TypeDescription)schema.getChildren().get(1);
                Function<Object, Object> copyKey = OrcBatchReader.getCopyFunction(keyType);
                Function<Object, Object> copyValue = OrcBatchReader.getCopyFunction(valueType);
                return new CopyMap(copyKey, copyValue);
            }
            case UNION: {
                throw new UnsupportedOperationException("UNION type not supported yet");
            }
        }
        throw new IllegalArgumentException("Unknown type " + schema);
    }

    private static Object returnImmutable(Object o) {
        return o;
    }

    private static Date copyDate(Object o) {
        if (o == null) {
            return null;
        }
        long date = ((Date)o).getTime();
        return new Date(date);
    }

    private static Timestamp copyTimestamp(Object o) {
        if (o == null) {
            return null;
        }
        long millis = ((Timestamp)o).getTime();
        int nanos = ((Timestamp)o).getNanos();
        Timestamp copy = new Timestamp(millis);
        copy.setNanos(nanos);
        return copy;
    }

    private static byte[] copyBinary(Object o) {
        if (o == null) {
            return null;
        }
        int length = ((byte[])o).length;
        return Arrays.copyOf((byte[])o, length);
    }

    private static class CopyMap
    implements Function<Object, Object> {
        private final Function<Object, Object> copyKey;
        private final Function<Object, Object> copyValue;

        CopyMap(Function<Object, Object> copyKey, Function<Object, Object> copyValue) {
            this.copyKey = copyKey;
            this.copyValue = copyValue;
        }

        @Override
        public Object apply(Object o) {
            if (o == null) {
                return null;
            }
            Map m = (Map)o;
            HashMap<Object, Object> copy = new HashMap<Object, Object>(m.size());
            for (Map.Entry e : m.entrySet()) {
                Object keyCopy = this.copyKey.apply(e.getKey());
                Object valueCopy = this.copyValue.apply(e.getValue());
                copy.put(keyCopy, valueCopy);
            }
            return copy;
        }
    }

    private static class CopyList
    implements Function<Object, Object> {
        private final Function<Object, Object> copyEntry;
        private final Class entryClass;

        CopyList(Function<Object, Object> copyEntry, Class entryClass) {
            this.copyEntry = copyEntry;
            this.entryClass = entryClass;
        }

        @Override
        public Object apply(Object o) {
            if (o == null) {
                return null;
            }
            Object[] l = (Object[])o;
            Object[] copy = (Object[])Array.newInstance(this.entryClass, l.length);
            for (int i = 0; i < l.length; ++i) {
                copy[i] = this.copyEntry.apply(l[i]);
            }
            return copy;
        }
    }

    private static class CopyStruct
    implements Function<Object, Object> {
        private final Function<Object, Object>[] copyFields;

        CopyStruct(Function<Object, Object>[] copyFields) {
            this.copyFields = copyFields;
        }

        @Override
        public Object apply(Object o) {
            if (o == null) {
                return null;
            }
            Row r = (Row)o;
            Row copy = new Row(this.copyFields.length);
            for (int i = 0; i < this.copyFields.length; ++i) {
                copy.setField(i, this.copyFields[i].apply(r.getField(i)));
            }
            return copy;
        }
    }
}

