/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.formats.parquet.avro;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.flink.hive.shaded.formats.parquet.ParquetBuilder;
import org.apache.flink.hive.shaded.formats.parquet.ParquetWriterFactory;
import org.apache.flink.hive.shaded.parquet.avro.AvroParquetWriter;
import org.apache.flink.hive.shaded.parquet.hadoop.ParquetWriter;
import org.apache.flink.hive.shaded.parquet.io.OutputFile;

public class ParquetAvroWriters {
    public static <T extends SpecificRecordBase> ParquetWriterFactory<T> forSpecificRecord(Class<T> type) {
        String schemaString = SpecificData.get().getSchema(type).toString();
        ParquetBuilder builder = out -> ParquetAvroWriters.createAvroParquetWriter(schemaString, (GenericData)SpecificData.get(), out);
        return new ParquetWriterFactory(builder);
    }

    public static ParquetWriterFactory<GenericRecord> forGenericRecord(Schema schema) {
        String schemaString = schema.toString();
        ParquetBuilder builder = out -> ParquetAvroWriters.createAvroParquetWriter(schemaString, GenericData.get(), out);
        return new ParquetWriterFactory<GenericRecord>(builder);
    }

    public static <T> ParquetWriterFactory<T> forReflectRecord(Class<T> type) {
        String schemaString = ReflectData.get().getSchema(type).toString();
        ParquetBuilder builder = out -> ParquetAvroWriters.createAvroParquetWriter(schemaString, (GenericData)ReflectData.get(), out);
        return new ParquetWriterFactory(builder);
    }

    private static <T> ParquetWriter<T> createAvroParquetWriter(String schemaString, GenericData dataModel, OutputFile out) throws IOException {
        Schema schema = new Schema.Parser().parse(schemaString);
        return AvroParquetWriter.builder((OutputFile)out).withSchema(schema).withDataModel(dataModel).build();
    }

    private ParquetAvroWriters() {
    }
}

