/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.hive.shaded.formats.parquet;

import java.util.ArrayList;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.avro.typeutils.AvroConversions;
import org.apache.flink.formats.avro.typeutils.GenericRecordAvroTypeInfo;
import org.apache.flink.hive.shaded.formats.parquet.ParquetInputFormat;
import org.apache.flink.hive.shaded.parquet.avro.AvroSchemaConverter;
import org.apache.flink.hive.shaded.parquet.schema.MessageType;
import org.apache.flink.types.Row;

public class ParquetAvroInputFormat
extends ParquetInputFormat<GenericRecord>
implements ResultTypeQueryable<GenericRecord> {
    private static final long serialVersionUID = 1L;
    private transient Schema avroSchema;
    private String avroSchemaString;

    public ParquetAvroInputFormat(Path filePath, MessageType messageType) {
        super(filePath, messageType);
        this.avroSchema = new AvroSchemaConverter().convert(messageType);
        this.avroSchemaString = this.avroSchema.toString();
    }

    @Override
    public void selectFields(String[] fieldNames) {
        this.avroSchema = this.getProjectedSchema(fieldNames, this.avroSchema);
        this.avroSchemaString = this.avroSchema.toString();
        super.selectFields(fieldNames);
    }

    @Override
    protected GenericRecord convert(Row row) {
        if (this.avroSchema == null) {
            this.avroSchema = new Schema.Parser().parse(this.avroSchemaString);
        }
        return AvroConversions.convertRowToAvroRecord((Schema)this.avroSchema, (Row)row);
    }

    public GenericRecordAvroTypeInfo getProducedType() {
        return new GenericRecordAvroTypeInfo(this.avroSchema);
    }

    private Schema getProjectedSchema(String[] projectedFieldNames, Schema sourceAvroSchema) {
        ArrayList<Schema.Field> projectedFields = new ArrayList<Schema.Field>();
        for (String fieldName : projectedFieldNames) {
            projectedFields.add(this.deepCopyField(sourceAvroSchema.getField(fieldName)));
        }
        return Schema.createRecord((String)(sourceAvroSchema.getName() + "_projected"), (String)sourceAvroSchema.getDoc(), (String)sourceAvroSchema.getNamespace(), (boolean)sourceAvroSchema.isError(), projectedFields);
    }

    private Schema.Field deepCopyField(Schema.Field field) {
        Schema.Field newField = new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal(), field.order());
        for (Map.Entry kv : field.getObjectProps().entrySet()) {
            newField.addProp((String)kv.getKey(), kv.getValue());
        }
        if (field.aliases() != null) {
            for (String alias : field.aliases()) {
                newField.addAlias(alias);
            }
        }
        return newField;
    }

    public Schema getAvroSchema() {
        return this.avroSchema;
    }
}

